/*
 * Decompiled with CFR 0.152.
 */
package com.guokr.nlp.ner;

import com.guokr.protocol.Protocols;
import com.guokr.util.Settings;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import java.util.Properties;

public class NerWrapper {
    static Protocols protocols = Protocols.INSTANCE;
    static Settings defaults = Settings.load((String)"xcf:///ner/defaults.using.prop");
    private CRFClassifier<?> classifier;

    public NerWrapper(Settings settings) {
        Settings props = new Settings((Properties)settings, (Properties)defaults);
        String model = props.getProperty("model");
        try {
            this.classifier = CRFClassifier.getClassifier((String)model, (Properties)props);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace(System.err);
        }
    }

    public NerWrapper() {
        this(null);
    }

    public String recognize(String text) {
        return this.classifier.classifyToString(text).trim();
    }
}

