/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.server.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.gwtplatform.dispatch.server.Dispatch;
import com.gwtplatform.dispatch.server.RequestProvider;
import com.gwtplatform.dispatch.server.actionhandlervalidator.ActionHandlerValidatorRegistry;
import com.gwtplatform.dispatch.server.actionhandlervalidator.LazyActionHandlerValidatorRegistry;
import com.gwtplatform.dispatch.server.guice.DispatchImpl;
import com.gwtplatform.dispatch.server.guice.actionhandlervalidator.ActionHandlerValidatorLinker;
import com.gwtplatform.dispatch.server.guice.actionhandlervalidator.LazyActionHandlerValidatorRegistryImpl;
import com.gwtplatform.dispatch.server.guice.request.DefaultRequestProvider;

public class DispatchModule
extends AbstractModule {
    private Class<? extends Dispatch> dispatchClass;
    private Class<? extends ActionHandlerValidatorRegistry> actionHandlerValidatorRegistryClass;
    private Class<? extends RequestProvider> requestProviderClass;

    public DispatchModule() {
        this(new Builder());
    }

    private DispatchModule(Builder builder) {
        this.dispatchClass = builder.dispatchClass;
        this.actionHandlerValidatorRegistryClass = builder.actionHandlerValidatorRegistryClass;
        this.requestProviderClass = builder.requestProviderClass;
    }

    @Deprecated
    public DispatchModule(Class<? extends Dispatch> dispatchClass) {
        this(new Builder().dispatch(dispatchClass));
    }

    @Deprecated
    public DispatchModule(Class<? extends Dispatch> dispatchClass, Class<? extends ActionHandlerValidatorRegistry> lazyActionHandlerValidatorRegistryClass) {
        this(new Builder().dispatch(dispatchClass).actionHandlerValidatorRegistry(lazyActionHandlerValidatorRegistryClass));
    }

    public boolean equals(Object obj) {
        return obj instanceof DispatchModule;
    }

    public int hashCode() {
        return DispatchModule.class.hashCode();
    }

    protected final void configure() {
        this.bind(ActionHandlerValidatorRegistry.class).to(this.actionHandlerValidatorRegistryClass).in(Singleton.class);
        this.bind(Dispatch.class).to(this.dispatchClass).in(Singleton.class);
        this.bind(RequestProvider.class).to(this.requestProviderClass).in(Singleton.class);
        if (LazyActionHandlerValidatorRegistry.class.isAssignableFrom(this.actionHandlerValidatorRegistryClass)) {
            this.requestStaticInjection(new Class[]{ActionHandlerValidatorLinker.class});
        }
    }

    public static class Builder {
        private Class<? extends Dispatch> dispatchClass = DispatchImpl.class;
        private Class<? extends ActionHandlerValidatorRegistry> actionHandlerValidatorRegistryClass = LazyActionHandlerValidatorRegistryImpl.class;
        private Class<? extends RequestProvider> requestProviderClass = DefaultRequestProvider.class;

        public Builder dispatch(Class<? extends Dispatch> dispatchClass) {
            this.dispatchClass = dispatchClass;
            return this;
        }

        public Builder actionHandlerValidatorRegistry(Class<? extends ActionHandlerValidatorRegistry> actionHandlerValidatorRegistryClass) {
            this.actionHandlerValidatorRegistryClass = actionHandlerValidatorRegistryClass;
            return this;
        }

        public Builder requestProvider(Class<? extends RequestProvider> requestProviderClass) {
            this.requestProviderClass = requestProviderClass;
            return this;
        }

        public DispatchModule build() {
            return new DispatchModule(this);
        }
    }
}

