/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.tester;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import com.gwtplatform.dispatch.client.CompletedDispatchRequest;
import com.gwtplatform.dispatch.client.DelegatingDispatchRequest;
import com.gwtplatform.dispatch.client.actionhandler.ClientActionHandler;
import com.gwtplatform.dispatch.client.actionhandler.ExecuteCommand;
import com.gwtplatform.dispatch.client.actionhandler.UndoCommand;
import com.gwtplatform.dispatch.shared.Action;
import com.gwtplatform.dispatch.shared.DispatchAsync;
import com.gwtplatform.dispatch.shared.DispatchRequest;
import com.gwtplatform.dispatch.shared.DispatchService;
import com.gwtplatform.dispatch.shared.Result;
import com.gwtplatform.tester.MockClientActionHandlerMap;
import com.gwtplatform.tester.TestDispatchService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestDispatchAsync
implements DispatchAsync {
    private DispatchService service;
    private Map<Class<?>, ClientActionHandler<?, ?>> clientActionHandlers;

    @Inject
    public TestDispatchAsync(TestDispatchService service, Injector injector) {
        this.service = service;
        this.clientActionHandlers = new HashMap();
        List bindings = injector.findBindingsByType(TypeLiteral.get(MockClientActionHandlerMap.class));
        for (Binding binding : bindings) {
            MockClientActionHandlerMap mapping = (MockClientActionHandlerMap)binding.getProvider().get();
            this.clientActionHandlers.put(mapping.getActionClass(), mapping.getClientActionHandler());
        }
    }

    public <A extends Action<R>, R extends Result> DispatchRequest execute(A action, AsyncCallback<R> callback) {
        assert (callback != null);
        ClientActionHandler<?, ?> clientActionHandler = this.clientActionHandlers.get(action.getClass());
        if (clientActionHandler != null) {
            DelegatingDispatchRequest request = new DelegatingDispatchRequest();
            clientActionHandler.execute(action, callback, new ExecuteCommand<A, R>(){

                public DispatchRequest execute(A action, AsyncCallback<R> resultCallback) {
                    return TestDispatchAsync.this.serviceExecute(action, resultCallback);
                }
            });
            return request;
        }
        this.serviceExecute(action, callback);
        return new TestingDispatchRequest();
    }

    private <A extends Action<R>, R extends Result> DispatchRequest serviceExecute(A action, AsyncCallback<R> callback) {
        boolean fail = false;
        Result result = null;
        try {
            result = this.service.execute("", action);
        }
        catch (Throwable caught) {
            fail = true;
            callback.onFailure(caught);
        }
        if (!fail) {
            callback.onSuccess((Object)result);
        }
        return new CompletedDispatchRequest();
    }

    public <A extends Action<R>, R extends Result> DispatchRequest undo(A action, R result, AsyncCallback<Void> callback) {
        ClientActionHandler<?, ?> clientActionHandler = this.clientActionHandlers.get(action.getClass());
        if (clientActionHandler != null) {
            DelegatingDispatchRequest request = new DelegatingDispatchRequest();
            clientActionHandler.undo(action, result, callback, new UndoCommand<A, R>(){

                public DispatchRequest undo(A action, R result, AsyncCallback<Void> callback) {
                    return TestDispatchAsync.this.serviceUndo(action, result, (AsyncCallback<Void>)callback);
                }
            });
            return request;
        }
        this.serviceUndo(action, result, callback);
        return new TestingDispatchRequest();
    }

    private <A extends Action<R>, R extends Result> DispatchRequest serviceUndo(A action, R result, AsyncCallback<Void> callback) {
        boolean fail = false;
        try {
            this.service.undo("", action, result);
        }
        catch (Throwable caught) {
            fail = true;
            callback.onFailure(caught);
        }
        if (!fail) {
            callback.onSuccess(null);
        }
        return new CompletedDispatchRequest();
    }

    class TestingDispatchRequest
    implements DispatchRequest {
        public void cancel() {
        }

        public boolean isPending() {
            return false;
        }
    }
}

