/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.table.MetaTable;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.util.ByteUtils;
import org.h2.util.ObjectArray;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;

public class User
extends RightOwner {
    private byte[] salt;
    private byte[] passwordHash;
    private boolean admin;
    private boolean systemUser;

    public User(Database database, int id, String userName, boolean systemUser) {
        super(database, id, userName, "user");
        this.systemUser = systemUser;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean getAdmin() {
        return this.admin;
    }

    public void setSaltAndHash(byte[] salt, byte[] hash) {
        this.salt = salt;
        this.passwordHash = hash;
    }

    public void setUserPasswordHash(byte[] userPasswordHash) {
        if (userPasswordHash != null) {
            this.salt = RandomUtils.getSecureBytes(8);
            SHA256 sha = new SHA256();
            this.passwordHash = sha.getHashWithSalt(userPasswordHash, this.salt);
        }
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw Message.getInternalError();
    }

    public String getCreateSQL() {
        return this.getCreateSQL(true, false);
    }

    public void checkRight(Table table, int rightMask) throws SQLException {
        if (rightMask != 1 && !this.systemUser) {
            this.database.checkWritingAllowed();
        }
        if (this.admin) {
            return;
        }
        Role publicRole = this.database.getPublicRole();
        if (publicRole.isRightGrantedRecursive(table, rightMask)) {
            return;
        }
        if (table instanceof MetaTable || table instanceof RangeTable) {
            return;
        }
        if (!this.isRightGrantedRecursive(table, rightMask)) {
            throw Message.getSQLException(90096, table.getSQL());
        }
    }

    public String getCreateSQL(boolean password, boolean ifNotExists) {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE USER ");
        if (ifNotExists) {
            buff.append("IF NOT EXISTS ");
        }
        buff.append(this.getSQL());
        if (this.comment != null) {
            buff.append(" COMMENT ");
            buff.append(StringUtils.quoteStringSQL(this.comment));
        }
        if (password) {
            buff.append(" SALT '");
            buff.append(ByteUtils.convertBytesToString(this.salt));
            buff.append("' HASH '");
            buff.append(ByteUtils.convertBytesToString(this.passwordHash));
            buff.append("'");
        } else {
            buff.append(" PASSWORD ''");
        }
        if (this.admin) {
            buff.append(" ADMIN");
        }
        return buff.toString();
    }

    public void checkUserPasswordHash(byte[] buff) throws SQLException {
        SHA256 sha = new SHA256();
        byte[] hash = sha.getHashWithSalt(buff, this.salt);
        if (!ByteUtils.compareSecure(hash, this.passwordHash)) {
            throw Message.getSQLException(8004);
        }
    }

    public void checkAdmin() throws SQLException {
        if (!this.admin) {
            throw Message.getSQLException(90040);
        }
    }

    public int getType() {
        return 2;
    }

    public ObjectArray getChildren() {
        ObjectArray all = this.database.getAllRights();
        ObjectArray rights = new ObjectArray();
        for (int i = 0; i < all.size(); ++i) {
            Right right = (Right)all.get(i);
            if (right.getGrantee() != this) continue;
            rights.add(right);
        }
        return rights;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        ObjectArray rights = this.database.getAllRights();
        for (int i = 0; i < rights.size(); ++i) {
            Right right = (Right)rights.get(i);
            if (right.getGrantee() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.salt = null;
        ByteUtils.clear(this.passwordHash);
        this.passwordHash = null;
        this.invalidate();
    }

    public void checkRename() {
    }
}

