/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ConditionNot
extends Condition {
    private Expression condition;

    public ConditionNot(Expression condition) {
        this.condition = condition;
    }

    public void createIndexConditions(TableFilter filter) {
    }

    public Value getValue(Session session) throws SQLException {
        Value v = this.condition.getValue(session);
        if (v == ValueNull.INSTANCE) {
            return v;
        }
        return v.convertTo(1).negate();
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        this.condition.mapColumns(resolver, level);
    }

    public Expression optimize(Session session) throws SQLException {
        Expression expr = this.condition.optimize(session);
        if (expr.isConstant()) {
            Value v = expr.getValue(session);
            if (v == ValueNull.INSTANCE) {
                return ValueExpression.NULL;
            }
            return ValueExpression.get(v.convertTo(1).negate());
        }
        this.condition = expr;
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.condition.setEvaluatable(tableFilter, b);
    }

    public String getSQL() {
        return "(NOT " + this.condition.getSQL() + ")";
    }

    public void updateAggregate(Session session) throws SQLException {
        this.condition.updateAggregate(session);
    }

    public void addFilterConditions(TableFilter filter, boolean outerJoin) {
        if (outerJoin) {
            return;
        }
        super.addFilterConditions(filter, outerJoin);
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        return this.condition.isEverything(visitor);
    }

    public int getCost() {
        return this.condition.getCost();
    }
}

