/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.FunctionCall;
import org.h2.expression.FunctionInfo;
import org.h2.expression.SequenceValue;
import org.h2.expression.ValueExpression;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.schema.Sequence;
import org.h2.security.BlockCipher;
import org.h2.security.CipherFactory;
import org.h2.security.SHA256;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.tools.CompressTool;
import org.h2.tools.Csv;
import org.h2.util.MathUtils;
import org.h2.util.MemoryUtils;
import org.h2.util.ObjectArray;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class Function
extends Expression
implements FunctionCall {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTR = 72;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int CURDATE = 100;
    public static final int CURTIME = 101;
    public static final int DATEADD = 102;
    public static final int DATEDIFF = 103;
    public static final int DAYNAME = 104;
    public static final int DAYOFMONTH = 105;
    public static final int DAYOFWEEK = 106;
    public static final int DAYOFYEAR = 107;
    public static final int HOUR = 108;
    public static final int MINUTE = 109;
    public static final int MONTH = 110;
    public static final int MONTHNAME = 111;
    public static final int NOW = 112;
    public static final int QUARTER = 113;
    public static final int SECOND = 114;
    public static final int WEEK = 115;
    public static final int YEAR = 116;
    public static final int CURRENT_DATE = 117;
    public static final int CURRENT_TIME = 118;
    public static final int CURRENT_TIMESTAMP = 119;
    public static final int EXTRACT = 120;
    public static final int FORMATDATETIME = 121;
    public static final int PARSEDATETIME = 122;
    public static final int DATABASE = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int AUTOCOMMIT = 154;
    public static final int READONLY = 155;
    public static final int DATABASE_PATH = 156;
    public static final int LOCK_TIMEOUT = 157;
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int SCHEMA = 215;
    public static final int SESSION_ID = 216;
    private static final int VARARGS = -1;
    private static HashMap functions;
    private FunctionInfo info;
    private Expression[] args;
    private ObjectArray varargs;
    private int dataType;
    private int scale;
    private long precision;
    private Database database;
    private static HashMap datePart;
    private static final SimpleDateFormat FORMAT_DAYNAME;
    private static final SimpleDateFormat FORMAT_MONTHNAME;
    private static final char[] SOUNDEX_INDEX;

    private static void addFunction(String name, int type, int parameterCount, int dataType, boolean nullIfParameterIsNull, boolean isDeterm) {
        FunctionInfo info = new FunctionInfo();
        info.name = name;
        info.type = type;
        info.parameterCount = parameterCount;
        info.dataType = dataType;
        info.nullIfParameterIsNull = nullIfParameterIsNull;
        info.isDeterministic = isDeterm;
        functions.put(name, info);
    }

    private static void addFunctionNotConst(String name, int type, int parameterCount, int dataType) {
        Function.addFunction(name, type, parameterCount, dataType, true, false);
    }

    private static void addFunction(String name, int type, int parameterCount, int dataType) {
        Function.addFunction(name, type, parameterCount, dataType, true, true);
    }

    private static void addFunctionWithNull(String name, int type, int parameterCount, int dataType) {
        Function.addFunction(name, type, parameterCount, dataType, false, true);
    }

    public static Function getFunction(Database database, String name) throws SQLException {
        FunctionInfo info = (FunctionInfo)functions.get(name);
        if (info == null) {
            return null;
        }
        return new Function(database, info);
    }

    private Function(Database database, FunctionInfo info) {
        this.database = database;
        this.info = info;
        if (info.parameterCount == -1) {
            this.varargs = new ObjectArray();
        } else {
            this.args = new Expression[info.parameterCount];
        }
    }

    public void setParameter(int index, Expression param) throws SQLException {
        if (this.varargs != null) {
            this.varargs.add(param);
        } else {
            if (index >= this.args.length) {
                throw Message.getSQLException(7001, "" + this.args.length);
            }
            this.args[index] = param;
        }
    }

    private strictfp double log10(double value) {
        return this.roundmagic(StrictMath.log(value) / StrictMath.log(10.0));
    }

    public Value getValue(Session session) throws SQLException {
        return this.getValueWithArgs(session, this.args);
    }

    public Value getValueWithArgs(Session session, Expression[] args) throws SQLException {
        Value v1;
        if (this.info.nullIfParameterIsNull) {
            for (int i = 0; i < args.length; ++i) {
                Expression e = args[i];
                if (e == null || e.getValue(session) != ValueNull.INSTANCE) continue;
                return ValueNull.INSTANCE;
            }
        }
        Value v0 = args.length < 1 || args[0] == null ? null : args[0].getValue(session);
        switch (this.info.type) {
            case 200: {
                return v0 == ValueNull.INSTANCE ? args[1].getValue(session) : v0;
            }
            case 201: {
                if (v0 == ValueNull.INSTANCE) {
                    return v0;
                }
                Expression result = v0.getBoolean() != false ? args[1] : args[2];
                return result.getValue(session);
            }
            case 204: {
                for (int i = 0; i < args.length; ++i) {
                    Value v;
                    Value value = v = i == 0 ? v0 : args[i].getValue(session);
                    if (v == ValueNull.INSTANCE) continue;
                    return v.convertTo(this.dataType);
                }
                return v0;
            }
            case 206: {
                int i;
                for (i = 0; i < args.length; ++i) {
                    Value when;
                    if (!Boolean.TRUE.equals(when = args[i++].getValue(session))) continue;
                    return args[i].getValue(session);
                }
                return i < args.length ? args[i].getValue(session) : ValueNull.INSTANCE;
            }
            case 209: {
                if (v0.getType() == 17) {
                    v1 = args[1].getValue(session);
                    int element = v1.getInt();
                    Value[] list = ((ValueArray)v0).getList();
                    if (element < 1 || element > list.length) {
                        return ValueNull.INSTANCE;
                    }
                    return list[element - 1];
                }
                return ValueNull.INSTANCE;
            }
        }
        v1 = args.length < 2 || args[1] == null ? null : args[1].getValue(session);
        Value v2 = args.length < 3 || args[2] == null ? null : args[2].getValue(session);
        switch (this.info.type) {
            case 0: {
                return v0.getSignum() > 0 ? v0 : v0.negate();
            }
            case 1: {
                return ValueDouble.get(Math.acos(v0.getDouble()));
            }
            case 2: {
                return ValueDouble.get(Math.asin(v0.getDouble()));
            }
            case 3: {
                return ValueDouble.get(Math.atan(v0.getDouble()));
            }
            case 4: {
                return ValueDouble.get(Math.atan2(v0.getDouble(), v1.getDouble()));
            }
            case 5: {
                return ValueInt.get(v0.getInt() & v1.getInt());
            }
            case 6: {
                return ValueInt.get(v0.getInt() | v1.getInt());
            }
            case 7: {
                return ValueInt.get(v0.getInt() ^ v1.getInt());
            }
            case 8: {
                return ValueDouble.get(Math.ceil(v0.getDouble()));
            }
            case 9: {
                return ValueDouble.get(Math.cos(v0.getDouble()));
            }
            case 10: {
                double d = Math.tan(v0.getDouble());
                if (d == 0.0) {
                    throw Message.getSQLException(22012, this.getSQL());
                }
                return ValueDouble.get(1.0 / d);
            }
            case 11: {
                return ValueDouble.get(Math.toDegrees(v0.getDouble()));
            }
            case 12: {
                return ValueDouble.get(Math.exp(v0.getDouble()));
            }
            case 13: {
                return ValueDouble.get(Math.floor(v0.getDouble()));
            }
            case 14: {
                return ValueDouble.get(Math.log(v0.getDouble()));
            }
            case 15: {
                return ValueDouble.get(this.log10(v0.getDouble()));
            }
            case 16: {
                int x = v1.getInt();
                if ((double)x == 0.0) {
                    throw Message.getSQLException(22012, this.getSQL());
                }
                return ValueInt.get(v0.getInt() % x);
            }
            case 17: {
                return ValueDouble.get(Math.PI);
            }
            case 18: {
                return ValueDouble.get(Math.pow(v0.getDouble(), v1.getDouble()));
            }
            case 19: {
                return ValueDouble.get(Math.toRadians(v0.getDouble()));
            }
            case 20: {
                if (v0 != null) {
                    session.getRandom().setSeed(v0.getInt());
                }
                return ValueDouble.get(session.getRandom().nextDouble());
            }
            case 21: {
                double f = Math.pow(10.0, v1.getDouble());
                return ValueDouble.get((double)Math.round(v0.getDouble() * f) / f);
            }
            case 22: {
                return ValueDouble.get(this.roundmagic(v0.getDouble()));
            }
            case 23: {
                return ValueInt.get(v0.getSignum());
            }
            case 24: {
                return ValueDouble.get(Math.sin(v0.getDouble()));
            }
            case 25: {
                return ValueDouble.get(Math.sqrt(v0.getDouble()));
            }
            case 26: {
                return ValueDouble.get(Math.tan(v0.getDouble()));
            }
            case 27: {
                double d = v0.getDouble();
                int p = v1.getInt();
                double f = Math.pow(10.0, p);
                double g = d * f;
                return ValueDouble.get((d < 0.0 ? Math.ceil(g) : Math.floor(g)) / f);
            }
            case 28: {
                return ValueBytes.get(RandomUtils.getSecureBytes(v0.getInt()));
            }
            case 29: {
                return ValueBytes.get(this.getHash(v0.getString(), v1.getBytes(), v2.getInt()));
            }
            case 30: {
                return ValueBytes.get(this.encrypt(v0.getString(), v1.getBytes(), v2.getBytes()));
            }
            case 31: {
                return ValueBytes.get(this.decrypt(v0.getString(), v1.getBytes(), v2.getBytes()));
            }
            case 32: {
                String algorithm = null;
                if (v1 != null) {
                    algorithm = v1.getString();
                }
                return ValueBytes.get(CompressTool.getInstance().compress(v0.getBytes(), algorithm));
            }
            case 33: {
                return ValueBytes.get(CompressTool.getInstance().expand(v0.getBytes()));
            }
            case 34: {
                return ValueInt.get(0);
            }
            case 35: {
                return ValueUuid.getNewRandom();
            }
            case 50: {
                String s = v0.getString();
                if (s.length() == 0) {
                    return ValueNull.INSTANCE;
                }
                return ValueInt.get(s.charAt(0));
            }
            case 51: {
                return ValueInt.get(16 * this.length(v0));
            }
            case 52: {
                return ValueString.get(String.valueOf((char)v0.getInt()));
            }
            case 53: 
            case 61: {
                return ValueInt.get(this.length(v0));
            }
            case 64: {
                return ValueInt.get(2 * this.length(v0));
            }
            case 54: {
                Value concat = ValueNull.INSTANCE;
                for (int i = 0; i < args.length; ++i) {
                    Value v = args[i].getValue(session);
                    if (v == ValueNull.INSTANCE) continue;
                    concat = concat == ValueNull.INSTANCE ? v : ValueString.get(((Value)concat).getString().concat(v.getString()));
                }
                return concat;
            }
            case 55: {
                return ValueInt.get(Function.getDifference(v0.getString(), v1.getString()));
            }
            case 56: {
                return ValueString.get(Function.hexToRaw(v0.getString()));
            }
            case 57: {
                if (v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE) {
                    return v1;
                }
                Value v3 = args[3].getValue(session);
                return ValueString.get(Function.insert(v0.getString(), v1.getInt(), v2.getInt(), v3.getString()));
            }
            case 59: 
            case 75: {
                return ValueString.get(v0.getString().toLowerCase());
            }
            case 60: {
                return ValueString.get(Function.left(v0.getString(), v1.getInt()));
            }
            case 62: {
                int start = v2 == null ? 0 : v2.getInt();
                return ValueInt.get(Function.locate(v0.getString(), v1.getString(), start));
            }
            case 58: {
                int start = v2 == null ? 0 : v2.getInt();
                return ValueInt.get(Function.locate(v1.getString(), v0.getString(), start));
            }
            case 65: {
                return ValueString.get(Function.rawToHex(v0.getString()));
            }
            case 66: {
                int count = Math.max(0, v1.getInt());
                return ValueString.get(Function.repeat(v0.getString(), count));
            }
            case 67: {
                String s0 = v0 == ValueNull.INSTANCE ? "" : v0.getString();
                String s1 = v1 == ValueNull.INSTANCE ? "" : v1.getString();
                String s2 = v2 == null || v2 == ValueNull.INSTANCE ? "" : v2.getString();
                return ValueString.get(Function.replace(s0, s1, s2));
            }
            case 68: {
                return ValueString.get(Function.right(v0.getString(), v1.getInt()));
            }
            case 63: {
                return ValueString.get(Function.trim(v0.getString(), true, false, v1 == null ? " " : v1.getString()));
            }
            case 78: {
                return ValueString.get(Function.trim(v0.getString(), true, true, v1 == null ? " " : v1.getString()));
            }
            case 69: {
                return ValueString.get(Function.trim(v0.getString(), false, true, v1 == null ? " " : v1.getString()));
            }
            case 70: {
                return ValueString.get(Function.getSoundex(v0.getString()));
            }
            case 71: {
                int len = Math.max(0, v0.getInt());
                char[] chars = new char[len];
                for (int i = len - 1; i >= 0; --i) {
                    chars[i] = 32;
                }
                return ValueString.get(new String(chars));
            }
            case 72: 
            case 73: {
                String s = v0.getString();
                int length = v2 == null ? s.length() : v2.getInt();
                return ValueString.get(Function.substring(s, v1.getInt(), length));
            }
            case 77: {
                return ValueInt.get(Function.locate(v0.getString(), v1.getString(), 0));
            }
            case 74: 
            case 76: {
                return ValueString.get(v0.getString().toUpperCase());
            }
            case 79: {
                return ValueString.get(StringUtils.javaEncode(v0.getString()));
            }
            case 80: {
                return ValueString.get(StringUtils.javaDecode(v0.getString()));
            }
            case 81: {
                return ValueBytes.get(StringUtils.utf8Encode(v0.getString()));
            }
            case 82: {
                return ValueString.get(StringUtils.utf8Decode(v0.getBytes()));
            }
            case 83: {
                return ValueString.get(StringUtils.xmlAttr(v0.getString(), v1.getString()));
            }
            case 84: {
                String attr;
                String string = v1 == null ? null : (attr = v1 == ValueNull.INSTANCE ? null : v1.getString());
                String content = v2 == null ? null : (v2 == ValueNull.INSTANCE ? null : v2.getString());
                return ValueString.get(StringUtils.xmlNode(v0.getString(), attr, content));
            }
            case 85: {
                return ValueString.get(StringUtils.xmlComment(v0.getString()));
            }
            case 86: {
                return ValueString.get(StringUtils.xmlCData(v0.getString()));
            }
            case 87: {
                return ValueString.get(StringUtils.xmlStartDoc());
            }
            case 88: {
                return ValueString.get(StringUtils.xmlText(v0.getString()));
            }
            case 102: {
                return ValueTimestamp.get(Function.dateadd(v0.getString(), v1.getInt(), v2.getTimestamp()));
            }
            case 103: {
                return ValueLong.get(Function.datediff(v0.getString(), v1.getTimestamp(), v2.getTimestamp()));
            }
            case 104: {
                return ValueString.get(FORMAT_DAYNAME.format(v0.getDate()));
            }
            case 105: {
                return ValueInt.get(Function.getDatePart(v0.getTimestamp(), 5));
            }
            case 106: {
                return ValueInt.get(Function.getDatePart(v0.getTimestamp(), 7));
            }
            case 107: {
                return ValueInt.get(Function.getDatePart(v0.getTimestamp(), 6));
            }
            case 108: {
                return ValueInt.get(Function.getDatePart(v0.getTimestamp(), 11));
            }
            case 109: {
                return ValueInt.get(Function.getDatePart(v0.getTimestamp(), 12));
            }
            case 110: {
                return ValueInt.get(Function.getDatePart(v0.getTimestamp(), 2));
            }
            case 111: {
                return ValueString.get(FORMAT_MONTHNAME.format(v0.getDate()));
            }
            case 113: {
                return ValueInt.get((Function.getDatePart(v0.getTimestamp(), 2) - 1) / 3 + 1);
            }
            case 114: {
                return ValueInt.get(Function.getDatePart(v0.getTimestamp(), 13));
            }
            case 115: {
                return ValueInt.get(Function.getDatePart(v0.getTimestamp(), 3));
            }
            case 116: {
                return ValueInt.get(Function.getDatePart(v0.getTimestamp(), 1));
            }
            case 100: 
            case 117: {
                return ValueDate.get(new Date(System.currentTimeMillis()));
            }
            case 101: 
            case 118: {
                return ValueTime.get(new Time(System.currentTimeMillis()));
            }
            case 112: 
            case 119: {
                ValueTimestamp vt = ValueTimestamp.get(new Timestamp(System.currentTimeMillis()));
                if (v0 != null) {
                    vt = (ValueTimestamp)vt.convertScale(Mode.getCurrentMode().convertOnlyToSmallerScale, v0.getInt());
                }
                return vt;
            }
            case 120: {
                int field = Function.getDatePart(v0.getString());
                return ValueInt.get(Function.getDatePart(v1.getTimestamp(), field));
            }
            case 121: {
                Value v3;
                if (v0 == ValueNull.INSTANCE || v1 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                String locale = v2 == null ? null : (v2 == ValueNull.INSTANCE ? null : v2.getString());
                Value value = v3 = args.length <= 3 ? null : args[3].getValue(session);
                String tz = v3 == null ? null : (v3 == ValueNull.INSTANCE ? null : v3.getString());
                return ValueString.get(StringUtils.formatDateTime(v0.getTimestamp(), v1.getString(), locale, tz));
            }
            case 122: {
                Value v3;
                if (v0 == ValueNull.INSTANCE || v1 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                String locale = v2 == null ? null : (v2 == ValueNull.INSTANCE ? null : v2.getString());
                Value value = v3 = args.length <= 3 ? null : args[3].getValue(session);
                String tz = v3 == null ? null : (v3 == ValueNull.INSTANCE ? null : v3.getString());
                java.util.Date d = StringUtils.parseDateTime(v0.getString(), v1.getString(), locale, tz);
                return ValueTimestamp.get(new Timestamp(d.getTime()));
            }
            case 150: {
                return ValueString.get(this.database.getShortName());
            }
            case 151: 
            case 152: {
                return ValueString.get(session.getUser().getName());
            }
            case 153: {
                return ValueLong.get(session.getLastIdentity());
            }
            case 154: {
                return ValueBoolean.get(session.getAutoCommit());
            }
            case 155: {
                return ValueBoolean.get(this.database.getReadOnly());
            }
            case 156: {
                String path = this.database.getDatabasePath();
                return path == null ? ValueNull.INSTANCE : ValueString.get(path);
            }
            case 157: {
                return ValueInt.get(session.getLockTimeout());
            }
            case 205: {
                return this.database.areEqual(v0, v1) ? ValueNull.INSTANCE : v0;
            }
            case 202: 
            case 203: {
                v0 = v0.convertTo(this.dataType);
                v0 = v0.convertScale(Mode.getCurrentMode().convertOnlyToSmallerScale, this.scale);
                v0 = v0.convertPrecision(this.precision);
                return v0;
            }
            case 207: {
                Sequence sequence = this.getSequence(session, v0, v1);
                SequenceValue value = new SequenceValue(sequence);
                return value.getValue(session);
            }
            case 208: {
                Sequence sequence = this.getSequence(session, v0, v1);
                return ValueLong.get(sequence.getCurrentValue());
            }
            case 210: {
                String fileName = v0.getString();
                String columnList = v1 == null ? null : v1.getString();
                String[] columns = StringUtils.arraySplit(columnList, ',', true);
                String charset = v2 == null ? null : v2.getString();
                ValueResultSet vr = ValueResultSet.get(Csv.getInstance().read(fileName, columns, charset));
                return vr;
            }
            case 211: {
                JdbcConnection conn = session.createConnection(false);
                String charset = v2 == null ? null : v2.getString();
                Csv.getInstance().write(conn, v0.getString(), v1.getString(), charset);
                return ValueNull.INSTANCE;
            }
            case 212: {
                session.getUser().checkAdmin();
                return ValueInt.get(MemoryUtils.getMemoryFree());
            }
            case 213: {
                session.getUser().checkAdmin();
                return ValueInt.get(MemoryUtils.getMemoryUsed());
            }
            case 214: {
                return ValueInt.get(this.database.getLockMode());
            }
            case 215: {
                return ValueString.get(session.getCurrentSchemaName());
            }
            case 216: {
                return ValueInt.get(session.getId());
            }
        }
        throw Message.getInternalError("type=" + this.info.type);
    }

    Sequence getSequence(Session session, Value v0, Value v1) throws SQLException {
        String sequenceName;
        String schemaName;
        if (v1 == null) {
            schemaName = session.getCurrentSchemaName();
            sequenceName = StringUtils.toUpperEnglish(v0.getString());
        } else {
            schemaName = v0.getString();
            sequenceName = v1.getString();
        }
        return this.database.getSchema(schemaName).getSequence(sequenceName);
    }

    private int length(Value v) throws SQLException {
        switch (v.getType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return (int)v.getPrecision();
            }
        }
        return v.getString().length();
    }

    private byte[] getPaddedArrayCopy(byte[] data, int blockSize) {
        int size = MathUtils.roundUp(data.length, blockSize);
        byte[] newData = new byte[size];
        System.arraycopy(data, 0, newData, 0, data.length);
        return newData;
    }

    private byte[] decrypt(String algorithm, byte[] key, byte[] data) throws SQLException {
        BlockCipher cipher = CipherFactory.getBlockCipher(algorithm);
        byte[] newKey = this.getPaddedArrayCopy(key, cipher.getKeyLength());
        cipher.setKey(newKey);
        byte[] newData = this.getPaddedArrayCopy(data, 16);
        cipher.decrypt(newData, 0, newData.length);
        return newData;
    }

    private byte[] encrypt(String algorithm, byte[] key, byte[] data) throws SQLException {
        BlockCipher cipher = CipherFactory.getBlockCipher(algorithm);
        byte[] newKey = this.getPaddedArrayCopy(key, cipher.getKeyLength());
        cipher.setKey(newKey);
        byte[] newData = this.getPaddedArrayCopy(data, 16);
        cipher.encrypt(newData, 0, newData.length);
        return newData;
    }

    private byte[] getHash(String algorithm, byte[] bytes, int iterations) throws SQLException {
        SHA256 hash = CipherFactory.getHash(algorithm);
        for (int i = 0; i < iterations; ++i) {
            bytes = hash.getHash(bytes);
        }
        return bytes;
    }

    private static int getDatePart(Timestamp d, int field) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        int value = c.get(field);
        if (field == 2) {
            ++value;
        }
        return value;
    }

    private static int getDatePart(String part) throws SQLException {
        Integer p = (Integer)datePart.get(StringUtils.toUpperEnglish(part));
        if (p == null) {
            throw Message.getSQLException(90008, new String[]{"part", part}, null);
        }
        return p;
    }

    private static Timestamp dateadd(String part, int count, Timestamp d) throws SQLException {
        int field = Function.getDatePart(part);
        Calendar calendar = Calendar.getInstance();
        int nanos = d.getNanos() % 1000000;
        calendar.setTime(d);
        calendar.add(field, count);
        calendar.get(1);
        calendar.get(11);
        long t = calendar.getTime().getTime();
        Timestamp ts = new Timestamp(t);
        ts.setNanos(ts.getNanos() + nanos);
        return ts;
    }

    private static long datediff(String part, Timestamp d1, Timestamp d2) throws SQLException {
        int field = Function.getDatePart(part);
        Calendar calendar = Calendar.getInstance();
        long t1 = d1.getTime();
        long t2 = d2.getTime();
        TimeZone zone = calendar.getTimeZone();
        calendar.setTime(d1);
        t1 += (long)zone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        calendar.setTime(d2);
        t2 += (long)zone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        switch (field) {
            case 14: {
                return t2 - t1;
            }
            case 10: 
            case 12: 
            case 13: {
                long hour = 3600000L;
                long add = Math.min(t1 / hour * hour, t2 / hour * hour);
                t1 -= add;
                t2 -= add;
                switch (field) {
                    case 13: {
                        return t2 / 1000L - t1 / 1000L;
                    }
                    case 12: {
                        return t2 / 60000L - t1 / 60000L;
                    }
                    case 10: {
                        return t2 / hour - t1 / hour;
                    }
                }
                throw Message.getInternalError("field:" + field);
            }
            case 5: {
                return t2 / 86400000L - t1 / 86400000L;
            }
        }
        calendar.setTime(new Timestamp(t1));
        int year1 = calendar.get(1);
        int month1 = calendar.get(2);
        calendar.setTime(new Timestamp(t2));
        int year2 = calendar.get(1);
        int month2 = calendar.get(2);
        int result = year2 - year1;
        if (field == 2) {
            result = 12 * result + (month2 - month1);
        }
        return result;
    }

    private static String substring(String s, int start, int length) {
        int len = s.length();
        if (--start < 0) {
            start = 0;
        }
        if (length < 0) {
            length = 0;
        }
        int n = start = start > len ? len : start;
        if (start + length > len) {
            length = len - start;
        }
        return s.substring(start, start + length);
    }

    private static String trim(String s, boolean leading, boolean trailing, String sp) {
        int i;
        char space;
        char c = space = sp == null || sp.length() < 1 ? (char)' ' : (char)sp.charAt(0);
        if (leading) {
            int len = s.length();
            for (i = 0; i < len && s.charAt(i) == space; ++i) {
            }
            String string = s = i == 0 ? s : s.substring(i);
        }
        if (trailing) {
            int endindex;
            for (i = endindex = s.length() - 1; i >= 0 && s.charAt(i) == space; --i) {
            }
            s = i == endindex ? s : s.substring(0, i + 1);
        }
        return s;
    }

    private static String replace(String s, String replace, String with) {
        int i;
        if (replace == null || replace.length() == 0) {
            return s;
        }
        StringBuffer buff = new StringBuffer();
        int start = 0;
        int len = replace.length();
        while ((i = s.indexOf(replace, start)) != -1) {
            buff.append(s.substring(start, i));
            buff.append(with);
            start = i + len;
        }
        buff.append(s.substring(start));
        return buff.toString();
    }

    private static String repeat(String s, int count) {
        StringBuffer buff = new StringBuffer(s.length() * count);
        while (count-- > 0) {
            buff.append(s);
        }
        return buff.toString();
    }

    private static String rawToHex(String s) {
        StringBuffer buff = new StringBuffer(4 * s.length());
        for (int i = 0; i < s.length(); ++i) {
            String hex = Integer.toHexString(s.charAt(i) & 0xFFFF);
            for (int j = hex.length(); j < 4; ++j) {
                buff.append('0');
            }
            buff.append(hex);
        }
        return buff.toString();
    }

    private static int locate(String search, String s, int start) {
        int i = start < 0 ? 0 : start - 1;
        return s.indexOf(search, i) + 1;
    }

    private static String right(String s, int count) {
        if (count < 0) {
            count = 0;
        } else if (count > s.length()) {
            count = s.length();
        }
        return s.substring(s.length() - count);
    }

    private static String left(String s, int count) {
        if (count < 0) {
            count = 0;
        } else if (count > s.length()) {
            count = s.length();
        }
        return s.substring(0, count);
    }

    private static String insert(String s1, int start, int length, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        if (--start < 0 || length <= 0 || len2 == 0 || start > len1) {
            return s1;
        }
        if (start + length > len1) {
            length = len1 - start;
        }
        return s1.substring(0, start) + s2 + s1.substring(start + length);
    }

    private static String hexToRaw(String s) throws SQLException {
        int len = s.length();
        if (len % 4 != 0) {
            throw Message.getSQLException(90021, s);
        }
        StringBuffer buff = new StringBuffer(len / 4);
        for (int i = 0; i < len; i += 4) {
            try {
                char raw = (char)Integer.parseInt(s.substring(i, i + 4), 16);
                buff.append(raw);
                continue;
            }
            catch (NumberFormatException e) {
                throw Message.getSQLException(90021, s);
            }
        }
        return buff.toString();
    }

    private static int getDifference(String s1, String s2) {
        s1 = Function.getSoundex(s1);
        s2 = Function.getSoundex(s2);
        int e = 0;
        for (int i = 0; i < 4; ++i) {
            if (s1.charAt(i) != s2.charAt(i)) continue;
            ++e;
        }
        return e;
    }

    private double roundmagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuffer s = new StringBuffer();
        s.append(d);
        if (s.toString().indexOf("E") >= 0) {
            return d;
        }
        int len = s.length();
        if (len < 16) {
            return d;
        }
        if (s.toString().indexOf(".") > len - 3) {
            return d;
        }
        s.delete(len - 2, len);
        char c1 = s.charAt((len -= 2) - 2);
        char c2 = s.charAt(len - 3);
        char c3 = s.charAt(len - 4);
        if (c1 == '0' && c2 == '0' && c3 == '0') {
            s.setCharAt(len - 1, '0');
        } else if (c1 == '9' && c2 == '9' && c3 == '9') {
            s.setCharAt(len - 1, '9');
            s.append('9');
            s.append('9');
            s.append('9');
        }
        return Double.valueOf(s.toString());
    }

    private static String getSoundex(String s) {
        int len = s.length();
        char[] chars = new char[]{'0', '0', '0', '0'};
        char lastdigit = '0';
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            char newdigit;
            char c = s.charAt(i);
            char c2 = newdigit = c > SOUNDEX_INDEX.length ? (char)'\u0000' : SOUNDEX_INDEX[c];
            if (newdigit == '\u0000') continue;
            if (j == 0) {
                chars[j++] = c;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit <= '6') {
                if (newdigit == lastdigit) continue;
                chars[j++] = newdigit;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit != '7') continue;
            lastdigit = newdigit;
        }
        return new String(chars);
    }

    public int getType() {
        return this.dataType;
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].mapColumns(resolver, level);
        }
    }

    public void doneWithParameters() throws SQLException {
        if (this.info.parameterCount == -1) {
            boolean ok;
            int len = this.varargs.size();
            int min = 0;
            int max = Integer.MAX_VALUE;
            switch (this.info.type) {
                case 204: {
                    min = 1;
                    break;
                }
                case 20: 
                case 112: 
                case 119: {
                    max = 1;
                    break;
                }
                case 32: 
                case 63: 
                case 69: 
                case 78: {
                    max = 2;
                    break;
                }
                case 58: 
                case 62: 
                case 67: 
                case 72: 
                case 73: {
                    min = 2;
                    max = 3;
                    break;
                }
                case 54: 
                case 206: {
                    min = 2;
                    break;
                }
                case 210: {
                    min = 1;
                    break;
                }
                case 211: {
                    min = 2;
                    break;
                }
                case 84: {
                    min = 1;
                    max = 3;
                    break;
                }
                case 121: 
                case 122: {
                    min = 2;
                    max = 4;
                    break;
                }
                case 207: 
                case 208: {
                    min = 1;
                    max = 2;
                    break;
                }
                default: {
                    throw Message.getInternalError("type=" + this.info.type);
                }
            }
            boolean bl = ok = len >= min && len <= max;
            if (!ok) {
                throw Message.getSQLException(7001, min + ".." + max);
            }
            this.args = new Expression[len];
            this.varargs.toArray(this.args);
            this.varargs = null;
        } else {
            int len = this.args.length;
            if (len > 0 && this.args[len - 1] == null) {
                throw Message.getSQLException(7001, "" + len);
            }
        }
    }

    public void setDataType(int dataType, long precision, int scale) {
        this.dataType = dataType;
        this.precision = precision;
        this.scale = scale;
    }

    public void setDataType(Column col) {
        this.dataType = col.getType();
        this.precision = col.getPrecision();
        this.scale = col.getScale();
    }

    public Expression optimize(Session session) throws SQLException {
        boolean allConst = this.info.isDeterministic;
        for (int i = 0; i < this.args.length; ++i) {
            Expression e;
            this.args[i] = e = this.args[i].optimize(session);
            if (e.isConstant()) continue;
            allConst = false;
        }
        Expression p0 = this.args.length < 1 ? null : this.args[0];
        block0 : switch (this.info.type) {
            case 204: {
                this.dataType = 13;
                this.scale = 0;
                this.precision = 0L;
                for (int i = 0; i < this.args.length; ++i) {
                    Expression e = this.args[i];
                    if (e == ValueExpression.NULL) continue;
                    this.dataType = e.getType();
                    this.scale = e.getScale();
                    this.precision = e.getPrecision();
                    break block0;
                }
                break;
            }
            case 201: {
                this.dataType = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                this.precision = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                this.scale = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 202: 
            case 203: {
                break;
            }
            case 0: 
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 27: {
                this.dataType = p0.getType();
                this.scale = p0.getScale();
                this.precision = p0.getPrecision();
                break;
            }
            default: {
                this.dataType = this.info.dataType;
                this.scale = 0;
                this.precision = 0L;
            }
        }
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (int i = 0; i < this.args.length; ++i) {
            Expression e = this.args[i];
            if (e == null) continue;
            e.setEvaluatable(tableFilter, b);
        }
    }

    public int getScale() {
        return this.scale;
    }

    public long getPrecision() {
        return this.precision;
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.info.name);
        buff.append('(');
        switch (this.info.type) {
            case 202: 
            case 203: {
                buff.append(StringUtils.unEnclose(this.args[0].getSQL()));
                buff.append(" AS ");
                buff.append(new Column(null, this.dataType, this.precision, this.scale).getCreateSQL());
                break;
            }
            case 120: {
                ValueString v = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                buff.append(v.getString());
                buff.append(" FROM ");
                buff.append(StringUtils.unEnclose(this.args[1].getSQL()));
                break;
            }
            default: {
                for (int i = 0; i < this.args.length; ++i) {
                    if (i > 0) {
                        buff.append(", ");
                    }
                    Expression e = this.args[i];
                    buff.append(StringUtils.unEnclose(e.getSQL()));
                }
            }
        }
        buff.append(')');
        return buff.toString();
    }

    public void updateAggregate(Session session) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            Expression e = this.args[i];
            if (e == null) continue;
            e.updateAggregate(session);
        }
    }

    public int getFunctionType() {
        return this.info.type;
    }

    public String getName() {
        return this.info.name;
    }

    public int getParameterCount() {
        return this.args.length;
    }

    public ValueResultSet getValueForColumnList(Session session, Expression[] args) throws SQLException {
        if (this.info.type == 210) {
            String fileName = args[0].getValue(session).getString();
            if (fileName == null) {
                throw Message.getSQLException(90012, "fileName");
            }
            String columnList = args.length < 2 ? null : args[1].getValue(session).getString();
            String[] columns = StringUtils.arraySplit(columnList, ',', true);
            String charset = args.length < 3 ? null : args[2].getValue(session).getString();
            ResultSet rs = Csv.getInstance().read(fileName, columns, charset);
            ValueResultSet vr = ValueResultSet.getCopy(rs, 0);
            return vr;
        }
        return (ValueResultSet)this.getValueWithArgs(session, args);
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        for (int i = 0; i < this.args.length; ++i) {
            Expression e = this.args[i];
            if (e == null || e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        int cost = 3;
        for (int i = 0; i < this.args.length; ++i) {
            cost += this.args[i].getCost();
        }
        return cost;
    }

    static {
        FORMAT_DAYNAME = new SimpleDateFormat("EEEE", Locale.ENGLISH);
        FORMAT_MONTHNAME = new SimpleDateFormat("MMMM", Locale.ENGLISH);
        SOUNDEX_INDEX = new char[128];
        datePart = new HashMap();
        datePart.put("YY", new Integer(1));
        datePart.put("YEAR", new Integer(1));
        datePart.put("MM", new Integer(2));
        datePart.put("MONTH", new Integer(2));
        datePart.put("DD", new Integer(5));
        datePart.put("DAY", new Integer(5));
        datePart.put("HH", new Integer(10));
        datePart.put("HOUR", new Integer(10));
        datePart.put("MI", new Integer(12));
        datePart.put("MINUTE", new Integer(12));
        datePart.put("SS", new Integer(13));
        datePart.put("SECOND", new Integer(13));
        datePart.put("MS", new Integer(14));
        datePart.put("MILLISECOND", new Integer(14));
        String index = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char number = '\u0000';
        for (int i = 0; i < index.length(); ++i) {
            char c = index.charAt(i);
            if (c < '9') {
                number = c;
                continue;
            }
            Function.SOUNDEX_INDEX[c] = number;
            Function.SOUNDEX_INDEX[Character.toLowerCase((char)c)] = number;
        }
        functions = new HashMap();
        Function.addFunction("ABS", 0, 1, 0);
        Function.addFunction("ACOS", 1, 1, 7);
        Function.addFunction("ASIN", 2, 1, 7);
        Function.addFunction("ATAN", 3, 1, 7);
        Function.addFunction("ATAN2", 4, 2, 7);
        Function.addFunction("BITAND", 5, 2, 4);
        Function.addFunction("BITOR", 6, 2, 4);
        Function.addFunction("BITXOR", 7, 2, 4);
        Function.addFunction("CEILING", 8, 1, 7);
        Function.addFunction("COS", 9, 1, 7);
        Function.addFunction("COT", 10, 1, 7);
        Function.addFunction("DEGREES", 11, 1, 7);
        Function.addFunction("EXP", 12, 1, 7);
        Function.addFunction("FLOOR", 13, 1, 7);
        Function.addFunction("LOG", 14, 1, 7);
        Function.addFunction("LOG10", 15, 1, 7);
        Function.addFunction("MOD", 16, 2, 4);
        Function.addFunction("PI", 17, 0, 7);
        Function.addFunction("POWER", 18, 2, 7);
        Function.addFunction("RADIANS", 19, 1, 7);
        Function.addFunctionNotConst("RAND", 20, -1, 7);
        Function.addFunction("ROUND", 21, 2, 7);
        Function.addFunction("ROUNDMAGIC", 22, 1, 7);
        Function.addFunction("SIGN", 23, 1, 4);
        Function.addFunction("SIN", 24, 1, 7);
        Function.addFunction("SQRT", 25, 1, 7);
        Function.addFunction("TAN", 26, 1, 7);
        Function.addFunction("TRUNCATE", 27, 2, 7);
        Function.addFunction("HASH", 29, 3, 12);
        Function.addFunction("ENCRYPT", 30, 3, 12);
        Function.addFunction("DECRYPT", 31, 3, 12);
        Function.addFunctionNotConst("SECURE_RAND", 28, 1, 12);
        Function.addFunction("COMPRESS", 32, -1, 12);
        Function.addFunction("EXPAND", 33, 1, 12);
        Function.addFunction("ZERO", 34, 0, 4);
        Function.addFunctionNotConst("RANDOM_UUID", 35, 0, 20);
        Function.addFunctionNotConst("SYS_GUID", 35, 0, 20);
        Function.addFunction("ASCII", 50, 1, 4);
        Function.addFunction("BIT_LENGTH", 51, 1, 4);
        Function.addFunction("CHAR", 52, 1, 13);
        Function.addFunction("CHAR_LENGTH", 53, 1, 4);
        Function.addFunction("CHARACTER_LENGTH", 53, 1, 4);
        Function.addFunctionWithNull("CONCAT", 54, -1, 13);
        Function.addFunction("DIFFERENCE", 55, 2, 4);
        Function.addFunction("HEXTORAW", 56, 1, 13);
        Function.addFunctionWithNull("INSERT", 57, 4, 13);
        Function.addFunction("LCASE", 59, 1, 13);
        Function.addFunction("LEFT", 60, 2, 13);
        Function.addFunction("LENGTH", 61, 1, 4);
        Function.addFunction("LOCATE", 62, -1, 4);
        Function.addFunction("POSITION", 62, 2, 4);
        Function.addFunction("INSTR", 58, -1, 4);
        Function.addFunction("LTRIM", 63, -1, 13);
        Function.addFunction("OCTET_LENGTH", 64, 1, 4);
        Function.addFunction("RAWTOHEX", 65, 1, 13);
        Function.addFunction("REPEAT", 66, 2, 13);
        Function.addFunctionWithNull("REPLACE", 67, -1, 13);
        Function.addFunction("RIGHT", 68, 2, 13);
        Function.addFunction("RTRIM", 69, -1, 13);
        Function.addFunction("SOUNDEX", 70, 1, 13);
        Function.addFunction("SPACE", 71, 1, 13);
        Function.addFunction("SUBSTR", 72, -1, 13);
        Function.addFunction("SUBSTRING", 73, -1, 13);
        Function.addFunction("UCASE", 74, 1, 13);
        Function.addFunction("LOWER", 75, 1, 13);
        Function.addFunction("UPPER", 76, 1, 13);
        Function.addFunction("POSITION", 77, 2, 4);
        Function.addFunction("TRIM", 78, -1, 13);
        Function.addFunction("STRINGENCODE", 79, 1, 13);
        Function.addFunction("STRINGDECODE", 80, 1, 13);
        Function.addFunction("STRINGTOUTF8", 81, 1, 12);
        Function.addFunction("UTF8TOSTRING", 82, 1, 13);
        Function.addFunction("XMLATTR", 83, 2, 13);
        Function.addFunctionWithNull("XMLNODE", 84, -1, 13);
        Function.addFunction("XMLCOMMENT", 85, 1, 13);
        Function.addFunction("XMLCDATA", 86, 1, 13);
        Function.addFunction("XMLSTARTDOC", 87, 0, 13);
        Function.addFunction("XMLTEXT", 88, 1, 13);
        Function.addFunctionNotConst("CURRENT_DATE", 117, 0, 10);
        Function.addFunctionNotConst("CURDATE", 100, 0, 10);
        Function.addFunctionNotConst("CURRENT_TIME", 118, 0, 9);
        Function.addFunctionNotConst("CURTIME", 101, 0, 9);
        Function.addFunctionNotConst("CURRENT_TIMESTAMP", 119, -1, 11);
        Function.addFunctionNotConst("NOW", 112, -1, 11);
        Function.addFunction("DATEADD", 102, 3, 11);
        Function.addFunction("DATEDIFF", 103, 3, 5);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAY", 105, 1, 4);
        Function.addFunction("DAYOFMONTH", 105, 1, 4);
        Function.addFunction("DAYOFWEEK", 106, 1, 4);
        Function.addFunction("DAYOFYEAR", 107, 1, 4);
        Function.addFunction("HOUR", 108, 1, 4);
        Function.addFunction("MINUTE", 109, 1, 4);
        Function.addFunction("MONTH", 110, 1, 4);
        Function.addFunction("MONTHNAME", 111, 1, 13);
        Function.addFunction("QUARTER", 113, 1, 4);
        Function.addFunction("SECOND", 114, 1, 4);
        Function.addFunction("WEEK", 115, 1, 4);
        Function.addFunction("YEAR", 116, 1, 4);
        Function.addFunction("EXTRACT", 120, 2, 4);
        Function.addFunctionWithNull("FORMATDATETIME", 121, -1, 13);
        Function.addFunctionWithNull("PARSEDATETIME", 122, -1, 11);
        Function.addFunctionNotConst("DATABASE", 150, 0, 13);
        Function.addFunctionNotConst("USER", 151, 0, 13);
        Function.addFunctionNotConst("CURRENT_USER", 152, 0, 13);
        Function.addFunctionNotConst("IDENTITY", 153, 0, 5);
        Function.addFunctionNotConst("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.addFunctionNotConst("LAST_INSERT_ID", 153, 0, 5);
        Function.addFunctionNotConst("AUTOCOMMIT", 154, 0, 1);
        Function.addFunctionNotConst("READONLY", 155, 0, 1);
        Function.addFunction("DATABASE_PATH", 156, 0, 13);
        Function.addFunction("LOCK_TIMEOUT", 157, 0, 4);
        Function.addFunctionWithNull("IFNULL", 200, 2, 0);
        Function.addFunctionWithNull("CASEWHEN", 201, 3, 0);
        Function.addFunctionWithNull("CONVERT", 202, 1, 0);
        Function.addFunctionWithNull("CAST", 203, 1, 0);
        Function.addFunctionWithNull("COALESCE", 204, -1, 0);
        Function.addFunctionWithNull("NVL", 204, -1, 0);
        Function.addFunctionWithNull("NULLIF", 205, 2, 0);
        Function.addFunctionWithNull("CASE", 206, -1, 0);
        Function.addFunctionNotConst("NEXTVAL", 207, -1, 5);
        Function.addFunctionNotConst("CURRVAL", 208, -1, 5);
        Function.addFunction("ARRAY_GET", 209, 2, 0);
        Function.addFunction("CSVREAD", 210, -1, 18, false, false);
        Function.addFunction("CSVWRITE", 211, -1, 18, false, false);
        Function.addFunctionNotConst("MEMORY_FREE", 212, 0, 4);
        Function.addFunctionNotConst("MEMORY_USED", 213, 0, 4);
        Function.addFunctionNotConst("LOCK_MODE", 214, 0, 4);
        Function.addFunctionNotConst("SCHEMA", 215, 0, 13);
        Function.addFunctionNotConst("SESSION_ID", 216, 0, 4);
    }
}

