/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.Session;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class TableFilter
implements ColumnResolver {
    private Session session;
    private Table table;
    private String alias;
    private static final int BEFORE_FIRST = 0;
    private static final int FOUND = 1;
    private static final int AFTER_LAST = 2;
    private static final int NULL_ROW = 3;
    private Index index;
    private Cursor cursor;
    private int scanCount;
    private boolean used;
    private ObjectArray indexConditions = new ObjectArray();
    private Expression filterCondition;
    private Expression joinCondition;
    private Row current;
    private int state;
    private TableFilter join;
    private boolean outerJoin;
    private boolean foundOne;
    private Expression fullCondition;
    private boolean rightsChecked;

    public TableFilter(Session session, Table table, String alias, boolean rightsChecked) {
        this.session = session;
        this.table = table;
        this.alias = alias;
        this.rightsChecked = rightsChecked;
    }

    public Session getSession() {
        return this.session;
    }

    public Table getTable() {
        return this.table;
    }

    public void lock(Session session, boolean exclusive) throws SQLException {
        if (!this.rightsChecked) {
            session.getUser().checkRight(this.table, 1);
        }
        this.table.lock(session, exclusive);
        if (this.join != null) {
            this.join.lock(session, exclusive);
        }
    }

    public PlanItem getBestPlanItem(Session session) throws SQLException {
        PlanItem item;
        if (this.indexConditions.size() == 0) {
            item = new PlanItem();
            item.index = this.table.getScanIndex(session);
            item.cost = item.index.getCost(null);
        } else {
            int len = this.table.getColumns().length;
            int[] masks = new int[len];
            for (int i = 0; i < this.indexConditions.size(); ++i) {
                int id;
                IndexCondition condition = (IndexCondition)this.indexConditions.get(i);
                if (!condition.isEvaluatable()) continue;
                if (condition.isAlwaysFalse()) {
                    masks = null;
                    break;
                }
                int n = id = condition.getColumn().getColumnId();
                masks[n] = masks[n] | condition.getMask();
            }
            item = this.table.getBestPlanItem(session, masks);
        }
        if (this.join != null) {
            TableFilter j = this.join;
            do {
                Expression e;
                if ((e = j.getJoinCondition()) == null) continue;
                e.setEvaluatable(this, true);
            } while ((j = j.getJoin()) != null);
            item.joinPlan = this.join.getBestPlanItem(session);
            item.cost += item.cost * item.joinPlan.cost;
        }
        return item;
    }

    public void setPlanItem(PlanItem item) {
        this.index = item.index;
        if (this.join != null && item.joinPlan != null) {
            this.join.setPlanItem(item.joinPlan);
        }
    }

    public void prepare() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            Column col;
            IndexCondition condition = (IndexCondition)this.indexConditions.get(i);
            if (condition.isAlwaysFalse() || this.index.getColumnIndex(col = condition.getColumn()) >= 0) continue;
            this.indexConditions.remove(i);
            --i;
        }
        if (this.join != null) {
            if (Constants.CHECK && this.join == this) {
                throw Message.getInternalError("self join");
            }
            this.join.prepare();
        }
    }

    public void startQuery() {
        this.scanCount = 0;
        if (this.join != null) {
            this.join.startQuery();
        }
    }

    public void reset() throws SQLException {
        if (this.join != null) {
            this.join.reset();
        }
        this.state = 0;
        this.foundOne = false;
    }

    public boolean next() throws SQLException {
        boolean alwaysFalse = false;
        if (this.state == 2) {
            return false;
        }
        if (this.state == 0) {
            Row start = null;
            Row end = null;
            for (int i = 0; i < this.indexConditions.size(); ++i) {
                IndexCondition condition = (IndexCondition)this.indexConditions.get(i);
                if (condition.isAlwaysFalse()) {
                    alwaysFalse = true;
                    break;
                }
                Column column = condition.getColumn();
                int type = column.getType();
                int id = column.getColumnId();
                Value v = condition.getCurrentValue(this.session).convertTo(type);
                if (condition.isStart()) {
                    if (start == null) {
                        start = this.table.getTemplateRow();
                    }
                    start.setValue(id, v);
                }
                if (!condition.isEnd()) continue;
                if (end == null) {
                    end = this.table.getTemplateRow();
                }
                end.setValue(id, v);
            }
            if (!alwaysFalse) {
                this.cursor = this.index.find(this.session, start, end);
                if (this.join != null) {
                    this.join.reset();
                }
            }
        } else if (this.join != null && this.join.next()) {
            return true;
        }
        while (this.state != 3) {
            if (alwaysFalse) {
                this.state = 2;
            } else {
                ++this.scanCount;
                if (this.cursor.next()) {
                    this.current = this.cursor.get();
                    this.state = 1;
                } else {
                    this.state = 2;
                }
            }
            if (this.state == 2) {
                if (!this.outerJoin || this.foundOne) break;
                this.state = 3;
                this.current = this.table.getNullRow();
            }
            if (!this.isOk(this.filterCondition)) continue;
            boolean joinConditionOk = this.isOk(this.joinCondition);
            if (this.state == 1 && joinConditionOk) {
                this.foundOne = true;
            }
            if (this.join != null) {
                this.join.reset();
                if (!this.join.next()) continue;
            }
            if (this.state != 3 && !joinConditionOk) continue;
            return true;
        }
        this.state = 2;
        return false;
    }

    private boolean isOk(Expression condition) throws SQLException {
        if (condition == null) {
            return true;
        }
        return Boolean.TRUE.equals(condition.getBooleanValue(this.session));
    }

    public Row get() {
        return this.current;
    }

    public void set(Row current) {
        this.current = current;
    }

    public String getTableAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.table.getName();
    }

    public void addIndexCondition(IndexCondition condition) {
        this.indexConditions.add(condition);
    }

    public void addFilterCondition(Expression condition, boolean join) {
        if (join) {
            this.joinCondition = this.joinCondition == null ? condition : new ConditionAndOr(0, this.joinCondition, condition);
        } else {
            this.filterCondition = this.filterCondition == null ? condition : new ConditionAndOr(0, this.filterCondition, condition);
        }
    }

    public void addJoin(TableFilter filter, boolean outer, Expression on) throws SQLException {
        if (on != null) {
            on.mapColumns(this, 0);
        }
        if (this.join == null) {
            this.join = filter;
            filter.outerJoin = outer;
            if (on != null) {
                TableFilter f = filter;
                do {
                    on.mapColumns(f, 0);
                    f.addFilterCondition(on, true);
                    on.createIndexConditions(f);
                } while ((f = f.join) != null);
            }
        } else {
            this.join.addJoin(filter, outer, on);
        }
        if (on != null) {
            on = on.optimize(this.session);
        }
    }

    public TableFilter getJoin() {
        return this.join;
    }

    public boolean isJoinOuter() {
        return this.outerJoin;
    }

    public String getPlanSQL(boolean join) {
        StringBuffer buff = new StringBuffer();
        if (join) {
            if (this.outerJoin) {
                buff.append("LEFT OUTER JOIN ");
            } else {
                buff.append("INNER JOIN ");
            }
        }
        buff.append(this.table.getSQL());
        if (this.alias != null && !this.table.getName().equals(this.alias)) {
            buff.append(' ');
            buff.append(this.alias);
        }
        buff.append(" /* ");
        buff.append(this.index.getPlanSQL());
        if (this.indexConditions.size() > 0) {
            buff.append(": ");
            for (int i = 0; i < this.indexConditions.size(); ++i) {
                IndexCondition condition = (IndexCondition)this.indexConditions.get(i);
                if (i > 0) {
                    buff.append(" AND ");
                }
                buff.append(condition.getSQL());
            }
        }
        buff.append(" */");
        if (this.joinCondition != null) {
            buff.append(" ON ");
            buff.append(StringUtils.unEnclose(this.joinCondition.getSQL()));
        }
        if (this.filterCondition != null) {
            buff.append(" /* WHERE ");
            buff.append(StringUtils.unEnclose(this.filterCondition.getSQL()));
            buff.append("*/");
        }
        return buff.toString();
    }

    public void removeUnusableIndexConditions() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            IndexCondition cond = (IndexCondition)this.indexConditions.get(i);
            if (cond.isEvaluatable()) continue;
            this.indexConditions.remove(i--);
        }
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean getUsed() {
        return this.used;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void removeJoin() {
        this.join = null;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void removeJoinCondition() {
        this.joinCondition = null;
    }

    public Expression getFilterCondition() {
        return this.filterCondition;
    }

    public void removeFilterCondition() {
        this.filterCondition = null;
    }

    public void setFullCondition(Expression condition) {
        this.fullCondition = condition;
        if (this.join != null) {
            this.join.setFullCondition(condition);
        }
    }

    public void optimizeFullCondition(boolean fromOuterJoin) {
        if (this.fullCondition != null) {
            this.fullCondition.addFilterConditions(this, fromOuterJoin || this.outerJoin);
            if (this.join != null) {
                this.join.optimizeFullCondition(fromOuterJoin || this.outerJoin);
            }
        }
    }

    public void setEvaluatable(TableFilter filter, boolean b) {
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(filter, b);
        }
        if (this.joinCondition != null) {
            this.joinCondition.setEvaluatable(filter, b);
        }
        if (this.join != null) {
            this.join.setEvaluatable(filter, b);
        }
    }

    public String getSchemaName() {
        return this.table.getSchema().getName();
    }

    public Column[] getColumns() {
        return this.table.getColumns();
    }

    public Value getValue(Column column) {
        return this.current == null ? null : this.current.getValue(column.getColumnId());
    }

    public TableFilter getTableFilter() {
        return this;
    }
}

