/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import [Ljava.lang.Object;;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import org.h2.engine.SessionInterface;
import org.h2.message.Message;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.util.TypeConverter;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class DataType {
    private static ObjectArray types = new ObjectArray();
    private static HashMap typesByName = new HashMap();
    private static DataType[] typesByValueType = new DataType[21];
    public int type;
    public String name;
    public int sqlType;
    public String jdbc;
    public int order;
    public int maxPrecision;
    public int minScale;
    public int maxScale;
    public boolean decimal;
    public String prefix;
    public String suffix;
    public String params;
    public boolean autoInc;
    public boolean caseSensitive;
    public boolean supportsPrecision;
    public boolean supportsScale;
    public long defaultPrecision;
    public int defaultScale;
    public boolean hidden;

    private static void add(int type, int sqlType, String jdbc, DataType dataType, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            DataType dt = new DataType();
            dt.type = type;
            dt.sqlType = sqlType;
            dt.jdbc = jdbc;
            dt.name = names[i];
            dt.autoInc = dataType.autoInc;
            dt.decimal = dataType.decimal;
            dt.maxPrecision = dataType.maxPrecision;
            dt.maxScale = dataType.maxScale;
            dt.minScale = dataType.minScale;
            dt.params = dataType.params;
            dt.prefix = dataType.prefix;
            dt.suffix = dataType.suffix;
            dt.supportsPrecision = dataType.supportsPrecision;
            dt.supportsScale = dataType.supportsScale;
            dt.defaultPrecision = dataType.defaultPrecision;
            dt.defaultScale = dataType.defaultScale;
            dt.caseSensitive = dataType.caseSensitive;
            dt.hidden = i > 0;
            for (int j = 0; j < types.size(); ++j) {
                DataType t2 = (DataType)types.get(j);
                if (t2.sqlType != dt.sqlType) continue;
                ++dt.order;
            }
            typesByName.put(dt.name, dt);
            if (typesByValueType[type] == null) {
                DataType.typesByValueType[type] = dt;
            }
            types.add(dt);
        }
    }

    public static String getJdbcString(int type) {
        return DataType.typesByValueType[type].jdbc;
    }

    private static DataType createDecimal(int maxPrecision, int defaultPrecision, int defaultScale, boolean needsPrecisionAndScale, boolean autoInc) {
        DataType dataType = new DataType();
        dataType.maxPrecision = maxPrecision;
        dataType.defaultPrecision = defaultPrecision;
        dataType.defaultScale = defaultScale;
        if (needsPrecisionAndScale) {
            dataType.params = "PRECISION,SCALE";
            dataType.supportsPrecision = true;
            dataType.supportsScale = true;
        }
        dataType.decimal = true;
        dataType.autoInc = autoInc;
        return dataType;
    }

    private static DataType createDate(int precision, String prefix, int scale) {
        DataType dataType = new DataType();
        dataType.prefix = prefix + " '";
        dataType.suffix = "'";
        dataType.maxPrecision = precision;
        dataType.supportsScale = scale != 0;
        dataType.maxScale = scale;
        dataType.defaultPrecision = precision;
        dataType.defaultScale = scale;
        return dataType;
    }

    private static DataType createString(boolean caseSensitive) {
        DataType dataType = new DataType();
        dataType.prefix = "'";
        dataType.suffix = "'";
        dataType.params = "LENGTH";
        dataType.caseSensitive = caseSensitive;
        dataType.supportsPrecision = true;
        dataType.maxPrecision = Integer.MAX_VALUE;
        dataType.defaultPrecision = Integer.MAX_VALUE;
        return dataType;
    }

    public static ObjectArray getTypes() {
        return types;
    }

    /*
     * WARNING - void declaration
     */
    public static Value readValue(SessionInterface session, ResultSet rs, int columnIndex, int type) throws SQLException {
        void var4_21;
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                byte[] buff = rs.getBytes(columnIndex);
                Value v = buff == null ? ValueNull.INSTANCE : ValueBytes.get(buff);
                break;
            }
            case 20: {
                byte[] buff = rs.getBytes(columnIndex);
                Value v = buff == null ? ValueNull.INSTANCE : ValueUuid.get(buff);
                break;
            }
            case 1: {
                boolean value = rs.getBoolean(columnIndex);
                Value v = rs.wasNull() ? ValueNull.INSTANCE : ValueBoolean.get(value);
                break;
            }
            case 2: {
                byte value = rs.getByte(columnIndex);
                Value v = rs.wasNull() ? ValueNull.INSTANCE : ValueByte.get(value);
                break;
            }
            case 10: {
                Date value = rs.getDate(columnIndex);
                Value v = value == null ? ValueNull.INSTANCE : ValueDate.get(value);
                break;
            }
            case 9: {
                Time value = rs.getTime(columnIndex);
                Value v = value == null ? ValueNull.INSTANCE : ValueTime.get(value);
                break;
            }
            case 11: {
                Timestamp value = rs.getTimestamp(columnIndex);
                Value v = value == null ? ValueNull.INSTANCE : ValueTimestamp.get(value);
                break;
            }
            case 6: {
                BigDecimal value = rs.getBigDecimal(columnIndex);
                Value v = value == null ? ValueNull.INSTANCE : ValueDecimal.get(value);
                break;
            }
            case 7: {
                double value = rs.getDouble(columnIndex);
                Value v = rs.wasNull() ? ValueNull.INSTANCE : ValueDouble.get(value);
                break;
            }
            case 8: {
                float value = rs.getFloat(columnIndex);
                Value v = rs.wasNull() ? ValueNull.INSTANCE : ValueFloat.get(value);
                break;
            }
            case 4: {
                int value = rs.getInt(columnIndex);
                Value v = rs.wasNull() ? ValueNull.INSTANCE : ValueInt.get(value);
                break;
            }
            case 5: {
                long value = rs.getLong(columnIndex);
                Value v = rs.wasNull() ? ValueNull.INSTANCE : ValueLong.get(value);
                break;
            }
            case 3: {
                short value = rs.getShort(columnIndex);
                Value v = rs.wasNull() ? ValueNull.INSTANCE : ValueShort.get(value);
                break;
            }
            case 13: 
            case 14: {
                String s = rs.getString(columnIndex);
                Value v = s == null ? ValueNull.INSTANCE : ValueString.get(s);
                break;
            }
            case 16: {
                Value v;
                if (session == null) {
                    v = ValueLob.createSmallLob(16, StringUtils.utf8Encode(rs.getString(columnIndex)));
                    break;
                }
                Reader in = rs.getCharacterStream(columnIndex);
                v = in == null ? ValueNull.INSTANCE : ValueLob.createClob(in, -1L, session.getDataHandler());
                break;
            }
            case 15: {
                Value v;
                if (session == null) {
                    v = ValueLob.createSmallLob(15, rs.getBytes(columnIndex));
                    break;
                }
                InputStream in = rs.getBinaryStream(columnIndex);
                v = in == null ? ValueNull.INSTANCE : ValueLob.createBlob(in, -1L, session.getDataHandler());
                break;
            }
            case 19: {
                byte[] buff = rs.getBytes(columnIndex);
                Value v = buff == null ? ValueNull.INSTANCE : ValueJavaObject.get(buff);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + type);
            }
        }
        return var4_21;
    }

    public static String getTypeClassName(int type) {
        switch (type) {
            case 1: {
                return Boolean.class.getName();
            }
            case 2: {
                return Byte.class.getName();
            }
            case 3: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case 5: {
                return Long.class.getName();
            }
            case 6: {
                return BigDecimal.class.getName();
            }
            case 9: {
                return Time.class.getName();
            }
            case 10: {
                return Date.class.getName();
            }
            case 11: {
                return Timestamp.class.getName();
            }
            case 12: 
            case 20: {
                return [B.class.getName();
            }
            case 13: 
            case 14: {
                return String.class.getName();
            }
            case 15: {
                return Blob.class.getName();
            }
            case 16: {
                return Clob.class.getName();
            }
            case 7: {
                return Double.class.getName();
            }
            case 8: {
                return Float.class.getName();
            }
            case 0: {
                return null;
            }
            case 19: {
                return Object.class.getName();
            }
        }
        throw Message.getInternalError("type=" + type);
    }

    public static DataType getDataType(int type) {
        DataType dt = typesByValueType[type];
        if (dt == null) {
            dt = typesByValueType[0];
        }
        return dt;
    }

    public static int convertTypeToSQLType(int type) {
        return DataType.getDataType((int)type).sqlType;
    }

    public static int convertSQLTypeToValueType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return 13;
            }
            case 2: 
            case 3: {
                return 6;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case -6: {
                return 2;
            }
            case -5: {
                return 5;
            }
            case 7: {
                return 8;
            }
            case 6: 
            case 8: {
                return 7;
            }
            case -4: 
            case -3: 
            case -2: {
                return 12;
            }
            case 1111: 
            case 2000: {
                return 19;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 11;
            }
            case 2004: {
                return 15;
            }
            case 2005: {
                return 16;
            }
            case 0: {
                return 0;
            }
        }
        throw Message.getSQLException(50004, "" + sqlType);
    }

    public static int getTypeFromClass(Class x) throws SQLException {
        if (x == null) {
            return 0;
        }
        if (ResultSet.class.isAssignableFrom(x)) {
            return 18;
        }
        if (String.class.isAssignableFrom(x)) {
            return 13;
        }
        if (BigDecimal.class.isAssignableFrom(x)) {
            return 6;
        }
        if (Boolean.class.isAssignableFrom(x) || Boolean.TYPE.isAssignableFrom(x)) {
            return 1;
        }
        if (Byte.class.isAssignableFrom(x) || Byte.TYPE.isAssignableFrom(x)) {
            return 2;
        }
        if (Short.class.isAssignableFrom(x) || Short.TYPE.isAssignableFrom(x)) {
            return 3;
        }
        if (Integer.class.isAssignableFrom(x) || Integer.TYPE.isAssignableFrom(x)) {
            return 4;
        }
        if (Character.class.isAssignableFrom(x) || Character.TYPE.isAssignableFrom(x)) {
            throw Message.getSQLException(90021, "char (not supported)");
        }
        if (Long.class.isAssignableFrom(x) || Long.TYPE.isAssignableFrom(x)) {
            return 5;
        }
        if (Float.class.isAssignableFrom(x) || Float.TYPE.isAssignableFrom(x)) {
            return 8;
        }
        if (Double.class.isAssignableFrom(x) || Double.TYPE.isAssignableFrom(x)) {
            return 7;
        }
        if ([B.class.isAssignableFrom(x)) {
            return 12;
        }
        if (Date.class.isAssignableFrom(x)) {
            return 10;
        }
        if (Time.class.isAssignableFrom(x)) {
            return 9;
        }
        if (Timestamp.class.isAssignableFrom(x)) {
            return 11;
        }
        if (java.util.Date.class.isAssignableFrom(x)) {
            return 10;
        }
        if (Reader.class.isAssignableFrom(x)) {
            return 16;
        }
        if (Clob.class.isAssignableFrom(x)) {
            return 16;
        }
        if (InputStream.class.isAssignableFrom(x)) {
            return 15;
        }
        if (Blob.class.isAssignableFrom(x)) {
            return 15;
        }
        if (Object;.class.isAssignableFrom(x)) {
            return 17;
        }
        if (Void.TYPE == x) {
            return 0;
        }
        return 19;
    }

    public static Value convertToValue(SessionInterface session, Object x, int type) throws SQLException {
        if (x == null) {
            return ValueNull.INSTANCE;
        }
        if (type == 19) {
            return ValueJavaObject.get(TypeConverter.serialize(x));
        }
        if (x instanceof String) {
            return ValueString.get((String)x);
        }
        if (x instanceof BigDecimal) {
            return ValueDecimal.get((BigDecimal)x);
        }
        if (x instanceof Boolean) {
            return ValueBoolean.get((Boolean)x);
        }
        if (x instanceof Byte) {
            return ValueByte.get((Byte)x);
        }
        if (x instanceof Short) {
            return ValueShort.get((Short)x);
        }
        if (x instanceof Integer) {
            return ValueInt.get((Integer)x);
        }
        if (x instanceof Long) {
            return ValueLong.get((Long)x);
        }
        if (x instanceof Float) {
            return ValueFloat.get(((Float)x).floatValue());
        }
        if (x instanceof Double) {
            return ValueDouble.get((Double)x);
        }
        if (x instanceof byte[]) {
            return ValueBytes.get((byte[])x);
        }
        if (x instanceof Date) {
            return ValueDate.get((Date)x);
        }
        if (x instanceof Time) {
            return ValueTime.get((Time)x);
        }
        if (x instanceof Timestamp) {
            return ValueTimestamp.get((Timestamp)x);
        }
        if (x instanceof java.util.Date) {
            return ValueDate.get(new Date(((java.util.Date)x).getTime()));
        }
        if (x instanceof Reader) {
            return ValueLob.createClob((Reader)x, -1L, session.getDataHandler());
        }
        if (x instanceof Clob) {
            return ValueLob.createClob(((Clob)x).getCharacterStream(), -1L, session.getDataHandler());
        }
        if (x instanceof InputStream) {
            return ValueLob.createBlob((InputStream)x, -1L, session.getDataHandler());
        }
        if (x instanceof Blob) {
            return ValueLob.createBlob(((Blob)x).getBinaryStream(), -1L, session.getDataHandler());
        }
        if (x instanceof ResultSet) {
            return ValueResultSet.get((ResultSet)x);
        }
        if (x instanceof Object[]) {
            Object[] o = (Object[])x;
            int len = o.length;
            Value[] v = new Value[len];
            for (int i = 0; i < len; ++i) {
                v[i] = DataType.convertToValue(session, o[i], type);
            }
            return ValueArray.get(v);
        }
        return ValueJavaObject.get(TypeConverter.serialize(x));
    }

    public static DataType getTypeByName(String s) {
        return (DataType)typesByName.get(s);
    }

    public static boolean isLargeObject(int type) {
        return type == 15 || type == 16;
    }

    public static boolean supportsAdd(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static java.util.Date parseDateTime(String s, int type, int errorCode) throws SQLException {
        if (s == null) {
            return null;
        }
        try {
            int timeStart;
            if (type == 9) {
                timeStart = 0;
            } else {
                timeStart = s.indexOf(32) + 1;
                if (timeStart <= 0) {
                    timeStart = s.indexOf(84) + 1;
                }
            }
            int year = 1970;
            int month = 1;
            int day = 1;
            if (type != 9) {
                int s1 = s.indexOf(45);
                int s2 = s.indexOf(45, s1 + 1);
                if (s1 <= 0 || s2 <= s1) {
                    throw Message.getSQLException(errorCode, s);
                }
                year = Integer.parseInt(s.substring(0, s1));
                month = Integer.parseInt(s.substring(s1 + 1, s2));
                int end = timeStart == 0 ? s.length() : timeStart - 1;
                day = Integer.parseInt(s.substring(s2 + 1, end));
            }
            int hour = 0;
            int minute = 0;
            int second = 0;
            int nano = 0;
            if (type != 10) {
                int s1 = s.indexOf(58, timeStart);
                int s2 = s.indexOf(58, s1 + 1);
                int s3 = s.indexOf(46, s2 + 1);
                if (s1 <= 0 || s2 <= s1) {
                    throw Message.getSQLException(errorCode, s);
                }
                hour = Integer.parseInt(s.substring(timeStart, s1));
                minute = Integer.parseInt(s.substring(s1 + 1, s2));
                if (s3 < 0) {
                    second = Integer.parseInt(s.substring(s2 + 1));
                } else {
                    second = Integer.parseInt(s.substring(s2 + 1, s3));
                    String n = (s + "000000000").substring(s3 + 1, s3 + 10);
                    nano = Integer.parseInt(n);
                }
            }
            Calendar c = Calendar.getInstance();
            c.setLenient(false);
            c.set(1, year);
            c.set(2, month - 1);
            c.set(5, day);
            c.set(11, hour);
            c.set(12, minute);
            c.set(13, second);
            if (type != 11) {
                c.set(14, nano / 1000000);
            }
            long time = c.getTime().getTime();
            switch (type) {
                case 10: {
                    return new Date(time);
                }
                case 9: {
                    return new Time(time);
                }
                case 11: {
                    Timestamp ts = new Timestamp(time);
                    ts.setNanos(nano);
                    return ts;
                }
            }
            throw Message.getInternalError("type:" + type);
        }
        catch (IllegalArgumentException e) {
            throw Message.getSQLException(errorCode, s);
        }
    }

    static {
        DataType.add(0, 0, "Null", new DataType(), new String[]{"NULL"});
        DataType.add(1, 16, "Boolean", DataType.createDecimal(1, 1, 0, false, false), new String[]{"BOOLEAN", "BIT", "BOOL"});
        DataType.add(2, -6, "Byte", DataType.createDecimal(3, 3, 0, false, false), new String[]{"TINYINT"});
        DataType.add(3, 5, "Short", DataType.createDecimal(5, 5, 0, false, false), new String[]{"SMALLINT", "YEAR", "INT2"});
        DataType.add(4, 4, "Int", DataType.createDecimal(10, 10, 0, false, false), new String[]{"INTEGER", "INT", "MEDIUMINT", "INT4", "SIGNED"});
        DataType.add(5, -5, "Long", DataType.createDecimal(19, 19, 0, false, false), new String[]{"BIGINT", "INT8"});
        DataType.add(5, -5, "Long", DataType.createDecimal(19, 19, 0, false, true), new String[]{"IDENTITY"});
        DataType.add(6, 3, "BigDecimal", DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, true, false), new String[]{"DECIMAL", "DEC"});
        DataType.add(6, 2, "BigDecimal", DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, true, false), new String[]{"NUMERIC", "NUMBER"});
        DataType.add(7, 8, "Double", DataType.createDecimal(17, 17, 0, false, false), new String[]{"DOUBLE", "DOUBLE PRECISION"});
        DataType.add(7, 6, "Double", DataType.createDecimal(17, 17, 0, false, false), new String[]{"FLOAT", "FLOAT8"});
        DataType.add(8, 7, "Float", DataType.createDecimal(7, 7, 0, false, false), new String[]{"REAL", "FLOAT4"});
        DataType.add(9, 92, "Time", DataType.createDate(6, "TIME", 0), new String[]{"TIME"});
        DataType.add(10, 91, "Date", DataType.createDate(8, "DATE", 0), new String[]{"DATE"});
        DataType.add(11, 93, "Timestamp", DataType.createDate(23, "TIMESTAMP", 10), new String[]{"TIMESTAMP", "DATETIME", "SMALLDATETIME"});
        DataType.add(12, -3, "Bytes", DataType.createString(false), new String[]{"VARBINARY"});
        DataType.add(12, -2, "Bytes", DataType.createString(false), new String[]{"BINARY", "RAW", "BYTEA", "LONG RAW"});
        DataType.add(20, -2, "Bytes", DataType.createString(false), new String[]{"UUID"});
        DataType.add(12, -4, "Bytes", DataType.createString(false), new String[]{"LONGVARBINARY"});
        DataType.add(19, 1111, "Object", DataType.createString(false), new String[]{"OTHER", "OBJECT", "JAVA_OBJECT"});
        DataType.add(13, 12, "String", DataType.createString(true), new String[]{"VARCHAR", "VARCHAR2", "NVARCHAR", "NVARCHAR2", "VARCHAR_CASESENSITIVE"});
        DataType.add(13, -1, "String", DataType.createString(true), new String[]{"LONGVARCHAR"});
        DataType.add(13, 1, "String", DataType.createString(true), new String[]{"CHAR", "CHARACTER", "NCHAR"});
        DataType.add(14, 12, "String", DataType.createString(false), new String[]{"VARCHAR_IGNORECASE"});
        DataType.add(15, 2004, "Bytes", DataType.createString(false), new String[]{"BLOB", "TINYBLOB", "MEDIUMBLOB", "LONGBLOB", "IMAGE", "OID"});
        DataType.add(16, 2005, "String", DataType.createString(true), new String[]{"CLOB", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "NTEXT", "NCLOB"});
    }
}

