/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueFloat
extends Value {
    public static final int PRECISION = 7;
    private float value;
    private static final float FLOAT_ZERO = 0.0f;
    private static final float FLOAT_ONE = 1.0f;
    private static final ValueFloat ZERO = new ValueFloat(0.0f);
    private static final ValueFloat ONE = new ValueFloat(1.0f);

    private ValueFloat(float value) {
        this.value = value;
    }

    public Value add(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        return ValueFloat.get(this.value + v2.value);
    }

    public Value subtract(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        return ValueFloat.get(this.value - v2.value);
    }

    public Value negate() {
        return ValueFloat.get(-this.value);
    }

    public Value multiply(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        return ValueFloat.get(this.value * v2.value);
    }

    public Value divide(Value v) throws SQLException {
        ValueFloat v2 = (ValueFloat)v;
        if ((double)v2.value == 0.0) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        return ValueFloat.get(this.value / v2.value);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 8;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueFloat v = (ValueFloat)o;
        if (this.value == v.value) {
            return 0;
        }
        return this.value > v.value ? 1 : -1;
    }

    public int getSignum() {
        return this.value == 0.0f ? 0 : (this.value < 0.0f ? -1 : 1);
    }

    public float getFloat() {
        return this.value;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 7L;
    }

    public int getScale() {
        return 0;
    }

    public int hashCode() {
        long hash = Float.floatToIntBits(this.value);
        return (int)(hash ^ hash >> 32);
    }

    public Object getObject() {
        return new Float(this.value);
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setFloat(parameterIndex, this.value);
    }

    public static ValueFloat get(float d) {
        if (0.0f == d) {
            return ZERO;
        }
        if (1.0f == d) {
            return ONE;
        }
        return (ValueFloat)Value.cache(new ValueFloat(d));
    }

    public int getDisplaySize() {
        return 9;
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueFloat && this.value == ((ValueFloat)v).value;
    }
}

