/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.h2.server.ftp.FileObject;
import org.h2.server.ftp.FileSystemDatabase;

public class FileObjectDatabase
implements FileObject {
    private FileSystemDatabase db;
    private String fullName;

    static FileObjectDatabase get(FileSystemDatabase db, String name) {
        return new FileObjectDatabase(db, name);
    }

    private FileObjectDatabase(FileSystemDatabase db, String fullName) {
        this.db = db;
        this.fullName = fullName;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean delete() {
        this.db.delete(this.fullName);
        return true;
    }

    public boolean exists() {
        return this.db.exists(this.fullName);
    }

    public void read(long skip, OutputStream out) throws IOException {
        this.db.read(this.fullName, skip, out);
    }

    public String getName() {
        return this.db.getName(this.fullName);
    }

    public void write(InputStream in) throws IOException {
        this.db.write(this.fullName, in);
    }

    public boolean isDirectory() {
        return this.db.isDirectory(this.fullName);
    }

    public boolean isFile() {
        return !this.db.isDirectory(this.fullName);
    }

    public long lastModified() {
        return this.db.lastModified(this.fullName);
    }

    public long length() {
        return this.db.length(this.fullName);
    }

    public FileObject[] listFiles() {
        return this.db.listFiles(this.fullName);
    }

    public boolean mkdirs() {
        this.db.mkdirs(this.fullName);
        return true;
    }

    public boolean renameTo(FileObject fileNew) {
        return this.db.renameTo(this.fullName, ((FileObjectDatabase)fileNew).fullName);
    }
}

