/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionInSelect
extends Condition {
    private Database database;
    private Expression left;
    private Query query;
    private boolean all;
    private int compareType;
    private int queryLevel;

    public ConditionInSelect(Database database, Expression left, Query query, boolean all, int compareType) {
        this.database = database;
        this.left = left;
        this.query = query;
        this.all = all;
        this.compareType = compareType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getValue(Session session) throws SQLException {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return l;
        }
        this.query.setSession(session);
        LocalResult result = this.query.query(0);
        try {
            boolean valueAll = this.all;
            while (result.next()) {
                Value r = result.currentRow()[0];
                boolean value = r == ValueNull.INSTANCE ? false : Comparison.compareNotNull(this.database, l, r, this.compareType);
                if (!value && this.all) {
                    valueAll = false;
                    break;
                }
                if (!value || this.all) continue;
                valueAll = true;
                break;
            }
            ValueBoolean valueBoolean = ValueBoolean.get(valueAll);
            return valueBoolean;
        }
        finally {
            result.close();
        }
    }

    public void mapColumns(ColumnResolver resolver, int queryLevel) throws SQLException {
        this.left.mapColumns(resolver, queryLevel);
        this.query.mapColumns(resolver, queryLevel + 1);
        this.queryLevel = Math.max(queryLevel, this.queryLevel);
    }

    public Expression optimize(Session session) throws SQLException {
        this.left = this.left.optimize(session);
        if (this.left == ValueExpression.NULL) {
            return this.left;
        }
        if (this.query.getColumnCount() != 1) {
            throw Message.getSQLException(90052);
        }
        this.query.prepare();
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.query.setEvaluatable(tableFilter, b);
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer("(");
        buff.append(this.left.getSQL());
        buff.append(" IN(");
        buff.append(this.query.getPlan());
        buff.append("))");
        return buff.toString();
    }

    public void updateAggregate(Session session) {
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.query.isEverything(visitor);
    }

    public int getCost() {
        return this.left.getCost() + 10 + (int)(10.0 * this.query.getCost());
    }
}

