/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import org.h2.message.Message;

public class ByteUtils {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    public static int readInt(byte[] buff, int pos) {
        return (buff[pos++] << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos++] & 0xFF);
    }

    public static long readLong(byte[] buff, int pos) {
        return ((long)ByteUtils.readInt(buff, pos) << 32) + ((long)ByteUtils.readInt(buff, pos + 4) & 0xFFFFFFFFL);
    }

    public static int indexOf(byte[] bytes, byte[] pattern, int start) {
        if (pattern.length == 0) {
            return start;
        }
        if (start > bytes.length) {
            return -1;
        }
        int last = bytes.length - pattern.length + 1;
        while (start < last) {
            block5: {
                for (int i = 0; i < pattern.length; ++i) {
                    if (bytes[start + i] == pattern[i]) {
                        continue;
                    }
                    break block5;
                }
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static byte[] convertStringToBytes(String s) throws SQLException {
        int len = s.length();
        if (len % 2 != 0) {
            throw Message.getSQLException(90003, s);
        }
        byte[] buff = new byte[len /= 2];
        try {
            for (int i = 0; i < len; ++i) {
                buff[i] = (byte)(Character.digit(s.charAt(i + i), 16) << 4 | Character.digit(s.charAt(i + i + 1), 16));
            }
        }
        catch (NumberFormatException e) {
            throw Message.getSQLException(90004, s);
        }
        return buff;
    }

    public static int getByteArrayHash(byte[] value) {
        int h = 1;
        int i = 0;
        while (i < value.length) {
            h = 31 * h + value[i++];
        }
        return h;
    }

    public static String convertBytesToString(byte[] value) {
        return ByteUtils.convertBytesToString(value, value.length);
    }

    public static String convertBytesToString(byte[] value, int len) {
        char[] buff = new char[len + len];
        char[] hex = HEX;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            buff[i + i] = hex[c >> 4];
            buff[i + i + 1] = hex[c & 0xF];
        }
        return new String(buff);
    }

    public static boolean compareSecure(byte[] test, byte[] good) {
        if (test == null || good == null) {
            return test == null && good == null;
        }
        if (test.length != good.length) {
            return false;
        }
        if (test.length == 0) {
            return true;
        }
        boolean correct = true;
        boolean correct2 = false;
        for (int i = 0; i < good.length; ++i) {
            if (test[i] != good[i]) {
                correct = false;
                continue;
            }
            correct2 = true;
        }
        return correct && correct2;
    }

    public static void clear(byte[] buff) {
        for (int i = 0; i < buff.length; ++i) {
            buff[i] = 0;
        }
    }

    public static int compareNotNull(byte[] data1, byte[] data2) {
        int len = Math.min(data1.length, data2.length);
        for (int i = 0; i < len; ++i) {
            byte b = data1[i];
            byte b2 = data2[i];
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        int c = data1.length - data2.length;
        return c == 0 ? 0 : (c < 0 ? -1 : 1);
    }

    public static String convertToBinString(byte[] buff) {
        char[] chars = new char[buff.length];
        for (int i = 0; i < buff.length; ++i) {
            chars[i] = (char)(buff[i] & 0xFF);
        }
        return new String(chars);
    }

    public static byte[] convertBinStringToBytes(String data) {
        byte[] buff = new byte[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            buff[i] = (byte)(data.charAt(i) & 0xFF);
        }
        return buff;
    }

    public static byte[] copy(byte[] source, byte[] target) {
        int len = source.length;
        if (len > target.length) {
            target = new byte[len];
        }
        System.arraycopy(source, 0, target, 0, len);
        return target;
    }

    public static byte[] cloneByteArray(byte[] b) {
        int len = b.length;
        if (len == 0) {
            return b;
        }
        byte[] copy = new byte[len];
        System.arraycopy(b, 0, copy, 0, len);
        return copy;
    }

    public static byte[] serialize(Object obj) throws SQLException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return out.toByteArray();
        }
        catch (Throwable e) {
            throw Message.getSQLException(90026, null, e);
        }
    }

    public static Object deserialize(byte[] data) throws SQLException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ObjectInputStream is = new ObjectInputStream(in);
            Object obj = is.readObject();
            return obj;
        }
        catch (Throwable e) {
            throw Message.getSQLException(90027, null, e);
        }
    }
}

