/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public class MemoryUtils {
    private static long lastGC;
    private static int GC_DELAY;
    private static int MAX_GC;

    public static int getMemoryUsed() {
        MemoryUtils.collectGarbage();
        Runtime rt = Runtime.getRuntime();
        long mem = rt.totalMemory() - rt.freeMemory();
        return (int)(mem >> 10);
    }

    public static int getMemoryFree() {
        MemoryUtils.collectGarbage();
        Runtime rt = Runtime.getRuntime();
        long mem = rt.freeMemory();
        return (int)(mem >> 10);
    }

    private static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long time = System.currentTimeMillis();
        if (lastGC + (long)GC_DELAY < time) {
            for (int i = 0; i < MAX_GC; ++i) {
                runtime.gc();
                long now = runtime.totalMemory();
                if (now == total) {
                    lastGC = System.currentTimeMillis();
                    break;
                }
                total = now;
            }
        }
    }

    static {
        GC_DELAY = 50;
        MAX_GC = 8;
    }
}

