/*
 * Decompiled with CFR 0.152.
 */
package snoozesoft.systray4j;

import java.awt.EventQueue;
import java.util.Vector;
import snoozesoft.systray4j.SysTrayManager;
import snoozesoft.systray4j.SysTrayMenuIcon;
import snoozesoft.systray4j.SysTrayMenuItem;

public class SysTrayMenu {
    public static String VERSION = "2.4.1";
    public static Separator SEPARATOR = new Separator();
    protected Vector items;
    protected SysTrayMenuIcon icon;
    protected String toolTip;
    protected int id;
    private boolean iconVisible;

    public SysTrayMenu(SysTrayMenuIcon icon) {
        this(icon, "", new Vector());
    }

    public SysTrayMenu(SysTrayMenuIcon icon, Vector items) {
        this(icon, "", items);
    }

    public SysTrayMenu(SysTrayMenuIcon icon, String toolTip) {
        this(icon, toolTip, new Vector());
    }

    public SysTrayMenu(SysTrayMenuIcon icon, String toolTip, Vector items) {
        this.icon = icon;
        this.toolTip = toolTip;
        Object item = null;
        for (int i = 0; i < items.size(); ++i) {
            item = items.get(i);
            if (!(item instanceof SysTrayMenuItem)) continue;
            ((SysTrayMenuItem)item).addContainer(this);
        }
        this.items = (Vector)items.clone();
        this.iconVisible = true;
        SysTrayManager.addMainMenu(this);
    }

    public static void main(String[] args) {
        System.out.println("SysTray for Java v" + VERSION);
    }

    public static boolean isAvailable() {
        return SysTrayManager.isAvailable();
    }

    public void setIcon(SysTrayMenuIcon icon) {
        this.icon = icon;
        SysTrayManager.setIcon(this.id, icon.iconFile.getAbsolutePath());
    }

    public boolean isIconVisible() {
        return this.iconVisible;
    }

    public void showIcon() {
        SysTrayManager.showIcon(this.id, true);
        this.iconVisible = true;
    }

    public void hideIcon() {
        if (this.iconVisible) {
            SysTrayManager.showIcon(this.id, false);
            this.iconVisible = false;
        }
    }

    public SysTrayMenuIcon getIcon() {
        return this.icon;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
        SysTrayManager.setToolTip(this.id, toolTip);
    }

    public void addSeparator() {
        this.addSeparator(this.items.size());
    }

    public void addSeparator(int index) {
        this.items.add(index, SEPARATOR);
        SysTrayManager.addItem(this.id, index, SEPARATOR);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void addItem(SysTrayMenuItem item) {
        this.addItem(item, this.items.size());
    }

    public void addItem(SysTrayMenuItem item, int index) {
        this.items.add(index, item);
        SysTrayManager.addItem(this.id, index, item);
        item.addContainer(this);
    }

    public void setItems(Vector items) {
        int i;
        Object item = null;
        for (i = 0; i < this.items.size(); ++i) {
            item = this.items.elementAt(i);
            if (!(item instanceof SysTrayMenuItem)) continue;
            ((SysTrayMenuItem)item).removeContainer(this);
        }
        this.items.clear();
        for (i = 0; i < items.size(); ++i) {
            item = items.get(i);
            if (!(item instanceof SysTrayMenuItem)) continue;
            ((SysTrayMenuItem)item).addContainer(this);
        }
        this.items = (Vector)items.clone();
        SysTrayManager.replaceItems(this.id, items);
    }

    public SysTrayMenuItem getItem(String label) {
        Object object = null;
        SysTrayMenuItem item = null;
        for (int i = 0; i < this.items.size(); ++i) {
            object = this.items.elementAt(i);
            if (!(object instanceof SysTrayMenuItem)) continue;
            item = object;
            if (item.label.equals(label)) break;
            item = null;
        }
        return item;
    }

    public SysTrayMenuItem getItemAt(int index) {
        Object item = this.items.get(index);
        if (item instanceof SysTrayMenuItem) {
            return (SysTrayMenuItem)item;
        }
        return null;
    }

    public void removeItemAt(int index) {
        SysTrayManager.removeItem(this.id, index);
        Object item = this.items.get(index);
        if (item instanceof SysTrayMenuItem) {
            ((SysTrayMenuItem)item).removeContainer(this);
        }
        this.items.remove(index);
    }

    public void removeItem(Object item) {
        SysTrayManager.removeItem(this.id, this.items.indexOf(item));
        if (item instanceof SysTrayMenuItem) {
            ((SysTrayMenuItem)item).removeContainer(this);
        }
        this.items.remove(item);
    }

    public void removeAll() {
        Object item = null;
        for (int i = 0; i < this.items.size(); ++i) {
            item = this.items.elementAt(i);
            if (!(item instanceof SysTrayMenuItem)) continue;
            ((SysTrayMenuItem)item).removeContainer(this);
        }
        this.items.clear();
        SysTrayManager.replaceItems(this.id, this.items);
    }

    public static void dispose() {
        SysTrayManager.dispose();
    }

    void iconLeftClicked(boolean doubleClicked) {
        FireThread fireThread = new FireThread(this.icon, doubleClicked);
        EventQueue.invokeLater(fireThread);
    }

    void menuItemSelected(int index) {
        SysTrayMenuItem item = (SysTrayMenuItem)this.items.get(index);
        FireThread fireThread = new FireThread(item);
        EventQueue.invokeLater(fireThread);
    }

    protected static class FireThread
    implements Runnable {
        private SysTrayMenuIcon icon;
        private SysTrayMenuItem item;
        private boolean doubleClicked;

        public FireThread(SysTrayMenuIcon icon, boolean doubleClicked) {
            this.icon = icon;
            this.doubleClicked = doubleClicked;
            this.item = null;
        }

        public FireThread(SysTrayMenuItem item) {
            this.item = item;
            this.icon = null;
        }

        public void run() {
            if (this.icon != null) {
                if (this.doubleClicked) {
                    this.icon.fireIconLeftDoubleClicked();
                } else {
                    this.icon.fireIconLeftClicked();
                }
            } else {
                this.item.fireMenuItemSelected();
            }
        }
    }

    private static class Separator {
        private Separator() {
        }
    }
}

