/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public abstract class DbObject {
    public static final int TABLE_OR_VIEW = 0;
    public static final int INDEX = 1;
    public static final int USER = 2;
    public static final int SEQUENCE = 3;
    public static final int TRIGGER = 4;
    public static final int CONSTRAINT = 5;
    public static final int SETTING = 6;
    public static final int ROLE = 7;
    public static final int RIGHT = 8;
    public static final int FUNCTION_ALIAS = 9;
    public static final int SCHEMA = 10;
    public static final int CONSTANT = 11;
    public static final int USER_DATATYPE = 12;
    public static final int COMMENT = 13;
    protected String comment;
    private int id;
    protected Database database;
    protected Trace trace;
    private String objectName;
    private long modificationId;
    private boolean temporary;

    static int getCreateOrder(int type) {
        switch (type) {
            case 6: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 12: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 11: {
                return 5;
            }
            case 9: {
                return 6;
            }
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 12;
            }
            case 13: {
                return 13;
            }
        }
        throw Message.getInternalError("type=" + type);
    }

    protected DbObject(Database database, int id, String name, String traceModule) {
        this.database = database;
        this.trace = database.getTrace(traceModule);
        this.id = id;
        this.objectName = name;
        this.modificationId = database.getModificationMetaId();
    }

    public void setModified() {
        this.modificationId = this.database == null ? -1L : this.database.getNextModificationMetaId();
    }

    public long getModificationId() {
        return this.modificationId;
    }

    protected void setObjectName(String name) {
        this.objectName = name;
    }

    public String getSQL() {
        return Parser.quoteIdentifier(this.objectName);
    }

    public ObjectArray getChildren() {
        return null;
    }

    public Database getDatabase() {
        return this.database;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.objectName;
    }

    public abstract String getCreateSQLForCopy(Table var1, String var2);

    public abstract String getCreateSQL();

    public abstract String getDropSQL();

    public abstract int getType();

    public abstract void removeChildrenAndResources(Session var1) throws SQLException;

    public abstract void checkRename() throws SQLException;

    protected void invalidate() {
        this.setModified();
        this.id = -1;
        this.database = null;
        this.trace = null;
        this.objectName = null;
    }

    protected int getHeadPos() {
        return 0;
    }

    public void rename(String newName) throws SQLException {
        this.checkRename();
        this.objectName = newName;
        this.setModified();
    }

    public boolean getTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }
}

