/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.h2.Driver;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcConnectionListener;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXid;
import org.h2.message.TraceObject;
import org.h2.util.ByteUtils;
import org.h2.util.JdbcUtils;

public class JdbcXAConnection
extends TraceObject
implements XAConnection,
XAResource,
JdbcConnectionListener {
    private JdbcDataSourceFactory factory;
    private String url;
    private String user;
    private String password;
    private JdbcConnection conn;
    private ArrayList listeners = new ArrayList();
    private Xid currentTransaction;
    private int currentTransactionId;
    private static int nextTransactionId;

    JdbcXAConnection(JdbcDataSourceFactory factory, int id, String url, String user, String password) throws SQLException {
        this.factory = factory;
        this.setTrace(factory.getTrace(), 13, id);
        this.url = url;
        this.user = user;
        this.password = password;
        this.getConnection();
    }

    public XAResource getXAResource() throws SQLException {
        this.debugCodeCall("getXAResource");
        return this;
    }

    public void close() throws SQLException {
        this.debugCodeCall("close");
        if (this.conn != null) {
            this.conn.closeConnection();
            this.conn = null;
        }
    }

    public Connection getConnection() throws SQLException {
        this.debugCodeCall("getConnection");
        this.close();
        Properties info = new Properties();
        info.setProperty("user", this.user);
        info.setProperty("password", this.password);
        this.conn = new JdbcConnection(this.url, info);
        this.conn.setJdbcConnectionListener(this);
        return this.conn;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.debugCode("addConnectionEventListener(listener)");
        this.listeners.add(listener);
        if (this.conn != null) {
            this.conn.setJdbcConnectionListener(this);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.debugCode("removeConnectionEventListener(listener)");
        this.listeners.remove(listener);
    }

    public void fatalErrorOccurred(JdbcConnection conn, SQLException e) throws SQLException {
        this.debugCode("fatalErrorOccurred(conn, e)");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            ConnectionEvent event = new ConnectionEvent(this, e);
            listener.connectionErrorOccurred(event);
        }
        this.close();
    }

    public void closed(JdbcConnection conn) {
        this.debugCode("closed(conn)");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            ConnectionEvent event = new ConnectionEvent(this);
            listener.connectionClosed(event);
        }
    }

    public int getTransactionTimeout() throws XAException {
        this.debugCodeCall("getTransactionTimeout");
        return 0;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.debugCodeCall("setTransactionTimeout", seconds);
        return false;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        this.debugCode("isSameRM(xares)");
        return xares == this;
    }

    public Xid[] recover(int flag) throws XAException {
        this.debugCodeCall("recover", this.quoteFlags(flag));
        this.checkOpen();
        Statement stat = null;
        try {
            stat = this.conn.createStatement();
            ResultSet rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.IN_DOUBT ORDER BY TRANSACTION");
            ArrayList<JdbcXid> list = new ArrayList<JdbcXid>();
            while (rs.next()) {
                String tid = rs.getString("TRANSACTION");
                int id = this.getNextId(14);
                JdbcXid xid = new JdbcXid(this.factory, id, tid);
                list.add(xid);
            }
            rs.close();
            Xid[] result = new Xid[list.size()];
            list.toArray(result);
            Xid[] xidArray = result;
            return xidArray;
        }
        catch (SQLException e) {
            this.getTrace().debug("throw XAException.XAER_RMERR", e);
            throw new XAException(-3);
        }
        finally {
            JdbcUtils.closeSilently(stat);
        }
    }

    private void checkOpen() throws XAException {
        if (this.conn == null) {
            this.getTrace().debug("conn==null");
            throw new XAException(-3);
        }
    }

    public int prepare(Xid xid) throws XAException {
        this.debugCode("prepare(" + this.quoteXid(xid) + ")");
        this.checkOpen();
        if (!this.currentTransaction.equals(xid)) {
            this.getTrace().debug("throw XAException.XAER_INVAL");
            throw new XAException(-5);
        }
        Statement stat = null;
        try {
            stat = this.conn.createStatement();
            this.currentTransactionId = nextTransactionId++;
            stat.execute("PREPARE COMMIT TX_" + this.currentTransactionId);
        }
        catch (SQLException e) {
            throw this.convertException(e);
        }
        finally {
            JdbcUtils.closeSilently(stat);
        }
        this.getTrace().debug("return XA_OK");
        return 0;
    }

    public void forget(Xid xid) throws XAException {
        this.debugCode("forget(" + this.quoteXid(xid) + ")");
    }

    public void rollback(Xid xid) throws XAException {
        this.debugCode("rollback(" + this.quoteXid(xid) + ")");
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            throw this.convertException(e);
        }
        this.getTrace().debug("rolled back");
        this.currentTransaction = null;
    }

    public void end(Xid xid, int flags) throws XAException {
        this.debugCode("end(" + this.quoteXid(xid) + ", " + this.quoteFlags(flags) + ")");
        if (flags == 0x2000000) {
            return;
        }
        if (!this.currentTransaction.equals(xid)) {
            this.getTrace().debug("throw XAException.XAER_OUTSIDE");
            throw new XAException(-9);
        }
    }

    private String quoteFlags(int flags) {
        StringBuffer buff = new StringBuffer();
        if ((flags & 0x800000) != 0) {
            buff.append("|XAResource.TMENDRSCAN");
        }
        if ((flags & 0x20000000) != 0) {
            buff.append("|XAResource.TMFAIL");
        }
        if ((flags & 0x200000) != 0) {
            buff.append("|XAResource.TMJOIN");
        }
        if ((flags & 0x40000000) != 0) {
            buff.append("|XAResource.TMONEPHASE");
        }
        if ((flags & 0x8000000) != 0) {
            buff.append("|XAResource.TMRESUME");
        }
        if ((flags & 0x1000000) != 0) {
            buff.append("|XAResource.TMSTARTRSCAN");
        }
        if ((flags & 0x4000000) != 0) {
            buff.append("|XAResource.TMSUCCESS");
        }
        if ((flags & 0x2000000) != 0) {
            buff.append("|XAResource.TMSUSPEND");
        }
        if ((flags & 0) != 0) {
            buff.append("|XAResource.XA_OK");
        }
        if ((flags & 3) != 0) {
            buff.append("|XAResource.XA_RDONLY");
        }
        if (buff.length() == 0) {
            buff.append("|XAResource.TMNOFLAGS");
        }
        return buff.toString().substring(1);
    }

    private String quoteXid(Xid xid) {
        StringBuffer buff = new StringBuffer();
        buff.append("\"f:");
        buff.append(xid.getFormatId());
        buff.append(",bq:");
        buff.append(ByteUtils.convertBytesToString(xid.getBranchQualifier()));
        buff.append(",gx:");
        buff.append(ByteUtils.convertBytesToString(xid.getGlobalTransactionId()));
        buff.append(",c:");
        buff.append(xid.getClass().getName());
        buff.append("\"");
        return buff.toString();
    }

    public void start(Xid xid, int flags) throws XAException {
        this.debugCode("start(" + this.quoteXid(xid) + ", " + this.quoteFlags(flags) + ")");
        if (flags == 0x8000000) {
            return;
        }
        if (this.currentTransaction != null) {
            this.getTrace().debug("throw XAException.XAER_NOTA");
            throw new XAException(-4);
        }
        try {
            this.conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw this.convertException(e);
        }
        this.getTrace().debug("currentTransaction=xid");
        this.currentTransaction = xid;
    }

    private XAException convertException(SQLException e) {
        this.getTrace().debug("throw XAException(" + e.getMessage() + ")");
        return new XAException(e.getMessage());
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        Statement stat;
        block5: {
            this.debugCode("commit(" + this.quoteXid(xid) + ", " + onePhase + ")");
            stat = null;
            try {
                if (onePhase) {
                    this.conn.commit();
                    break block5;
                }
                stat = this.conn.createStatement();
                stat.execute("COMMIT TRANSACTION TX_" + this.currentTransactionId);
            }
            catch (SQLException e) {
                try {
                    throw this.convertException(e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeSilently(stat);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeSilently(stat);
        this.getTrace().debug("committed");
        this.currentTransaction = null;
    }

    static {
        Driver.load();
    }
}

