/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.message.Message;
import org.h2.store.FileLister;
import org.h2.util.IOUtils;

public class Restore {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [-file <filename>] [-dir <dir>] [-db <database>] [-quiet]");
    }

    public static void main(String[] args) throws SQLException {
        new Restore().run(args);
    }

    private void run(String[] args) throws SQLException {
        String zipFileName = "backup.zip";
        String dir = ".";
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (args[i].equals("-db")) {
                db = args[++i];
                continue;
            }
            if (args[i].equals("-quiet")) {
                quiet = true;
                continue;
            }
            this.showUsage();
            return;
        }
        Restore.execute(zipFileName, dir, db, quiet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOriginalDbName(File file, String db) throws IOException {
        String string;
        FileInputStream in = null;
        try {
            ZipEntry entry;
            in = new FileInputStream(file);
            ZipInputStream zipIn = new ZipInputStream(in);
            String originalDbName = null;
            boolean multiple = false;
            while ((entry = zipIn.getNextEntry()) != null) {
                String fileName = entry.getName();
                zipIn.closeEntry();
                String name = FileLister.getDatabaseNameFromFileName(fileName);
                if (name == null) continue;
                if (db.equals(name)) {
                    originalDbName = name;
                    break;
                }
                if (originalDbName == null) {
                    originalDbName = name;
                    continue;
                }
                multiple = true;
            }
            zipIn.close();
            if (multiple && !originalDbName.equals(db)) {
                throw new IOException("Multiple databases found, but not " + db);
            }
            string = originalDbName;
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(in);
            throw throwable;
        }
        IOUtils.closeSilently(in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String zipFileName, String directory, String db, boolean quiet) throws SQLException {
        FileInputStream in = null;
        try {
            ZipEntry entry;
            File file = new File(zipFileName);
            if (!file.exists()) {
                throw new IOException("File not found: " + zipFileName);
            }
            String originalDbName = null;
            if (db != null && (originalDbName = Restore.getOriginalDbName(file, db)) == null) {
                throw new IOException("No database named " + db + " found");
            }
            in = new FileInputStream(file);
            ZipInputStream zipIn = new ZipInputStream(in);
            while ((entry = zipIn.getNextEntry()) != null) {
                String fileName = entry.getName();
                boolean copy = false;
                if (db == null) {
                    copy = true;
                } else if (fileName.startsWith(originalDbName)) {
                    fileName = db + fileName.substring(originalDbName.length());
                    copy = true;
                }
                if (copy) {
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(new File(directory, fileName));
                        IOUtils.copy(zipIn, out);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeSilently(out);
                        throw throwable;
                    }
                    IOUtils.closeSilently(out);
                }
                zipIn.closeEntry();
            }
            zipIn.closeEntry();
            zipIn.close();
        }
        catch (IOException e) {
            try {
                throw Message.convert(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(in);
                throw throwable;
            }
        }
        IOUtils.closeSilently(in);
    }
}

