/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.text.Collator;
import java.util.Locale;
import org.h2.util.StringUtils;

public class CompareMode {
    public static final String OFF = "OFF";
    private String name = "OFF";
    private Collator collator;

    public CompareMode(Collator collator, String name) {
        this.collator = collator;
        if (name != null) {
            this.name = name;
        }
    }

    public int compareString(String a, String b, boolean ignoreCase) {
        if (this.collator == null) {
            if (ignoreCase) {
                return a.compareToIgnoreCase(b);
            }
            return a.compareTo(b);
        }
        if (ignoreCase) {
            a = a.toUpperCase();
            b = b.toUpperCase();
        }
        int comp = this.collator.compare(a, b);
        return comp;
    }

    public static String getName(Locale l) {
        Locale english = Locale.ENGLISH;
        String name = l.getDisplayLanguage(english) + ' ' + l.getDisplayCountry(english) + ' ' + l.getVariant();
        name = StringUtils.toUpperEnglish(name.trim().replace(' ', '_'));
        return name;
    }

    private static boolean compareLocaleNames(Locale locale, String name) {
        return name.equalsIgnoreCase(locale.toString()) || name.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String name) {
        String country;
        String language;
        Locale locale;
        int idx;
        Collator result = null;
        if (name.length() == 2) {
            Locale locale2 = new Locale(name.toLowerCase(), "");
            if (CompareMode.compareLocaleNames(locale2, name)) {
                result = Collator.getInstance(locale2);
            }
        } else if (name.length() == 5 && (idx = name.indexOf(95)) >= 0 && CompareMode.compareLocaleNames(locale = new Locale(language = name.substring(0, idx).toLowerCase(), country = name.substring(idx + 1)), name)) {
            result = Collator.getInstance(locale);
        }
        if (result == null) {
            Locale[] locales = Collator.getAvailableLocales();
            for (int i = 0; i < locales.length; ++i) {
                Locale locale3 = locales[i];
                if (!CompareMode.compareLocaleNames(locale3, name)) continue;
                result = Collator.getInstance(locale3);
                break;
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }
}

