/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueInt
extends Value {
    public static final int PRECISION = 10;
    private int value;
    private static final int STATIC_SIZE = 100;
    private static final int DYNAMIC_SIZE = 256;
    private static ValueInt[] staticCache = new ValueInt[100];
    private static ValueInt[] dynamicCache = new ValueInt[256];

    public static ValueInt get(int i) {
        if (i >= 0 && i < 100) {
            return staticCache[i];
        }
        ValueInt v = dynamicCache[i & 0xFF];
        if (v == null || v.value != i) {
            ValueInt.dynamicCache[i & 0xFF] = v = new ValueInt(i);
        }
        return v;
    }

    private ValueInt(int value) {
        this.value = value;
    }

    public Value add(Value v) throws SQLException {
        ValueInt other = (ValueInt)v;
        if (Constants.OVERFLOW_EXCEPTIONS) {
            return this.checkRange((long)this.value + (long)other.value);
        }
        return ValueInt.get(this.value + other.value);
    }

    private ValueInt checkRange(long value) throws SQLException {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw Message.getSQLException(90110, DataType.getDataType((int)4).name);
        }
        return ValueInt.get((int)value);
    }

    public int getSignum() {
        return this.value == 0 ? 0 : (this.value < 0 ? -1 : 1);
    }

    public Value negate() throws SQLException {
        if (Constants.OVERFLOW_EXCEPTIONS) {
            return this.checkRange(-((long)this.value));
        }
        return ValueInt.get(-this.value);
    }

    public Value subtract(Value v) throws SQLException {
        ValueInt other = (ValueInt)v;
        if (Constants.OVERFLOW_EXCEPTIONS) {
            return this.checkRange((long)this.value - (long)other.value);
        }
        return ValueInt.get(this.value - other.value);
    }

    public Value multiply(Value v) throws SQLException {
        ValueInt other = (ValueInt)v;
        if (Constants.OVERFLOW_EXCEPTIONS) {
            return this.checkRange((long)this.value * (long)other.value);
        }
        return ValueInt.get(this.value * other.value);
    }

    public Value divide(Value v) throws SQLException {
        ValueInt other = (ValueInt)v;
        if (other.value == 0) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        return ValueInt.get(this.value / other.value);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 4;
    }

    public int getInt() {
        return this.value;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueInt v = (ValueInt)o;
        if (this.value == v.value) {
            return 0;
        }
        return this.value > v.value ? 1 : -1;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 10L;
    }

    public int hashCode() {
        return this.value;
    }

    public Object getObject() {
        return new Integer(this.value);
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setInt(parameterIndex, this.value);
    }

    public int getDisplaySize() {
        return 10;
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueInt && this.value == ((ValueInt)v).value;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            ValueInt.staticCache[i] = new ValueInt(i);
        }
    }
}

