/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.tools.SimpleResultSet;
import org.h2.value.Value;

public class JdbcArray
extends TraceObject
implements Array {
    private Value value;
    private JdbcConnection conn;

    public JdbcArray(SessionInterface session, JdbcConnection conn, Value value, int id) {
        this.setTrace(session.getTrace(), 15, id);
        this.conn = conn;
        this.value = value;
    }

    public Object getArray() throws SQLException {
        try {
            this.debugCodeCall("getArray");
            this.checkClosed();
            return this.get();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Object getArray(Map map) throws SQLException {
        try {
            this.debugCode("getArray(" + this.quoteMap(map) + ");");
            this.checkMap(map);
            this.checkClosed();
            return this.get();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Object getArray(long index, int count) throws SQLException {
        try {
            this.debugCode("getArray(" + index + ", " + count + ");");
            this.checkClosed();
            return this.get(index, count);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Object getArray(long index, int count, Map map) throws SQLException {
        try {
            this.debugCode("getArray(" + index + ", " + count + ", " + this.quoteMap(map) + ");");
            this.checkClosed();
            this.checkMap(map);
            return this.get(index, count);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getBaseType() throws SQLException {
        try {
            this.debugCodeCall("getBaseType");
            this.checkClosed();
            return 0;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getBaseTypeName() throws SQLException {
        try {
            this.debugCodeCall("getBaseTypeName");
            this.checkClosed();
            return "NULL";
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            this.debugCodeCall("getResultSet");
            this.checkClosed();
            return this.getResultSet(this.get(), 0L);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        try {
            this.debugCode("getResultSet(" + this.quoteMap(map) + ");");
            this.checkClosed();
            this.checkMap(map);
            return this.getResultSet(this.get(), 0L);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getResultSet(long index, int count) throws SQLException {
        try {
            this.debugCode("getResultSet(" + index + ", " + count + ");");
            this.checkClosed();
            return this.getResultSet(this.get(index, count), index);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet getResultSet(long index, int count, Map map) throws SQLException {
        try {
            this.debugCode("getResultSet(" + index + ", " + count + ", " + this.quoteMap(map) + ");");
            this.checkClosed();
            this.checkMap(map);
            return this.getResultSet(this.get(index, count), index);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void free() throws SQLException {
        this.debugCodeCall("free");
        this.value = null;
    }

    private ResultSet getResultSet(Object[] array, long offset) throws SQLException {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("INDEX", -5, 0, 0);
        rs.addColumn("VALUE", 0, 0, 0);
        for (int i = 0; i < array.length; ++i) {
            Object[] row = new Object[]{new Long(offset + (long)i + 1L), array[i]};
            rs.addRow(row);
        }
        return rs;
    }

    private void checkClosed() throws SQLException {
        this.conn.checkClosed();
        if (this.value == null) {
            throw Message.getSQLException(90007);
        }
    }

    private Object[] get() throws SQLException {
        return (Object[])this.value.convertTo(17).getObject();
    }

    private Object[] get(long index, int count) throws SQLException {
        Object[] array = this.get();
        if (count < 0 || count > array.length) {
            throw Message.getInvalidValueException("" + count, "count (1.." + array.length + ")");
        }
        if (index < 1L || index > (long)array.length) {
            throw Message.getInvalidValueException("" + index, "index (1.." + array.length + ")");
        }
        Object[] subset = new Object[count];
        System.arraycopy(array, (int)(index - 1L), subset, 0, count);
        return subset;
    }

    private void checkMap(Map map) throws SQLException {
        if (map != null && map.size() > 0) {
            throw Message.getUnsupportedException();
        }
    }
}

