/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.Table;

public class Sequence
extends SchemaObject {
    private static final int BLOCK_INCREMENT = 32;
    private long value = 1L;
    private long valueWithMargin;
    private long increment = 1L;
    private boolean belongsToTable;

    public Sequence(Schema schema, int id, String name, boolean belongsToTable) {
        super(schema, id, name, "sequence");
        this.belongsToTable = belongsToTable;
    }

    public synchronized void setStartValue(long value) {
        this.value = value;
        this.valueWithMargin = value;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public long getIncrement() {
        return this.increment;
    }

    public void setIncrement(long inc) throws JdbcSQLException {
        if (this.increment == 0L) {
            throw Message.getSQLException(90008, new String[]{"0", "INCREMENT"}, null);
        }
        this.increment = inc;
    }

    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        return "DROP SEQUENCE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw Message.getInternalError();
    }

    public synchronized String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE SEQUENCE ");
        buff.append(this.getSQL());
        buff.append(" START WITH ");
        buff.append(this.value);
        if (this.increment != 1L) {
            buff.append(" INCREMENT BY ");
            buff.append(this.increment);
        }
        if (this.belongsToTable) {
            buff.append(" BELONGS_TO_TABLE");
        }
        return buff.toString();
    }

    public synchronized long getNext() throws SQLException {
        if (this.increment > 0L && this.value >= this.valueWithMargin || this.increment < 0L && this.value <= this.valueWithMargin) {
            this.valueWithMargin += this.increment * 32L;
            this.flush();
        }
        long v = this.value;
        this.value += this.increment;
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws SQLException {
        Session s = this.database.getSystemSession();
        Sequence sequence = this;
        synchronized (sequence) {
            long realValue = this.value;
            try {
                this.value = this.valueWithMargin;
                this.database.update(s, this);
            }
            finally {
                this.value = realValue;
            }
        }
        s.commit();
    }

    public void close() throws SQLException {
        this.valueWithMargin = this.value;
        this.flush();
    }

    public int getType() {
        return 3;
    }

    public void removeChildrenAndResources(Session session) {
        this.invalidate();
    }

    public void checkRename() {
    }

    public synchronized long getCurrentValue() {
        return this.value - this.increment;
    }

    public void setBelongsToTable(boolean b) {
        this.belongsToTable = b;
    }
}

