/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.Driver;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.TcpServerThread;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;

public class TcpServer
implements Service {
    public static final int DEFAULT_PORT = 9092;
    public static final int SHUTDOWN_NORMAL = 0;
    public static final int SHUTDOWN_FORCE = 1;
    public static boolean LOG_INTERNAL_ERRORS;
    private int port;
    private boolean log;
    private boolean ssl;
    private boolean stop;
    private ServerSocket serverSocket;
    private HashSet running = new HashSet();
    private String baseDir;
    private String url;
    private boolean allowOthers;
    private boolean ifExists;
    private Connection managementDb;
    private String managementPassword = "";
    private static HashMap servers;

    public static String getManagementDbName(int port) {
        return "mem:management_db_" + port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initManagementDb() throws SQLException {
        Connection conn;
        this.managementDb = conn = DriverManager.getConnection("jdbc:h2:" + TcpServer.getManagementDbName(this.port), "sa", this.managementPassword);
        Statement stat = null;
        try {
            stat = conn.createStatement();
            stat.execute("CREATE ALIAS IF NOT EXISTS STOP_SERVER FOR \"" + TcpServer.class.getName() + ".stopServer\"");
        }
        finally {
            JdbcUtils.closeSilently(stat);
        }
        servers.put("" + this.port, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopManagementDb() {
        Class clazz = TcpServer.class;
        synchronized (clazz) {
            if (this.managementDb != null) {
                try {
                    this.managementDb.close();
                }
                catch (SQLException e) {
                    TraceSystem.traceThrowable(e);
                }
                this.managementDb = null;
            }
        }
    }

    public void init(String[] args) throws Exception {
        this.port = 9092;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.equals("-log")) {
                this.log = Boolean.valueOf(args[++i]);
                continue;
            }
            if (a.equals("-tcpSSL")) {
                this.ssl = Boolean.valueOf(args[++i]);
                continue;
            }
            if (a.equals("-tcpPort")) {
                this.port = MathUtils.decodeInt(args[++i]);
                continue;
            }
            if (a.equals("-tcpPassword")) {
                this.managementPassword = args[++i];
                continue;
            }
            if (a.equals("-baseDir")) {
                this.baseDir = args[++i];
                continue;
            }
            if (a.equals("-tcpAllowOthers")) {
                this.allowOthers = Boolean.valueOf(args[++i]);
                continue;
            }
            if (!a.equals("-ifExists")) continue;
            this.ifExists = Boolean.valueOf(args[++i]);
        }
        Driver.load();
        this.url = (this.ssl ? "ssl" : "tcp") + "://localhost:" + this.port;
    }

    public String getURL() {
        return this.url;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        return NetUtils.isLoopbackAddress(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SQLException {
        Class clazz = TcpServer.class;
        synchronized (clazz) {
            this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
            this.initManagementDb();
        }
    }

    public void listen() {
        block3: {
            String threadName = Thread.currentThread().getName();
            try {
                while (!this.stop) {
                    Socket s = this.serverSocket.accept();
                    TcpServerThread c = new TcpServerThread(s, this);
                    this.running.add(c);
                    Thread thread = new Thread(c);
                    thread.setName(threadName + " thread");
                    c.setThread(thread);
                    thread.start();
                }
            }
            catch (Exception e) {
                if (this.stop) break block3;
                TraceSystem.traceThrowable(e);
            }
        }
        this.stopManagementDb();
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, this.ssl);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized void stop() {
        if (!this.stop) {
            this.stopManagementDb();
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    TraceSystem.traceThrowable(e);
                }
                this.serverSocket = null;
            }
        }
        ArrayList list = new ArrayList(this.running);
        for (int i = 0; i < list.size(); ++i) {
            TcpServerThread c = (TcpServerThread)list.get(i);
            c.close();
            try {
                c.getThread().join(100L);
                continue;
            }
            catch (Exception e) {
                TraceSystem.traceThrowable(e);
            }
        }
        servers.remove("" + this.port);
    }

    public static synchronized void stopServer(int port, String password, int shutdownMode) {
        TcpServer server = (TcpServer)servers.get("" + port);
        if (server == null) {
            return;
        }
        if (!server.managementPassword.equals(password)) {
            return;
        }
        if (shutdownMode == 0) {
            server.stopManagementDb();
            server.stop = true;
            try {
                Socket s = new Socket("localhost", port);
                s.close();
            }
            catch (Exception e) {}
        } else if (shutdownMode == 1) {
            server.stop();
        }
    }

    synchronized void remove(TcpServerThread t) {
        this.running.remove(t);
    }

    boolean getLog() {
        return this.log;
    }

    String getBaseDir() {
        return this.baseDir;
    }

    void log(String s) {
        if (this.log) {
            System.out.println(s);
        }
    }

    void logError(Throwable e) {
        if (this.log) {
            e.printStackTrace();
        }
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    public String getType() {
        return "TCP";
    }

    public void logInternalError(String string) {
        if (LOG_INTERNAL_ERRORS) {
            System.out.println(string);
            new Error(string).printStackTrace();
        }
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    static {
        servers = new HashMap();
    }
}

