/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.util.ByteUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

abstract class ValueBytesBase
extends Value {
    private byte[] value;
    private int hash;

    protected ValueBytesBase(byte[] v) {
        this.value = v;
    }

    public String getSQL() {
        return "X'" + this.getString() + "'";
    }

    public byte[] getBytesNoCopy() {
        return this.value;
    }

    public byte[] getBytes() {
        return ByteUtils.cloneByteArray(this.value);
    }

    protected int compareSecure(Value v, CompareMode mode) {
        byte[] v2 = ((ValueBytesBase)v).value;
        return ByteUtils.compareNotNull(this.value, v2);
    }

    public String getString() {
        return ByteUtils.convertBytesToString(this.value);
    }

    public long getPrecision() {
        return this.value.length;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = ByteUtils.getByteArrayHash(this.value);
        }
        return this.hash;
    }

    public Object getObject() {
        return this.getBytes();
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBytes(parameterIndex, this.value);
    }

    public int getDisplaySize() {
        return this.value.length * 2;
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueBytesBase && ByteUtils.compareNotNull(this.value, ((ValueBytesBase)v).value) == 0;
    }
}

