/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.h2.Driver;
import org.h2.server.Service;
import org.h2.server.ftp.FileObject;
import org.h2.server.ftp.FileObjectDatabase;
import org.h2.server.ftp.FileObjectNative;
import org.h2.server.ftp.FileSystemDatabase;
import org.h2.server.ftp.FtpControl;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;

public class FtpServer
implements Service {
    public static final String DEFAULT_ROOT = "ftp";
    public static final String DEFAULT_READ = "guest";
    public static final String DEFAULT_WRITE = "sa";
    public static final String DEFAULT_WRITE_PASSWORD = "sa";
    private ServerSocket serverSocket;
    private int port = 8021;
    private int openConnectionCount;
    private int maxConnectionCount = 100;
    private SimpleDateFormat dateFormatNew = new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH);
    private SimpleDateFormat dateFormatOld = new SimpleDateFormat("MMM dd  yyyy", Locale.ENGLISH);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private String root = "ftp";
    private String writeUserName = "sa";
    private String writePassword = "sa";
    private String readUserName = "guest";
    private HashMap tasks = new HashMap();
    private FileSystemDatabase db;
    private boolean log;
    private boolean allowTask;
    static final String TASK_SUFFIX = ".task";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen() {
        try {
            while (this.serverSocket != null) {
                boolean stop;
                Socket s = this.serverSocket.accept();
                FtpServer ftpServer = this;
                synchronized (ftpServer) {
                    ++this.openConnectionCount;
                    stop = this.openConnectionCount > this.maxConnectionCount;
                }
                FtpControl c = new FtpControl(s, this, stop);
                c.start();
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnection() {
        FtpServer ftpServer = this;
        synchronized (ftpServer) {
            --this.openConnectionCount;
        }
    }

    public ServerSocket createDataSocket() throws IOException {
        ServerSocket dataSocket = new ServerSocket(0);
        return dataSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void appendFile(StringBuffer buff, FileObject f) {
        void var6_9;
        String date;
        buff.append(f.isDirectory() ? (char)'d' : '-');
        buff.append(f.canRead() ? (char)'r' : '-');
        buff.append(f.canWrite() ? (char)'w' : '-');
        buff.append("------- 1 owner group ");
        String size = String.valueOf(f.length());
        for (int i = size.length(); i < 15; ++i) {
            buff.append(' ');
        }
        buff.append(size);
        buff.append(' ');
        Date now = new Date();
        Date mod = new Date(f.lastModified());
        if (mod.after(now) || Math.abs((now.getTime() - mod.getTime()) / 1000L / 60L / 60L / 24L) > 180L) {
            SimpleDateFormat simpleDateFormat = this.dateFormatOld;
            synchronized (simpleDateFormat) {
                date = this.dateFormatOld.format(mod);
            }
        }
        SimpleDateFormat simpleDateFormat = this.dateFormatNew;
        synchronized (simpleDateFormat) {
            date = this.dateFormatNew.format(mod);
        }
        buff.append((String)var6_9);
        buff.append(' ');
        buff.append(f.getName());
        buff.append("\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String formatLastModified(FileObject file) {
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            return this.dateFormat.format(new Date(file.lastModified()));
        }
    }

    FileObject getFile(String path) {
        if (path.indexOf("..") > 0) {
            path = "/";
        }
        while (path.startsWith("/") && this.root.endsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.log("file: " + this.root + path);
        if (this.db != null) {
            return FileObjectDatabase.get(this.db, this.root + path);
        }
        return FileObjectNative.get(this.root + path);
    }

    String getDirectoryListing(FileObject directory, boolean listDirectories) {
        FileObject[] list = directory.listFiles();
        StringBuffer buff = new StringBuffer();
        for (int i = 0; list != null && i < list.length; ++i) {
            FileObject f = list[i];
            if (!f.isFile() && (!f.isDirectory() || !listDirectories)) continue;
            this.appendFile(buff, f);
        }
        return buff.toString();
    }

    public boolean checkUserPassword(String userName, String password) {
        return userName.equals(this.writeUserName) && password.equals(this.writePassword);
    }

    public boolean checkUserPasswordReadOnly(String userName, String param) {
        return userName.equals(this.readUserName);
    }

    public void init(String[] args) throws Exception {
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("-ftpPort".equals(args[i])) {
                this.port = MathUtils.decodeInt(args[++i]);
                continue;
            }
            if ("-ftpDir".equals(args[i])) {
                this.root = FileUtils.translateFileName(args[++i]);
                continue;
            }
            if ("-ftpRead".equals(args[i])) {
                this.readUserName = args[++i];
                continue;
            }
            if ("-ftpWrite".equals(args[i])) {
                this.writeUserName = args[++i];
                continue;
            }
            if ("-ftpWritePassword".equals(args[i])) {
                this.writePassword = args[++i];
                continue;
            }
            if ("-log".equals(args[i])) {
                this.log = Boolean.valueOf(args[++i]);
                continue;
            }
            if (!"-ftpTask".equals(args[i])) continue;
            this.allowTask = Boolean.valueOf(args[++i]);
        }
        if (this.root.startsWith("jdbc:")) {
            Connection conn = this.root.startsWith("jdbc:h2:") ? Driver.load().connect(this.root, new Properties()) : DriverManager.getConnection(this.root);
            this.db = new FileSystemDatabase(conn, this.log);
            this.root = "/";
        }
    }

    public String getURL() {
        return "ftp://localhost:" + this.port;
    }

    public void start() throws SQLException {
        this.getFile("").mkdirs();
        this.serverSocket = NetUtils.createServerSocket(this.port, false);
    }

    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            this.logError(e);
        }
        this.serverSocket = null;
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, false);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getAllowOthers() {
        return true;
    }

    public String getType() {
        return "FTP";
    }

    void log(String s) {
        if (this.log) {
            System.out.println(s);
        }
    }

    void logError(Throwable e) {
        if (this.log) {
            e.printStackTrace();
        }
    }

    public boolean getAllowTask() {
        return this.allowTask;
    }

    void startTask(FileObject file) throws IOException {
        this.stopTask(file);
        String processName = file.getName();
        if (file.getName().endsWith(".zip.task")) {
            this.log("expand: " + file.getName());
            Process p = Runtime.getRuntime().exec("jar -xf " + file.getName(), null, new File(this.root));
            String processFile = this.root + "/" + processName;
            new StreamRedirect(processFile, p.getInputStream(), null).start();
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        file.read(0L, out);
        byte[] data = out.toByteArray();
        Properties prop = new Properties();
        prop.load(new ByteArrayInputStream(data));
        String command = prop.getProperty("command");
        String outFile = processName.substring(0, processName.length() - TASK_SUFFIX.length());
        String errorFile = this.root + "/" + prop.getProperty("error", outFile + ".err.txt");
        String outputFile = this.root + "/" + prop.getProperty("output", outFile + ".out.txt");
        String processFile = this.root + "/" + processName;
        this.log("start process: " + processName + " / " + command);
        Process p = Runtime.getRuntime().exec(command, null, new File(this.root));
        new StreamRedirect(processFile, p.getErrorStream(), errorFile).start();
        new StreamRedirect(processFile, p.getInputStream(), outputFile).start();
        this.tasks.put(processName, p);
    }

    void stopTask(FileObject file) {
        String processName = file.getName();
        this.log("kill process: " + processName);
        Process p = (Process)this.tasks.remove(processName);
        if (p == null) {
            return;
        }
        p.destroy();
    }

    private static class StreamRedirect
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private String outFile;
        private String processFile;

        StreamRedirect(String processFile, InputStream in, String outFile) {
            this.processFile = processFile;
            this.in = in;
            this.outFile = outFile;
        }

        private void openOutput() {
            if (this.outFile != null) {
                try {
                    this.out = FileUtils.openFileOutputStream(this.outFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.outFile = null;
            }
        }

        public void run() {
            while (true) {
                try {
                    int x;
                    while ((x = this.in.read()) >= 0) {
                        this.openOutput();
                        if (this.out == null) continue;
                        this.out.write(x);
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            IOUtils.closeSilently(this.out);
            IOUtils.closeSilently(this.in);
            new File(this.processFile).delete();
        }
    }
}

