/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.command.Prepared;
import org.h2.constraint.Constraint;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.result.SimpleRowValue;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.TableView;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class Table
extends SchemaObjectBase {
    public static final int TYPE_CACHED = 0;
    public static final int TYPE_MEMORY = 1;
    public static final String TABLE_LINK = "TABLE LINK";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    protected Column[] columns;
    private final HashMap columnMap = new HashMap();
    private final boolean persistent;
    private ObjectArray triggers;
    private ObjectArray constraints;
    private ObjectArray sequences;
    private ObjectArray views;
    private boolean checkForeignKeyConstraints = true;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    protected int memoryPerRow;

    public Table(Schema schema, int id, String name, boolean persistent) {
        super(schema, id, name, "table");
        this.persistent = persistent;
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw Message.getInternalError();
    }

    public ObjectArray getChildren() {
        ObjectArray children = new ObjectArray();
        ObjectArray indexes = this.getIndexes();
        if (indexes != null) {
            children.addAll(indexes);
        }
        if (this.constraints != null) {
            children.addAll(this.constraints);
        }
        if (this.triggers != null) {
            children.addAll(this.triggers);
        }
        if (this.sequences != null) {
            children.addAll(this.sequences);
        }
        if (this.views != null) {
            children.addAll(this.views);
        }
        ObjectArray rights = this.database.getAllRights();
        for (int i = 0; i < rights.size(); ++i) {
            Right right = (Right)rights.get(i);
            if (right.getGrantedTable() != this) continue;
            children.add(right);
        }
        return children;
    }

    protected void setColumns(Column[] columns) throws SQLException {
        this.columns = columns;
        if (this.columnMap.size() > 0) {
            this.columnMap.clear();
        }
        int memory = 0;
        for (int i = 0; i < columns.length; ++i) {
            Column col = columns[i];
            int dataType = col.getType();
            if (dataType == -1) {
                throw Message.getSQLException(50004, col.getSQL());
            }
            memory += DataType.getDataType((int)dataType).memory;
            col.setTable(this, i);
            String columnName = col.getName();
            if (this.columnMap.get(columnName) != null) {
                throw Message.getSQLException(42121, columnName);
            }
            this.columnMap.put(columnName, col);
        }
        this.memoryPerRow = memory;
    }

    public void renameColumn(Column column, String newName) {
        this.columnMap.remove(column.getName());
        column.rename(newName);
        this.columnMap.put(newName, column);
    }

    public abstract void lock(Session var1, boolean var2, boolean var3) throws SQLException;

    public abstract void close(Session var1) throws SQLException;

    public abstract void unlock(Session var1);

    public abstract Index addIndex(Session var1, String var2, int var3, Column[] var4, IndexType var5, int var6, String var7) throws SQLException;

    public abstract void removeRow(Session var1, Row var2) throws SQLException;

    public abstract void truncate(Session var1) throws SQLException;

    public abstract void addRow(Session var1, Row var2) throws SQLException;

    public abstract void checkSupportAlter() throws SQLException;

    public abstract String getTableType();

    public abstract Index getScanIndex(Session var1) throws SQLException;

    public abstract Index getUniqueIndex();

    public abstract ObjectArray getIndexes();

    public abstract boolean isLockedExclusively();

    public abstract long getMaxDataModificationId();

    public void updateRows(Prepared prepared, Session session, ObjectArray oldRows, ObjectArray newRows) throws SQLException {
        int i;
        for (i = 0; i < oldRows.size(); ++i) {
            prepared.checkCancelled();
            Row o = (Row)oldRows.get(i);
            this.removeRow(session, o);
            session.log(this, (short)1, o);
        }
        for (i = 0; i < newRows.size(); ++i) {
            prepared.checkCancelled();
            Row n = (Row)newRows.get(i);
            this.addRow(session, n);
            session.log(this, (short)0, n);
        }
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        while (this.views != null && this.views.size() > 0) {
            TableView view = (TableView)this.views.get(0);
            this.views.remove(0);
            this.database.removeSchemaObject(session, view);
        }
        while (this.triggers != null && this.triggers.size() > 0) {
            TriggerObject trigger = (TriggerObject)this.triggers.get(0);
            this.triggers.remove(0);
            this.database.removeSchemaObject(session, trigger);
        }
        while (this.constraints != null && this.constraints.size() > 0) {
            Constraint constraint = (Constraint)this.constraints.get(0);
            this.constraints.remove(0);
            this.database.removeSchemaObject(session, constraint);
        }
        while (this.sequences != null && this.sequences.size() > 0) {
            Sequence sequence = (Sequence)this.sequences.get(0);
            this.sequences.remove(0);
            if (this.getTemporary()) continue;
            this.database.removeSchemaObject(session, sequence);
        }
        ObjectArray rights = this.database.getAllRights();
        for (int i = 0; i < rights.size(); ++i) {
            Right right = (Right)rights.get(i);
            if (right.getGrantedTable() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
    }

    public void checkColumnIsNotReferenced(Column col) throws SQLException {
        for (int i = 0; this.constraints != null && i < this.constraints.size(); ++i) {
            Constraint constraint = (Constraint)this.constraints.get(i);
            if (!constraint.containsColumn(col)) continue;
            throw Message.getSQLException(90083, constraint.getSQL());
        }
        ObjectArray indexes = this.getIndexes();
        for (int i = 0; indexes != null && i < indexes.size(); ++i) {
            Index index = (Index)indexes.get(i);
            if (index.getColumns().length == 1 || index.getCreateSQL() == null || index.getColumnIndex(col) < 0) continue;
            throw Message.getSQLException(90083, index.getSQL());
        }
    }

    public Row getTemplateRow() {
        return new Row(new Value[this.columns.length], this.memoryPerRow);
    }

    public SearchRow getTemplateSimpleRow(boolean singleColumn) {
        if (singleColumn) {
            return new SimpleRowValue(this.columns.length);
        }
        return new SimpleRow(new Value[this.columns.length]);
    }

    public Row getNullRow() {
        Row row = new Row(new Value[this.columns.length], 0);
        for (int i = 0; i < this.columns.length; ++i) {
            row.setValue(i, ValueNull.INSTANCE);
        }
        return row;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public int getType() {
        return 0;
    }

    public Column getColumn(int index) {
        return this.columns[index];
    }

    public Column getColumn(String columnName) throws SQLException {
        Column column = (Column)this.columnMap.get(columnName);
        if (column == null) {
            throw Message.getSQLException(42122, columnName);
        }
        return column;
    }

    public PlanItem getBestPlanItem(Session session, int[] masks) throws SQLException {
        PlanItem item = new PlanItem();
        item.setIndex(this.getScanIndex(session));
        item.cost = item.getIndex().getCost(session, null);
        ObjectArray indexes = this.getIndexes();
        for (int i = 1; indexes != null && masks != null && i < indexes.size(); ++i) {
            Index index = (Index)indexes.get(i);
            double cost = index.getCost(session, masks);
            if (!(cost < item.cost)) continue;
            item.cost = cost;
            item.setIndex(index);
        }
        return item;
    }

    public Index findPrimaryKey() throws SQLException {
        ObjectArray indexes = this.getIndexes();
        for (int i = 0; indexes != null && i < indexes.size(); ++i) {
            Index idx = (Index)indexes.get(i);
            if (!idx.getIndexType().isPrimaryKey()) continue;
            return idx;
        }
        return null;
    }

    public Index getPrimaryKey() throws SQLException {
        Index index = this.findPrimaryKey();
        if (index != null) {
            return index;
        }
        throw Message.getSQLException(42112, "PRIMARY_KEY_");
    }

    public void validateConvertUpdateSequence(Session session, Row row) throws SQLException {
        for (int i = 0; i < this.columns.length; ++i) {
            Value value = row.getValue(i);
            Column column = this.columns[i];
            Value v2 = column.getComputed() ? column.computeValue(session, row) : column.validateConvertUpdateSequence(session, value);
            if (v2 == value) continue;
            row.setValue(i, v2);
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    private void remove(ObjectArray list, DbObject obj) {
        int i;
        if (list != null && (i = list.indexOf(obj)) >= 0) {
            list.remove(i);
        }
    }

    public void removeIndex(Index index) {
        ObjectArray indexes = this.getIndexes();
        if (indexes != null) {
            this.remove(indexes, index);
            if (index.getIndexType().isPrimaryKey()) {
                Column[] cols = index.getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    cols[i].setPrimaryKey(false);
                }
            }
        }
    }

    public void removeView(TableView view) {
        this.remove(this.views, view);
    }

    public void removeConstraint(Constraint constraint) {
        this.remove(this.constraints, constraint);
    }

    public void removeSequence(Session session, Sequence sequence) {
        this.remove(this.sequences, sequence);
    }

    public void removeTrigger(Session session, TriggerObject trigger) {
        this.remove(this.triggers, trigger);
    }

    public void addView(TableView view) {
        this.views = this.add(this.views, view);
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == null || this.constraints.indexOf(constraint) < 0) {
            this.constraints = this.add(this.constraints, constraint);
        }
    }

    public ObjectArray getConstraints() {
        return this.constraints;
    }

    public void addSequence(Sequence sequence) {
        this.sequences = this.add(this.sequences, sequence);
    }

    public void addTrigger(TriggerObject trigger) {
        this.triggers = this.add(this.triggers, trigger);
    }

    private ObjectArray add(ObjectArray list, DbObject obj) {
        if (list == null) {
            list = new ObjectArray();
        }
        list.add(obj);
        return list;
    }

    public void fireBefore(Session session) throws SQLException {
        this.fire(session, true);
    }

    public void fireAfter(Session session) throws SQLException {
        this.fire(session, false);
    }

    private void fire(Session session, boolean beforeAction) throws SQLException {
        if (this.triggers != null) {
            for (int i = 0; i < this.triggers.size(); ++i) {
                TriggerObject trigger = (TriggerObject)this.triggers.get(i);
                trigger.fire(session, beforeAction);
            }
        }
    }

    public boolean fireRow() {
        return this.constraints != null && this.constraints.size() > 0 || this.triggers != null && this.triggers.size() > 0;
    }

    public void fireBeforeRow(Session session, Row oldRow, Row newRow) throws SQLException {
        this.fireRow(session, oldRow, newRow, true);
        this.fireConstraints(session, oldRow, newRow, true);
    }

    private void fireConstraints(Session session, Row oldRow, Row newRow, boolean before) throws SQLException {
        if (this.constraints != null) {
            for (int i = 0; i < this.constraints.size(); ++i) {
                Constraint constraint = (Constraint)this.constraints.get(i);
                if (constraint.isBefore() != before) continue;
                constraint.checkRow(session, this, oldRow, newRow);
            }
        }
    }

    public void fireAfterRow(Session session, Row oldRow, Row newRow) throws SQLException {
        this.fireRow(session, oldRow, newRow, false);
        this.fireConstraints(session, oldRow, newRow, false);
    }

    private void fireRow(Session session, Row oldRow, Row newRow, boolean beforeAction) throws SQLException {
        if (this.triggers != null) {
            for (int i = 0; i < this.triggers.size(); ++i) {
                TriggerObject trigger = (TriggerObject)this.triggers.get(i);
                trigger.fireRow(session, oldRow, newRow, beforeAction);
            }
        }
    }

    public Column[] getColumns(String[] columnNames) throws SQLException {
        Column[] cols = new Column[columnNames.length];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = this.getColumn(columnNames[i]);
        }
        return cols;
    }

    public abstract boolean canGetRowCount();

    public abstract boolean canDrop();

    public abstract long getRowCount(Session var1) throws SQLException;

    public boolean getGlobalTemporary() {
        return false;
    }

    public boolean canTruncate() {
        return false;
    }

    public void setCheckForeignKeyConstraints(Session session, boolean enabled, boolean checkExisting) throws SQLException {
        if (enabled && checkExisting) {
            for (int i = 0; this.constraints != null && i < this.constraints.size(); ++i) {
                Constraint c = (Constraint)this.constraints.get(i);
                c.checkExistingData(session);
            }
        }
        this.checkForeignKeyConstraints = enabled;
    }

    public boolean getCheckForeignKeyConstraints() {
        return this.checkForeignKeyConstraints;
    }

    public Index getIndexForColumn(Column column, boolean first) {
        ObjectArray indexes = this.getIndexes();
        for (int i = 1; indexes != null && i < indexes.size(); ++i) {
            int idx;
            Index index = (Index)indexes.get(i);
            if (!index.canGetFirstOrLast(first) || (idx = index.getColumnIndex(column)) != 0) continue;
            return index;
        }
        return null;
    }

    public boolean isOnCommitDrop() {
        return this.onCommitDrop;
    }

    public void setOnCommitDrop(boolean onCommitDrop) {
        this.onCommitDrop = onCommitDrop;
    }

    public boolean isOnCommitTruncate() {
        return this.onCommitTruncate;
    }

    public void setOnCommitTruncate(boolean onCommitTruncate) {
        this.onCommitTruncate = onCommitTruncate;
    }

    public boolean isClustered() {
        return false;
    }
}

