/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.transaction.xa.Xid;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.util.ByteUtils;

public class JdbcXid
extends TraceObject
implements Xid {
    private static final String PREFIX = "XID";
    private int formatId;
    private byte[] branchQualifier;
    private byte[] globalTransactionId;

    JdbcXid(JdbcDataSourceFactory factory, int id, String tid) throws SQLException {
        this.setTrace(factory.getTrace(), 14, id);
        try {
            StringTokenizer tokenizer = new StringTokenizer(tid, "_");
            String prefix = tokenizer.nextToken();
            if (!PREFIX.equals(prefix)) {
                throw Message.getSQLException(90101, tid);
            }
            this.formatId = Integer.parseInt(tokenizer.nextToken());
            this.branchQualifier = ByteUtils.convertStringToBytes(tokenizer.nextToken());
            this.globalTransactionId = ByteUtils.convertStringToBytes(tokenizer.nextToken());
        }
        catch (Throwable e) {
            throw Message.getSQLException(90101, tid);
        }
    }

    public String getAsString() {
        StringBuffer buff = new StringBuffer(PREFIX);
        buff.append('_');
        buff.append(this.formatId);
        buff.append('_');
        buff.append(ByteUtils.convertBytesToString(this.branchQualifier));
        buff.append('_');
        buff.append(ByteUtils.convertBytesToString(this.globalTransactionId));
        return buff.toString();
    }

    public int getFormatId() {
        this.debugCodeCall("getFormatId");
        return this.formatId;
    }

    public byte[] getBranchQualifier() {
        this.debugCodeCall("getBranchQualifier");
        return this.branchQualifier;
    }

    public byte[] getGlobalTransactionId() {
        this.debugCodeCall("getGlobalTransactionId");
        return this.globalTransactionId;
    }
}

