/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class Update
extends Prepared {
    private Expression condition;
    private TableFilter tableFilter;
    private Expression[] expressions;

    public Update(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
        Table table = tableFilter.getTable();
        this.expressions = new Expression[table.getColumns().length];
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public void setAssignment(Column column, Expression expression) throws SQLException {
        int id = column.getColumnId();
        if (this.expressions[id] != null) {
            throw Message.getSQLException(42121, column.getName());
        }
        this.expressions[id] = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() throws SQLException {
        this.tableFilter.startQuery(this.session);
        this.tableFilter.reset();
        RowList rows = new RowList(this.session);
        try {
            Table table = this.tableFilter.getTable();
            this.session.getUser().checkRight(table, 8);
            table.fireBefore(this.session);
            table.lock(this.session, true, false);
            int columnCount = table.getColumns().length;
            this.setCurrentRowNumber(0);
            int count = 0;
            while (this.tableFilter.next()) {
                this.checkCancelled();
                this.setCurrentRowNumber(count + 1);
                if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
                Row oldRow = this.tableFilter.get();
                Row newRow = table.getTemplateRow();
                for (int i = 0; i < columnCount; ++i) {
                    Value newValue;
                    Expression newExpr = this.expressions[i];
                    if (newExpr == null) {
                        newValue = oldRow.getValue(i);
                    } else {
                        Column column = table.getColumn(i);
                        newValue = newExpr.getValue(this.session).convertTo(column.getType());
                    }
                    newRow.setValue(i, newValue);
                }
                table.validateConvertUpdateSequence(this.session, newRow);
                if (table.fireRow()) {
                    table.fireBeforeRow(this.session, oldRow, newRow);
                }
                rows.add(oldRow);
                rows.add(newRow);
                ++count;
            }
            table.updateRows(this, this.session, rows);
            if (table.fireRow()) {
                rows.invalidateCache();
                rows.reset();
                while (rows.hasNext()) {
                    this.checkCancelled();
                    Row o = rows.next();
                    Row n = rows.next();
                    table.fireAfterRow(this.session, o, n);
                }
            }
            table.fireAfter(this.session);
            int n = count;
            return n;
        }
        finally {
            rows.close();
        }
    }

    public String getPlanSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("UPDATE ");
        buff.append(this.tableFilter.getPlanSQL(false));
        buff.append("\nSET ");
        Table table = this.tableFilter.getTable();
        int columnCount = table.getColumns().length;
        int j = 0;
        for (int i = 0; i < columnCount; ++i) {
            Expression newExpr = this.expressions[i];
            if (newExpr == null) continue;
            if (j > 0) {
                buff.append(",\n");
            }
            ++j;
            Column column = table.getColumn(i);
            buff.append(column.getName());
            buff.append(" = ");
            buff.append(newExpr.getSQL());
        }
        if (this.condition != null) {
            buff.append("\nWHERE " + StringUtils.unEnclose(this.condition.getSQL()));
        }
        return buff.toString();
    }

    public void prepare() throws SQLException {
        if (this.condition != null) {
            this.condition.mapColumns(this.tableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.tableFilter);
        }
        for (int i = 0; i < this.expressions.length; ++i) {
            Expression expr = this.expressions[i];
            if (expr == null) continue;
            expr.mapColumns(this.tableFilter, 0);
            this.expressions[i] = expr.optimize(this.session);
        }
        PlanItem item = this.tableFilter.getBestPlanItem(this.session);
        this.tableFilter.setPlanItem(item);
        this.tableFilter.prepare();
    }

    public boolean isTransactional() {
        return true;
    }

    public LocalResult queryMeta() {
        return null;
    }
}

