/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.security.SecureSocketFactory;
import org.h2.util.MathUtils;

public class NetUtils {
    public static Socket createLoopbackSocket(int port, boolean ssl) throws IOException {
        return NetUtils.createSocket("127.0.0.1", port, ssl);
    }

    public static Socket createSocket(String server, int defaultPort, boolean ssl) throws IOException {
        int port = defaultPort;
        int startIndex = server.startsWith("[") ? server.indexOf(93) : 0;
        int idx = server.indexOf(58, startIndex);
        if (idx >= 0) {
            port = MathUtils.decodeInt(server.substring(idx + 1));
            server = server.substring(0, idx);
        }
        InetAddress address = InetAddress.getByName(server);
        return NetUtils.createSocket(address, port, ssl);
    }

    public static Socket createSocket(InetAddress address, int port, boolean ssl) throws IOException {
        if (ssl) {
            SecureSocketFactory f = SecureSocketFactory.getInstance();
            return f.createSocket(address, port);
        }
        return new Socket(address, port);
    }

    public static ServerSocket createServerSocket(int port, boolean ssl) throws SQLException {
        try {
            return NetUtils.createServerSocketTry(port, ssl);
        }
        catch (SQLException e) {
            return NetUtils.createServerSocketTry(port, ssl);
        }
    }

    private static ServerSocket createServerSocketTry(int port, boolean ssl) throws SQLException {
        try {
            if (ssl) {
                SecureSocketFactory f = SecureSocketFactory.getInstance();
                return f.createServerSocket(port);
            }
            return new ServerSocket(port);
        }
        catch (BindException be) {
            throw Message.getSQLException(90061, new String[]{"" + port, be.toString()}, be);
        }
        catch (IOException e) {
            throw Message.convertIOException(e, "port: " + port + " ssl: " + ssl);
        }
    }

    public static boolean isLoopbackAddress(Socket socket) {
        boolean result = true;
        result = socket.getInetAddress().isLoopbackAddress();
        return result;
    }

    public static ServerSocket closeSilently(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

