/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class TableFilter
implements ColumnResolver {
    private static final int BEFORE_FIRST = 0;
    private static final int FOUND = 1;
    private static final int AFTER_LAST = 2;
    private static final int NULL_ROW = 3;
    private final Table table;
    private final Select select;
    private String alias;
    private Session session;
    private Index index;
    private IndexColumn[] indexColumns;
    private Cursor cursor;
    private int scanCount;
    private boolean used;
    private final ObjectArray indexConditions = new ObjectArray();
    private Expression filterCondition;
    private Expression joinCondition;
    private SearchRow currentSearchRow;
    private Row current;
    private int state;
    private TableFilter join;
    private boolean outerJoin;
    private boolean foundOne;
    private Expression fullCondition;

    public TableFilter(Session session, Table table, String alias, boolean rightsChecked, Select select) throws SQLException {
        this.session = session;
        this.table = table;
        this.alias = alias;
        this.select = select;
        if (!rightsChecked) {
            session.getUser().checkRight(table, 1);
        }
    }

    public Select getSelect() {
        return this.select;
    }

    public Table getTable() {
        return this.table;
    }

    public void lock(Session session, boolean exclusive, boolean force) throws SQLException {
        this.table.lock(session, exclusive, force);
        if (this.join != null) {
            this.join.lock(session, exclusive, force);
        }
    }

    public PlanItem getBestPlanItem(Session session) throws SQLException {
        PlanItem item;
        if (this.indexConditions.size() == 0) {
            item = new PlanItem();
            item.setIndex(this.table.getScanIndex(session));
            item.cost = item.getIndex().getCost(session, null);
        } else {
            int len = this.table.getColumns().length;
            int[] masks = new int[len];
            for (int i = 0; i < this.indexConditions.size(); ++i) {
                int id;
                IndexCondition condition = (IndexCondition)this.indexConditions.get(i);
                if (!condition.isEvaluatable()) continue;
                if (condition.isAlwaysFalse()) {
                    masks = null;
                    break;
                }
                int n = id = condition.getColumn().getColumnId();
                masks[n] = masks[n] | condition.getMask();
            }
            item = this.table.getBestPlanItem(session, masks);
        }
        if (this.join != null) {
            this.setEvaluatable(this.join);
            item.setJoinPlan(this.join.getBestPlanItem(session));
            item.cost += item.cost * item.getJoinPlan().cost;
        }
        return item;
    }

    private void setEvaluatable(TableFilter join) {
        do {
            Expression e;
            if ((e = join.getJoinCondition()) == null) continue;
            e.setEvaluatable(this, true);
        } while ((join = join.getJoin()) != null);
    }

    public void setPlanItem(PlanItem item) {
        this.setIndex(item.getIndex());
        if (this.join != null && item.getJoinPlan() != null) {
            this.join.setPlanItem(item.getJoinPlan());
        }
    }

    public void prepare() throws SQLException {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            Column col;
            IndexCondition condition = (IndexCondition)this.indexConditions.get(i);
            if (condition.isAlwaysFalse() || this.index.getColumnIndex(col = condition.getColumn()) >= 0) continue;
            this.indexConditions.remove(i);
            --i;
        }
        if (this.join != null) {
            if (SysProperties.CHECK && this.join == this) {
                throw Message.getInternalError("self join");
            }
            this.join.prepare();
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimize(this.session);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.optimize(this.session);
        }
    }

    public void startQuery(Session session) throws SQLException {
        this.session = session;
        this.scanCount = 0;
        if (this.join != null) {
            this.join.startQuery(session);
        }
    }

    public void reset() {
        if (this.join != null) {
            this.join.reset();
        }
        this.state = 0;
        this.foundOne = false;
    }

    public boolean next() throws SQLException {
        boolean alwaysFalse = false;
        if (this.state == 2) {
            return false;
        }
        if (this.state == 0) {
            Row start = null;
            Row end = null;
            for (int i = 0; i < this.indexConditions.size(); ++i) {
                IndexCondition condition = (IndexCondition)this.indexConditions.get(i);
                if (condition.isAlwaysFalse()) {
                    alwaysFalse = true;
                    break;
                }
                Column column = condition.getColumn();
                int type = column.getType();
                int id = column.getColumnId();
                Value v = condition.getCurrentValue(this.session).convertTo(type);
                boolean isStart = condition.isStart();
                boolean isEnd = condition.isEnd();
                IndexColumn idxCol = this.indexColumns[id];
                if (idxCol != null && (idxCol.sortType & 1) != 0) {
                    boolean temp = isStart;
                    isStart = isEnd;
                    isEnd = temp;
                }
                if (isStart) {
                    if (start == null) {
                        start = this.table.getTemplateRow();
                    }
                    start.setValue(id, v);
                }
                if (!isEnd) continue;
                if (end == null) {
                    end = this.table.getTemplateRow();
                }
                end.setValue(id, v);
            }
            if (!alwaysFalse) {
                this.cursor = this.index.find(this.session, start, end);
                if (this.join != null) {
                    this.join.reset();
                }
            }
        } else if (this.join != null && this.join.next()) {
            return true;
        }
        while (this.state != 3) {
            if (alwaysFalse) {
                this.state = 2;
            } else {
                if ((++this.scanCount & 0xFFF) == 0) {
                    this.logScanCount();
                }
                if (this.cursor.next()) {
                    this.currentSearchRow = this.cursor.getSearchRow();
                    this.current = null;
                    this.state = 1;
                } else {
                    this.state = 2;
                }
            }
            if (this.state == 2) {
                if (!this.outerJoin || this.foundOne) break;
                this.state = 3;
                this.current = this.table.getNullRow();
                this.currentSearchRow = this.current;
            }
            if (!this.isOk(this.filterCondition)) continue;
            boolean joinConditionOk = this.isOk(this.joinCondition);
            if (this.state == 1 && joinConditionOk) {
                this.foundOne = true;
            }
            if (this.join != null) {
                this.join.reset();
            }
            boolean doContinue = false;
            if (this.join != null && !this.join.next()) {
                doContinue = true;
            }
            if (doContinue || this.state != 3 && !joinConditionOk) continue;
            return true;
        }
        this.state = 2;
        return false;
    }

    private void logScanCount() {
    }

    private boolean isOk(Expression condition) throws SQLException {
        if (condition == null) {
            return true;
        }
        return Boolean.TRUE.equals(condition.getBooleanValue(this.session));
    }

    public Row get() throws SQLException {
        if (this.current == null && this.currentSearchRow != null) {
            if (this.table.isClustered()) {
                this.current = this.table.getTemplateRow();
                for (int i = 0; i < this.currentSearchRow.getColumnCount(); ++i) {
                    this.current.setValue(i, this.currentSearchRow.getValue(i));
                }
            } else {
                this.current = this.cursor.get();
            }
        }
        return this.current;
    }

    public void set(Row current) {
        this.current = current;
        this.currentSearchRow = current;
    }

    public String getTableAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.table.getName();
    }

    public void addIndexCondition(IndexCondition condition) {
        this.indexConditions.add(condition);
    }

    public void addFilterCondition(Expression condition, boolean join) {
        if (join) {
            this.joinCondition = this.joinCondition == null ? condition : new ConditionAndOr(0, this.joinCondition, condition);
        } else {
            this.filterCondition = this.filterCondition == null ? condition : new ConditionAndOr(0, this.filterCondition, condition);
        }
    }

    public void addJoin(TableFilter filter, boolean outer, Expression on) throws SQLException {
        if (on != null) {
            on.mapColumns(this, 0);
        }
        if (this.join == null) {
            this.join = filter;
            filter.outerJoin = outer;
            if (on != null) {
                filter.mapAndAddFilter(on);
            }
        } else {
            this.join.addJoin(filter, outer, on);
        }
    }

    private void mapAndAddFilter(Expression on) throws SQLException {
        on.mapColumns(this, 0);
        this.addFilterCondition(on, true);
        on.createIndexConditions(this.session, this);
        if (this.join != null) {
            this.join.mapAndAddFilter(on);
        }
    }

    public TableFilter getJoin() {
        return this.join;
    }

    public boolean isJoinOuter() {
        return this.outerJoin;
    }

    public String getPlanSQL(boolean join) {
        Object condition;
        StringBuffer buff = new StringBuffer();
        if (join) {
            if (this.outerJoin) {
                buff.append("LEFT OUTER JOIN ");
            } else {
                buff.append("INNER JOIN ");
            }
        }
        buff.append(this.table.getSQL());
        if (this.alias != null) {
            buff.append(' ');
            buff.append(Parser.quoteIdentifier(this.alias));
        }
        buff.append(" /* ");
        StringBuffer planBuff = new StringBuffer();
        planBuff.append(this.index.getPlanSQL());
        if (this.indexConditions.size() > 0) {
            planBuff.append(": ");
            for (int i = 0; i < this.indexConditions.size(); ++i) {
                condition = (IndexCondition)this.indexConditions.get(i);
                if (i > 0) {
                    planBuff.append(" AND ");
                }
                planBuff.append(((IndexCondition)condition).getSQL());
            }
        }
        String plan = planBuff.toString();
        plan = StringUtils.quoteRemarkSQL(plan);
        buff.append(plan);
        buff.append(" */");
        if (this.joinCondition != null) {
            buff.append(" ON ");
            buff.append(StringUtils.unEnclose(this.joinCondition.getSQL()));
        }
        if (this.filterCondition != null) {
            buff.append(" /* WHERE ");
            condition = StringUtils.unEnclose(this.filterCondition.getSQL());
            condition = StringUtils.quoteRemarkSQL((String)condition);
            buff.append((String)condition);
            buff.append(" */");
        }
        return buff.toString();
    }

    public void removeUnusableIndexConditions() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            IndexCondition cond = (IndexCondition)this.indexConditions.get(i);
            if (cond.isEvaluatable()) continue;
            this.indexConditions.remove(i--);
        }
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
        Column[] columns = this.table.getColumns();
        this.indexColumns = new IndexColumn[columns.length];
        IndexColumn[] idxCols = index.getIndexColumns();
        if (idxCols != null) {
            for (int i = 0; i < columns.length; ++i) {
                int idx = index.getColumnIndex(columns[i]);
                if (idx < 0) continue;
                this.indexColumns[i] = idxCols[idx];
            }
        }
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean getUsed() {
        return this.used;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void removeJoin() {
        this.join = null;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void removeJoinCondition() {
        this.joinCondition = null;
    }

    public Expression getFilterCondition() {
        return this.filterCondition;
    }

    public void removeFilterCondition() {
        this.filterCondition = null;
    }

    public void setFullCondition(Expression condition) {
        this.fullCondition = condition;
        if (this.join != null) {
            this.join.setFullCondition(condition);
        }
    }

    public void optimizeFullCondition(boolean fromOuterJoin) {
        if (this.fullCondition != null) {
            this.fullCondition.addFilterConditions(this, fromOuterJoin || this.outerJoin);
            if (this.join != null) {
                this.join.optimizeFullCondition(fromOuterJoin || this.outerJoin);
            }
        }
    }

    public void setEvaluatable(TableFilter filter, boolean b) {
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(filter, b);
        }
        if (this.joinCondition != null) {
            this.joinCondition.setEvaluatable(filter, b);
        }
        if (this.join != null) {
            this.join.setEvaluatable(filter, b);
        }
    }

    public String getSchemaName() {
        return this.table.getSchema().getName();
    }

    public Column[] getColumns() {
        return this.table.getColumns();
    }

    public Column[] getSystemColumns() {
        if (!this.session.getDatabase().getMode().systemColumns) {
            return null;
        }
        Column[] sys = new Column[3];
        sys[0] = new Column("oid", 4);
        sys[0].setTable(this.table, 0);
        sys[1] = new Column("ctid", 13);
        sys[1].setTable(this.table, 0);
        sys[2] = new Column("CTID", 13);
        sys[2].setTable(this.table, 0);
        return sys;
    }

    public Value getValue(Column column) throws SQLException {
        if (this.currentSearchRow == null) {
            return null;
        }
        int columnId = column.getColumnId();
        if (this.current == null) {
            Value v = this.currentSearchRow.getValue(columnId);
            if (v != null) {
                return v;
            }
            this.current = this.cursor.get();
        }
        return this.current.getValue(columnId);
    }

    public TableFilter getTableFilter() {
        return this;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

