/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.ObjectUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueLong
extends Value {
    private final long value;
    public static final int PRECISION = 19;
    public static final int DISPLAY_SIZE = 20;
    private static final int STATIC_SIZE = 10;
    private static ValueLong[] cache;
    private static final BigInteger MIN;
    private static final BigInteger MAX;

    private ValueLong(long value) {
        this.value = value;
    }

    public Value add(Value v) throws SQLException {
        ValueLong other = (ValueLong)v;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            int sr;
            int so;
            int sv;
            long result = this.value + other.value;
            int n = this.value == 0L ? 0 : (sv = this.value < 0L ? -1 : 1);
            int n2 = other.value == 0L ? 0 : (so = other.value < 0L ? -1 : 1);
            int n3 = result == 0L ? 0 : (sr = result < 0L ? -1 : 1);
            if (sv != so || sr == so || sv == 0 || so == 0) {
                return ValueLong.get(result);
            }
            throw this.getOverflow();
        }
        return ValueLong.get(this.value + other.value);
    }

    public int getSignum() {
        return this.value == 0L ? 0 : (this.value < 0L ? -1 : 1);
    }

    public Value negate() throws SQLException {
        if (SysProperties.OVERFLOW_EXCEPTIONS && this.value == Long.MIN_VALUE) {
            throw this.getOverflow();
        }
        return ValueLong.get(-this.value);
    }

    private SQLException getOverflow() {
        return Message.getSQLException(90110, DataType.getDataType((int)5).name);
    }

    public Value subtract(Value v) throws SQLException {
        ValueLong other = (ValueLong)v;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            int so;
            int sv;
            int n = this.value == 0L ? 0 : (sv = this.value < 0L ? -1 : 1);
            int n2 = other.value == 0L ? 0 : (so = other.value < 0L ? -1 : 1);
            if (sv == so || so == 0) {
                return ValueLong.get(this.value - other.value);
            }
            return this.add(other.negate());
        }
        return ValueLong.get(this.value - other.value);
    }

    private boolean isInteger(long a) {
        return a >= Integer.MIN_VALUE && a <= Integer.MAX_VALUE;
    }

    public Value multiply(Value v) throws SQLException {
        ValueLong other = (ValueLong)v;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            BigInteger bo;
            long result = this.value * other.value;
            if (this.value == 0L || this.value == 1L || other.value == 0L || other.value == 1L) {
                return ValueLong.get(result);
            }
            if (this.isInteger(this.value) && this.isInteger(other.value)) {
                return ValueLong.get(result);
            }
            BigInteger bv = new BigInteger("" + this.value);
            BigInteger br = bv.multiply(bo = new BigInteger("" + other.value));
            if (br.compareTo(MIN) < 0 || br.compareTo(MAX) > 0) {
                throw this.getOverflow();
            }
            return ValueLong.get(br.longValue());
        }
        return ValueLong.get(this.value * other.value);
    }

    public Value divide(Value v) throws SQLException {
        ValueLong other = (ValueLong)v;
        if (other.value == 0L) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        return ValueLong.get(this.value / other.value);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 5;
    }

    public long getLong() {
        return this.value;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueLong v = (ValueLong)o;
        if (this.value == v.value) {
            return 0;
        }
        return this.value > v.value ? 1 : -1;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 19L;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public Object getObject() {
        return ObjectUtils.getLong(this.value);
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setLong(parameterIndex, this.value);
    }

    public static ValueLong get(long i) {
        if (i >= 0L && i < 10L) {
            return cache[(int)i];
        }
        return (ValueLong)Value.cache(new ValueLong(i));
    }

    public int getDisplaySize() {
        return 20;
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueLong && this.value == ((ValueLong)v).value;
    }

    static {
        MIN = new BigInteger("-9223372036854775808");
        MAX = new BigInteger("9223372036854775807");
        cache = new ValueLong[10];
        for (int i = 0; i < 10; ++i) {
            ValueLong.cache[i] = new ValueLong(i);
        }
    }
}

