/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.schema.Sequence;

public class AlterSequence
extends DefineCommand {
    private Sequence sequence;
    private Expression start;
    private Expression increment;

    public AlterSequence(Session session) {
        super(session);
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void setStartWith(Expression start) {
        this.start = start;
    }

    public void setIncrement(Expression increment) throws SQLException {
        this.increment = increment;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (this.start != null) {
            long startValue = this.start.optimize(this.session).getValue(this.session).getLong();
            this.sequence.setStartValue(startValue);
        }
        if (this.increment != null) {
            long incrementValue = this.increment.optimize(this.session).getValue(this.session).getLong();
            if (incrementValue == 0L) {
                throw Message.getSQLException(90008, new String[]{"0", "INCREMENT"});
            }
            this.sequence.setIncrement(incrementValue);
        }
        db.update(this.session, this.sequence);
        return 0;
    }
}

