/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BtreeIndex;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.ResultExternal;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class ResultTempTable
implements ResultExternal {
    private static final String COLUMN_NAME = "DATA";
    private Session session;
    private TableData table;
    private SortOrder sort;
    private Index index;
    private Cursor cursor;

    public ResultTempTable(Session session, SortOrder sort, int columnCount) throws SQLException {
        this.session = session;
        this.sort = sort;
        Schema schema = session.getDatabase().getSchema("PUBLIC");
        Column column = new Column(COLUMN_NAME, 17);
        column.setNullable(false);
        ObjectArray columns = new ObjectArray();
        columns.add(column);
        int tableId = session.getDatabase().allocateObjectId(true, true);
        String tableName = "TEMP_RESULT_SET_" + tableId;
        this.table = schema.createTable(tableName, tableId, columns, false, false);
        int indexId = session.getDatabase().allocateObjectId(true, true);
        IndexColumn indexColumn = new IndexColumn();
        indexColumn.column = column;
        indexColumn.columnName = COLUMN_NAME;
        IndexType indexType = IndexType.createPrimaryKey(true, false);
        IndexColumn[] indexCols = new IndexColumn[]{indexColumn};
        this.index = new BtreeIndex(session, this.table, indexId, tableName, indexCols, indexType, -1);
        this.table.getIndexes().add(this.index);
    }

    public int removeRow(Value[] values) throws SQLException {
        Row row = this.convertToRow(values);
        Cursor cursor = this.find(row);
        if (cursor != null) {
            row = cursor.get();
            this.table.removeRow(this.session, row);
        }
        return (int)this.table.getRowCount(this.session);
    }

    public boolean contains(Value[] values) throws SQLException {
        return this.find(this.convertToRow(values)) != null;
    }

    public int addRow(Value[] values) throws SQLException {
        Row row = this.convertToRow(values);
        Cursor cursor = this.find(row);
        if (cursor == null) {
            this.table.addRow(this.session, row);
        }
        return (int)this.table.getRowCount(this.session);
    }

    public void addRows(ObjectArray rows) throws SQLException {
        if (this.sort != null) {
            this.sort.sort(rows);
        }
        for (int i = 0; i < rows.size(); ++i) {
            Value[] values = (Value[])rows.get(i);
            this.addRow(values);
        }
    }

    public void close() {
        try {
            if (this.table != null) {
                this.index.remove(this.session);
                ObjectArray indexes = this.table.getIndexes();
                indexes.remove(indexes.indexOf(this.index));
                this.table.removeChildrenAndResources(this.session);
            }
        }
        catch (SQLException e) {
            throw Message.convertToInternal(e);
        }
        finally {
            this.table = null;
        }
    }

    public void done() throws SQLException {
    }

    public Value[] next() throws SQLException {
        if (!this.cursor.next()) {
            return null;
        }
        Row row = this.cursor.get();
        ValueArray data = (ValueArray)row.getValue(0);
        return data.getList();
    }

    public void reset() throws SQLException {
        this.cursor = this.index.find(this.session, null, null);
    }

    private Row convertToRow(Value[] values) {
        ValueArray data = ValueArray.get(values);
        return new Row(new Value[]{data}, data.getMemory());
    }

    private Cursor find(Row row) throws SQLException {
        Cursor cursor = this.index.find(this.session, row, row);
        while (cursor.next()) {
            SearchRow found = cursor.getSearchRow();
            if (!found.getValue(0).equals(row.getValue(0))) continue;
            return cursor;
        }
        return null;
    }
}

