/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import org.h2.message.Message;
import org.h2.util.ClassUtils;
import org.h2.util.JdbcDriverUtils;
import org.h2.util.StringUtils;

public class JdbcUtils {
    static /* synthetic */ Class class$java$sql$Driver;
    static /* synthetic */ Class class$javax$naming$Context;

    public static void closeSilently(Statement stat) {
        if (stat != null) {
            try {
                stat.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static ResultSet getGeneratedKeys(Statement stat) throws SQLException {
        ResultSet rs = null;
        rs = stat.getGeneratedKeys();
        return rs;
    }

    public static void closeSilently(XAConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(String driver, String url, String user, String password) throws SQLException {
        Properties prop = new Properties();
        prop.setProperty("user", user);
        prop.setProperty("password", password);
        return JdbcUtils.getConnection(driver, url, prop);
    }

    public static Connection getConnection(String driver, String url, Properties prop) throws SQLException {
        try {
            if (!StringUtils.isNullOrEmpty(driver)) {
                Class d;
                if ((class$java$sql$Driver == null ? (class$java$sql$Driver = JdbcUtils.class$("java.sql.Driver")) : class$java$sql$Driver).isAssignableFrom(d = ClassUtils.loadUserClass(driver))) {
                    return DriverManager.getConnection(url, prop);
                }
                if ((class$javax$naming$Context == null ? (class$javax$naming$Context = JdbcUtils.class$("javax.naming.Context")) : class$javax$naming$Context).isAssignableFrom(d)) {
                    try {
                        Context context = (Context)d.newInstance();
                        DataSource ds = (DataSource)context.lookup(url);
                        String user = prop.getProperty("user");
                        String password = prop.getProperty("password");
                        if (StringUtils.isNullOrEmpty(user) && StringUtils.isNullOrEmpty(password)) {
                            return ds.getConnection();
                        }
                        return ds.getConnection(user, password);
                    }
                    catch (InstantiationException e) {
                        throw Message.convert(e);
                    }
                    catch (IllegalAccessException e) {
                        throw Message.convert(e);
                    }
                    catch (NamingException e) {
                        throw Message.convert(e);
                    }
                }
                return DriverManager.getConnection(url, prop);
            }
            JdbcDriverUtils.load(url);
        }
        catch (ClassNotFoundException e) {
            throw Message.getSQLException(90086, new String[]{driver}, e);
        }
        catch (NoClassDefFoundError e) {
            throw Message.getSQLException(90086, new String[]{driver}, e);
        }
        return DriverManager.getConnection(url, prop);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

