/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import org.h2.constant.SysProperties;
import org.h2.message.TraceSystem;
import org.h2.util.StringUtils;

public class Trace {
    private TraceSystem traceSystem;
    private String module;
    private String lineSeparator;
    public static final String LOCK = "lock";
    public static final String SETTING = "setting";
    public static final String COMMAND = "command";
    public static final String INDEX = "index";
    public static final String SEQUENCE = "sequence";
    public static final String CONSTRAINT = "constraint";
    public static final String USER = "user";
    public static final String TRIGGER = "trigger";
    public static final String FUNCTION = "function";
    public static final String JDBC = "jdbc";
    public static final String FILE_LOCK = "fileLock";
    public static final String TABLE = "table";
    public static final String LOG = "log";
    public static final String SCHEMA = "schema";
    public static final String DATABASE = "database";
    public static final String SESSION = "session";
    public static final String AGGREGATE = "aggregate";

    public Trace(TraceSystem traceSystem, String string) {
        this.traceSystem = traceSystem;
        this.module = string;
        this.lineSeparator = SysProperties.LINE_SEPARATOR;
    }

    public boolean info() {
        return this.traceSystem.isEnabled(2);
    }

    public boolean debug() {
        return this.traceSystem.isEnabled(3);
    }

    public void error(String string) {
        this.traceSystem.write(1, this.module, string, null);
    }

    public void error(String string, Throwable throwable) {
        this.traceSystem.write(1, this.module, string, throwable);
    }

    public void info(String string) {
        this.traceSystem.write(2, this.module, string, null);
    }

    public void debugCode(String string) {
        this.traceSystem.write(3, this.module, this.lineSeparator + "/**/" + string, null);
    }

    public void infoCode(String string) {
        this.traceSystem.write(2, this.module, this.lineSeparator + "/**/" + string, null);
    }

    public void infoSQL(String string, String string2, int n, long l) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        stringBuffer.append(this.lineSeparator);
        stringBuffer.append("/*SQL ");
        if (string2.length() > 0) {
            stringBuffer.append("l:");
            stringBuffer.append(string.length());
        }
        if (n > 0) {
            stringBuffer.append(" #:");
            stringBuffer.append(n);
        }
        if (l > 0L) {
            stringBuffer.append(" t:");
            stringBuffer.append(l);
        }
        stringBuffer.append("*/");
        stringBuffer.append(StringUtils.javaEncode(string));
        stringBuffer.append(string2);
        stringBuffer.append(';');
        string = stringBuffer.toString();
        this.traceSystem.write(2, this.module, string, null);
    }

    public void debug(String string) {
        this.traceSystem.write(3, this.module, string, null);
    }

    public void debug(String string, Throwable throwable) {
        this.traceSystem.write(3, this.module, string, throwable);
    }
}

