/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.h2.message.Message;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

public class ConvertTraceFile
extends Tool {
    private HashMap stats = new HashMap();
    private long timeTotal;

    private void showUsage() {
        this.out.println("Converts a .trace.db file to a SQL script and Java source code.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-traceFile <file>]  The trace file name (default: test.trace.db)\n" + " [-script <file>]     The script file name (default: test.sql)\n" + " [-javaClass <file>]  The Java directory and class file name (default: Test)");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        new ConvertTraceFile().run(stringArray);
    }

    public void run(String[] stringArray) throws SQLException {
        String string = "test.trace.db";
        String string2 = "Test";
        String string3 = "test.sql";
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.equals("-traceFile")) {
                string = stringArray[++i];
                continue;
            }
            if (string4.equals("-javaClass")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string4.equals("-script")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string4.equals("-help") || string4.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + string4);
            this.showUsage();
            return;
        }
        try {
            this.convertFile(string, string2, string3);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, string);
        }
    }

    private void convertFile(String string, String string2, String string3) throws IOException, SQLException {
        Object object;
        String string4;
        LineNumberReader lineNumberReader = new LineNumberReader(IOUtils.getReader(FileUtils.openFileInputStream(string)));
        PrintWriter printWriter = new PrintWriter(FileUtils.openFileWriter(string2 + ".java", false));
        PrintWriter printWriter2 = new PrintWriter(FileUtils.openFileWriter(string3, false));
        printWriter.println("import java.io.*;");
        printWriter.println("import java.sql.*;");
        printWriter.println("import java.math.*;");
        printWriter.println("import java.util.Calendar;");
        String string5 = string2.replace('\\', '/');
        int n = string5.lastIndexOf(47);
        if (n > 0) {
            string5 = string5.substring(n + 1);
        }
        printWriter.println("public class " + string5 + " {");
        printWriter.println("    public static void main(String[] args) throws Exception {");
        printWriter.println("        Class.forName(\"org.h2.Driver\");");
        while ((string4 = lineNumberReader.readLine()) != null) {
            if (string4.startsWith("/**/")) {
                string4 = "        " + string4.substring(4);
                printWriter.println(string4);
                continue;
            }
            if (!string4.startsWith("/*SQL")) continue;
            int n2 = string4.indexOf("*/");
            String string6 = string4.substring(n2 + "*/".length());
            if ((string4 = string4.substring("/*SQL".length(), n2)).length() > 0) {
                object = string6;
                int n3 = 0;
                int n4 = 0;
                if ((string4 = string4.trim()).length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, " :");
                    while (stringTokenizer.hasMoreElements()) {
                        String string7 = stringTokenizer.nextToken();
                        if ("l".equals(string7)) {
                            int n5 = Integer.parseInt(stringTokenizer.nextToken());
                            object = string6.substring(0, n5) + ";";
                            continue;
                        }
                        if ("#".equals(string7)) {
                            n3 = Integer.parseInt(stringTokenizer.nextToken());
                            continue;
                        }
                        if (!"t".equals(string7)) continue;
                        n4 = Integer.parseInt(stringTokenizer.nextToken());
                    }
                }
                this.addToStats((String)object, n3, n4);
            }
            printWriter2.println(StringUtils.javaDecode(string6));
        }
        printWriter.println("    }");
        printWriter.println("}");
        lineNumberReader.close();
        printWriter.close();
        if (this.stats.size() > 0) {
            printWriter2.println("-----------------------------------------");
            printWriter2.println("-- SQL Statement Statistics");
            printWriter2.println("-- time: total time in milliseconds");
            printWriter2.println("-- count: how many times the statement ran");
            printWriter2.println("-- result: total update count or row count");
            printWriter2.println("-----------------------------------------");
            printWriter2.println("-- self accu    time   count  result sql");
            int n6 = 0;
            ArrayList arrayList = new ArrayList(this.stats.values());
            Collections.sort(arrayList);
            if (this.timeTotal == 0L) {
                this.timeTotal = 1L;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (Stat)arrayList.get(i);
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append("-- ");
                stringBuffer.append(this.padNumberLeft(100L * ((Stat)object).time / this.timeTotal, 3));
                stringBuffer.append("% ");
                n6 = (int)((long)n6 + ((Stat)object).time);
                stringBuffer.append(this.padNumberLeft((long)(100 * n6) / this.timeTotal, 3));
                stringBuffer.append('%');
                stringBuffer.append(this.padNumberLeft(((Stat)object).time, 8));
                stringBuffer.append(this.padNumberLeft(((Stat)object).executeCount, 8));
                stringBuffer.append(this.padNumberLeft(((Stat)object).resultCount, 8));
                stringBuffer.append(' ');
                stringBuffer.append(((Stat)object).sql);
                printWriter2.println(stringBuffer.toString());
            }
        }
        printWriter2.close();
    }

    private String padNumberLeft(long l, int n) {
        return StringUtils.pad(String.valueOf(l), n, " ", false);
    }

    private void addToStats(String string, int n, int n2) {
        Stat stat = (Stat)this.stats.get(string);
        if (stat == null) {
            stat = new Stat();
            stat.sql = string;
            this.stats.put(string, stat);
        }
        ++stat.executeCount;
        stat.resultCount += (long)n;
        stat.time += (long)n2;
        this.timeTotal += (long)n2;
    }

    private static class Stat
    implements Comparable {
        String sql;
        int executeCount;
        long time;
        long resultCount;

        private Stat() {
        }

        public int compareTo(Object object) {
            int n;
            Stat stat = (Stat)object;
            if (stat == this) {
                return 0;
            }
            int n2 = stat.time > this.time ? 1 : (n = stat.time < this.time ? -1 : 0);
            if (n == 0) {
                int n3 = stat.executeCount > this.executeCount ? 1 : (n = stat.executeCount < this.executeCount ? -1 : 0);
                if (n == 0) {
                    n = this.sql.compareTo(stat.sql);
                }
            }
            return n;
        }
    }
}

