/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashSet;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BtreeIndex;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.index.ScanIndex;
import org.h2.index.TreeIndex;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.store.DataPage;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;

public class TableData
extends Table
implements RecordReader {
    private final boolean clustered;
    private ScanIndex scanIndex;
    private long rowCount;
    private Session lockExclusive;
    private HashSet lockShared = new HashSet();
    private Trace traceLock;
    private boolean globalTemporary;
    private final ObjectArray indexes = new ObjectArray();
    private long lastModificationId;
    private boolean containsLargeObject;

    public TableData(Schema schema, String string, int n, ObjectArray objectArray, boolean bl, boolean bl2) throws SQLException {
        super(schema, n, string, bl);
        Object[] objectArray2 = new Column[objectArray.size()];
        objectArray.toArray(objectArray2);
        this.setColumns((Column[])objectArray2);
        this.clustered = bl2;
        if (!bl2) {
            this.scanIndex = new ScanIndex(this, n, IndexColumn.wrap((Column[])objectArray2), IndexType.createScan(bl));
            this.indexes.add(this.scanIndex);
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            if (!DataType.isLargeObject(((Column)objectArray2[i]).getType())) continue;
            this.containsLargeObject = true;
            this.memoryPerRow = -1;
        }
        this.traceLock = this.database.getTrace("lock");
    }

    public void close(Session session) throws SQLException {
        for (int i = 0; i < this.indexes.size(); ++i) {
            Index index = (Index)this.indexes.get(i);
            index.close(session);
        }
    }

    public Row getRow(Session session, int n) throws SQLException {
        return this.scanIndex.getRow(session, n);
    }

    public void addRow(Session session, Row row) throws SQLException {
        int n = 0;
        this.lastModificationId = this.database.getNextModificationDataId();
        if (this.database.isMultiVersion()) {
            row.setSessionId(session.getId());
        }
        try {
            while (n < this.indexes.size()) {
                Index index = (Index)this.indexes.get(n);
                index.add(session, row);
                this.checkRowCount(session, index, 1);
                ++n;
            }
            ++this.rowCount;
        }
        catch (Throwable throwable) {
            while (--n >= 0) {
                Index index = (Index)this.indexes.get(n);
                index.remove(session, row);
                this.checkRowCount(session, index, 0);
            }
            throw Message.convert(throwable);
        }
    }

    private void checkRowCount(Session session, Index index, int n) {
        long l;
        if (SysProperties.CHECK && !this.database.isMultiVersion() && (l = index.getRowCount(session)) != this.rowCount + (long)n) {
            throw Message.getInternalError("rowCount expected " + (this.rowCount + (long)n) + " got " + l + " " + this.getName() + "." + index.getName());
        }
    }

    public Index getScanIndex(Session session) {
        return (Index)this.indexes.get(0);
    }

    public Index getUniqueIndex() {
        for (int i = 0; i < this.indexes.size(); ++i) {
            Index index = (Index)this.indexes.get(i);
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    public ObjectArray getIndexes() {
        return this.indexes;
    }

    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, String string2) throws SQLException {
        Object object;
        if (indexType.isPrimaryKey()) {
            for (int i = 0; i < indexColumnArray.length; ++i) {
                object = indexColumnArray[i].column;
                if (((Column)object).getNullable()) {
                    throw Message.getSQLException(90023, ((Column)object).getName());
                }
                ((Column)object).setPrimaryKey(true);
            }
        }
        Index index = this.isPersistent() && indexType.isPersistent() ? new BtreeIndex(session, this, n, string, indexColumnArray, indexType, n2) : (indexType.isHash() ? new HashIndex(this, n, string, indexColumnArray, indexType) : new TreeIndex(this, n, string, indexColumnArray, indexType));
        if (this.database.isMultiVersion()) {
            index = new MultiVersionIndex(index, this);
        }
        if (index.needRebuild() && this.rowCount > 0L) {
            try {
                long l;
                object = this.getScanIndex(session);
                long l2 = l = object.getRowCount(session);
                Cursor cursor = object.find(session, null, null);
                long l3 = 0L;
                int n3 = 10000;
                ObjectArray objectArray = new ObjectArray(n3);
                while (cursor.next()) {
                    this.database.setProgress(1, this.getName(), MathUtils.convertLongToInt(l3++), MathUtils.convertLongToInt(l2));
                    Row row = cursor.get();
                    objectArray.add(row);
                    if (objectArray.size() >= n3) {
                        this.addRowsToIndex(session, objectArray, index);
                    }
                    --l;
                }
                this.addRowsToIndex(session, objectArray, index);
                if (SysProperties.CHECK && l != 0L) {
                    throw Message.getInternalError("rowcount remaining=" + l + " " + this.getName());
                }
            }
            catch (SQLException sQLException) {
                this.getSchema().freeUniqueName(string);
                index.remove(session);
                throw sQLException;
            }
        }
        boolean bl = this.getTemporary();
        index.setTemporary(bl);
        if (index.getCreateSQL() != null) {
            index.setComment(string2);
            this.database.addSchemaObject(session, index);
            if (index.getIndexType().isPersistent() && !this.database.getReadOnly() && !this.database.getLog().containsInDoubtTransactions()) {
                this.database.update(session, index);
            }
        }
        this.indexes.add(index);
        this.setModified();
        return index;
    }

    public boolean canGetRowCount() {
        return true;
    }

    private void addRowsToIndex(Session session, ObjectArray objectArray, Index index) throws SQLException {
        final Index index2 = index;
        try {
            objectArray.sort(new Comparator(){

                public int compare(Object object, Object object2) {
                    Row row = (Row)object;
                    Row row2 = (Row)object2;
                    try {
                        return index2.compareRows(row, row2);
                    }
                    catch (SQLException sQLException) {
                        throw Message.convertToInternal(sQLException);
                    }
                }
            });
        }
        catch (Exception exception) {
            throw Message.convert(exception);
        }
        for (int i = 0; i < objectArray.size(); ++i) {
            Row row = (Row)objectArray.get(i);
            index.add(session, row);
        }
        objectArray.clear();
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            return this.getScanIndex(session).getRowCount(session);
        }
        return this.rowCount;
    }

    public void removeRow(Session session, Row row) throws SQLException {
        int n;
        this.lastModificationId = this.database.getNextModificationDataId();
        if (this.database.isMultiVersion()) {
            if (row.getDeleted()) {
                throw Message.getSQLException(90131, this.getName());
            }
            n = row.getSessionId();
            int n2 = session.getId();
            if (n == 0) {
                row.setSessionId(n2);
            } else if (n != n2) {
                throw Message.getSQLException(90131, this.getName());
            }
        }
        try {
            for (n = this.indexes.size() - 1; n >= 0; --n) {
                Index index = (Index)this.indexes.get(n);
                index.remove(session, row);
                this.checkRowCount(session, index, -1);
            }
            --this.rowCount;
        }
        catch (Throwable throwable) {
            while (++n < this.indexes.size()) {
                Index index = (Index)this.indexes.get(n);
                index.add(session, row);
                this.checkRowCount(session, index, 0);
            }
            throw Message.convert(throwable);
        }
    }

    public void truncate(Session session) throws SQLException {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            long l;
            Index index = (Index)this.indexes.get(i);
            index.truncate(session);
            if (!SysProperties.CHECK || (l = index.getRowCount(session)) == 0L) continue;
            throw Message.getInternalError("rowCount expected 0 got " + l);
        }
        this.rowCount = 0L;
    }

    public boolean isLockExclusive(Session session) {
        return this.lockExclusive == session;
    }

    public void lock(Session session, boolean bl, boolean bl2) throws SQLException {
        int n = this.database.getLockMode();
        if (n == 0) {
            return;
        }
        long l = System.currentTimeMillis() + (long)session.getLockTimeout();
        if (!bl2 && this.database.isMultiVersion()) {
            if (bl) {
                bl = false;
            } else {
                return;
            }
        }
        Database database = this.database;
        synchronized (database) {
            while (true) {
                long l2;
                if (this.lockExclusive == session) {
                    return;
                }
                if (bl) {
                    if (this.lockExclusive == null) {
                        if (this.lockShared.isEmpty()) {
                            this.traceLock(session, bl, "added for");
                            session.addLock(this);
                            this.lockExclusive = session;
                            return;
                        }
                        if (this.lockShared.size() == 1 && this.lockShared.contains(session)) {
                            this.traceLock(session, bl, "add (upgraded) for ");
                            this.lockExclusive = session;
                            return;
                        }
                    }
                } else if (this.lockExclusive == null) {
                    if (n == 3 && !this.database.getMultiThreaded() && !this.database.isMultiVersion()) {
                        return;
                    }
                    if (!this.lockShared.contains(session)) {
                        this.traceLock(session, bl, "ok");
                        session.addLock(this);
                        this.lockShared.add(session);
                    }
                    return;
                }
                if ((l2 = System.currentTimeMillis()) >= l) {
                    this.traceLock(session, bl, "timeout after " + session.getLockTimeout());
                    throw Message.getSQLException(50200, this.getName());
                }
                try {
                    this.traceLock(session, bl, "waiting for");
                    if (this.database.getLockMode() == 2) {
                        for (int i = 0; i < 20; ++i) {
                            long l3 = Runtime.getRuntime().freeMemory();
                            System.gc();
                            long l4 = Runtime.getRuntime().freeMemory();
                            if (l3 == l4) break;
                        }
                    }
                    this.database.wait(l - l2);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void traceLock(Session session, boolean bl, String string) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug(session.getId() + " " + (bl ? "exclusive write lock" : "shared read lock") + " " + string + " " + this.getName());
        }
    }

    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE ");
        if (this.getTemporary()) {
            if (this.globalTemporary) {
                stringBuffer.append("GLOBAL ");
            } else {
                stringBuffer.append("LOCAL ");
            }
            stringBuffer.append("TEMPORARY ");
        } else if (this.isPersistent()) {
            stringBuffer.append("CACHED ");
        } else {
            stringBuffer.append("MEMORY ");
        }
        stringBuffer.append("TABLE ");
        stringBuffer.append(this.getSQL());
        if (this.comment != null) {
            stringBuffer.append(" COMMENT ");
            stringBuffer.append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuffer.append("(\n    ");
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            if (i > 0) {
                stringBuffer.append(",\n    ");
            }
            stringBuffer.append(column.getCreateSQL());
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }

    public boolean isLockedExclusively() {
        return this.lockExclusive != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Session session) {
        if (this.database != null) {
            this.traceLock(session, this.lockExclusive == session, "unlock");
            if (this.lockExclusive == session) {
                this.lockExclusive = null;
            }
            if (this.lockShared.size() > 0) {
                this.lockShared.remove(session);
            }
            Database database = this.database;
            synchronized (database) {
                if (this.database.getSessionCount() > 1) {
                    this.database.notifyAll();
                }
            }
        }
    }

    public Record read(Session session, DataPage dataPage) throws SQLException {
        int n = dataPage.readInt();
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            valueArray[i] = dataPage.readValue();
        }
        Row row = new Row(valueArray, this.memoryPerRow);
        return row;
    }

    public void setRowCount(int n) {
        this.rowCount = n;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        Object object;
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            object = (Index)this.indexes.get(1);
            if (object.getName() == null) continue;
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        if (SysProperties.CHECK) {
            object = this.database.getAllSchemaObjects(1);
            for (int i = 0; i < ((ObjectArray)object).size(); ++i) {
                Index index = (Index)((ObjectArray)object).get(i);
                if (index.getTable() != this) continue;
                throw Message.getInternalError("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session);
        this.database.removeMeta(session, this.getId());
        this.scanIndex = null;
        this.lockExclusive = null;
        this.lockShared = null;
        this.invalidate();
    }

    public void checkRename() {
    }

    public void checkSupportAlter() {
    }

    public boolean canTruncate() {
        ObjectArray objectArray = this.getConstraints();
        for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
            ConstraintReferential constraintReferential;
            Constraint constraint = (Constraint)objectArray.get(i);
            if (!constraint.getConstraintType().equals("REFERENTIAL") || (constraintReferential = (ConstraintReferential)constraint).getRefTable() != this) continue;
            return false;
        }
        return true;
    }

    public String getTableType() {
        return "TABLE";
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    public boolean getGlobalTemporary() {
        return this.globalTemporary;
    }

    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }
}

