/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.TcpServer;
import org.h2.server.ftp.FtpServer;
import org.h2.server.pg.PgServer;
import org.h2.server.web.WebServer;
import org.h2.util.StartBrowser;
import org.h2.util.Tool;

public class Server
implements Runnable,
ShutdownHandler {
    private static final int EXIT_ERROR = 1;
    private Service service;
    private Server web;
    private Server tcp;
    private Server pg;
    private Server ftp;
    private ShutdownHandler shutdownHandler;

    public Server() {
    }

    private Server(Service service, String[] stringArray) throws SQLException {
        this.service = service;
        try {
            service.init(stringArray);
        }
        catch (Exception exception) {
            throw Message.convert(exception);
        }
    }

    private void showUsage(String string, PrintStream printStream) {
        if (string != null) {
            printStream.println("Unsupported option: " + string);
            printStream.println();
        }
        printStream.println("Starts H2 Servers");
        printStream.println("By default, -tcp, -web, -browser and -pg are started. Options are case sensitive.");
        printStream.println("java " + this.getClass().getName());
        printStream.println("-web                  Start the Web Server and H2 Console");
        printStream.println("-webAllowOthers       Allow other computers to connect");
        printStream.println("-webPort <port>       The port (default: 8082)");
        printStream.println("-webSSL               Use encrypted HTTPS connections");
        printStream.println("-browser              Start a browser to connect to the H2 Console");
        printStream.println("-tcp                  Start the TCP Server");
        printStream.println("-tcpAllowOthers       Allow other computers to connect");
        printStream.println("-tcpPort <port>       The port (default: 9092)");
        printStream.println("-tcpSSL               Use encrypted SSL connections");
        printStream.println("-tcpPassword <pass>   The password for shutting down a TCP Server");
        printStream.println("-tcpShutdown <url>    Shutdown the TCP Server; example: tcp://localhost:9094");
        printStream.println("-tcpShutdownForce     Don't wait for other connections to close");
        printStream.println("-pg                   Start the PG Server");
        printStream.println("-pgAllowOthers        Allow other computers to connect");
        printStream.println("-pgPort <port>        The port (default: 5435)");
        printStream.println("-ftp                  Start the FTP Server");
        printStream.println("-ftpPort <port>       The port (default: 8021)");
        printStream.println("-ftpDir <dir>         The base directory (default: ftp)");
        printStream.println("-ftpRead <user>       The user name for reading (default: guest)");
        printStream.println("-ftpWrite <user>      The user name for writing (default: sa)");
        printStream.println("-ftpWritePassword <p> The write password (default: sa)");
        printStream.println("-baseDir <dir>        The base directory for H2 databases; for all servers");
        printStream.println("-ifExists             Only existing databases may be opened; for all servers");
        printStream.println("-trace                Print additional trace information; for all servers");
        printStream.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        int n = new Server().run(stringArray, System.out);
        if (n != 0) {
            System.exit(n);
        }
    }

    public int run(String[] stringArray, PrintStream printStream) throws SQLException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        String string = "";
        String string2 = "";
        boolean bl8 = true;
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            String string3 = stringArray[n];
            if (string3 == null) continue;
            if ("-?".equals(string3) || "-help".equals(string3)) {
                this.showUsage(null, printStream);
                return 1;
            }
            if (string3.startsWith("-web")) {
                if ("-web".equals(string3)) {
                    bl8 = false;
                    bl3 = true;
                    continue;
                }
                if ("-webAllowOthers".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, n) == 0) continue;
                    ++n;
                    continue;
                }
                if ("-webSSL".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, n) == 0) continue;
                    ++n;
                    continue;
                }
                if ("-webPort".equals(string3)) {
                    ++n;
                    continue;
                }
                if ("-webScript".equals(string3)) {
                    ++n;
                    continue;
                }
                this.showUsage(string3, printStream);
                return 1;
            }
            if ("-browser".equals(string3)) {
                bl8 = false;
                bl5 = true;
                continue;
            }
            if (string3.startsWith("-tcp")) {
                if ("-tcp".equals(string3)) {
                    bl8 = false;
                    bl = true;
                    continue;
                }
                if ("-tcpAllowOthers".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, n) == 0) continue;
                    ++n;
                    continue;
                }
                if ("-tcpSSL".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, n) == 0) continue;
                    ++n;
                    continue;
                }
                if ("-tcpPort".equals(string3)) {
                    ++n;
                    continue;
                }
                if ("-tcpPassword".equals(string3)) {
                    string = stringArray[++n];
                    continue;
                }
                if ("-tcpShutdown".equals(string3)) {
                    bl8 = false;
                    bl6 = true;
                    string2 = stringArray[++n];
                    continue;
                }
                if ("-tcpShutdownForce".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, n) != 0) {
                        bl7 = Tool.readArgBoolean(stringArray, n) == 1;
                        ++n;
                        continue;
                    }
                    bl7 = true;
                    continue;
                }
                this.showUsage(string3, printStream);
                return 1;
            }
            if (string3.startsWith("-pg")) {
                if ("-pg".equals(string3)) {
                    bl8 = false;
                    bl2 = true;
                    continue;
                }
                if ("-pgAllowOthers".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, n) == 0) continue;
                    ++n;
                    continue;
                }
                if ("-pgPort".equals(string3)) {
                    ++n;
                    continue;
                }
                this.showUsage(string3, printStream);
                return 1;
            }
            if (string3.startsWith("-ftp")) {
                if ("-ftp".equals(string3)) {
                    bl8 = false;
                    bl4 = true;
                    continue;
                }
                if ("-ftpPort".equals(string3)) {
                    ++n;
                    continue;
                }
                if ("-ftpDir".equals(string3)) {
                    ++n;
                    continue;
                }
                if ("-ftpRead".equals(string3)) {
                    ++n;
                    continue;
                }
                if ("-ftpWrite".equals(string3)) {
                    ++n;
                    continue;
                }
                if ("-ftpWritePassword".equals(string3)) {
                    ++n;
                    continue;
                }
                if ("-ftpTask".equals(string3)) continue;
                this.showUsage(string3, printStream);
                return 1;
            }
            if ("-trace".equals(string3)) continue;
            if ("-log".equals(string3) && SysProperties.OLD_COMMAND_LINE_OPTIONS) {
                ++n;
                continue;
            }
            if ("-ifExists".equals(string3)) {
                if (Tool.readArgBoolean(stringArray, n) == 0) continue;
                ++n;
                continue;
            }
            if ("-baseDir".equals(string3)) {
                ++n;
                continue;
            }
            this.showUsage(string3, printStream);
            return 1;
        }
        n = 0;
        if (bl8) {
            bl = true;
            bl2 = true;
            bl3 = true;
            bl5 = true;
        }
        if (bl6) {
            printStream.println("Shutting down TCP Server at " + string2);
            Server.shutdownTcpServer(string2, string, bl7);
        }
        if (bl) {
            this.tcp = Server.createTcpServer(stringArray);
            try {
                this.tcp.start();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                n = 1;
            }
            printStream.println(this.tcp.getStatus());
        }
        if (bl2) {
            this.pg = Server.createPgServer(stringArray);
            try {
                this.pg.start();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                n = 1;
            }
            printStream.println(this.pg.getStatus());
        }
        if (bl3) {
            this.web = Server.createWebServer(stringArray);
            this.web.setShutdownHandler(this);
            try {
                this.web.start();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                n = 1;
            }
            printStream.println(this.web.getStatus());
            if (bl5) {
                StartBrowser.openURL(this.web.getURL());
            }
        }
        if (bl4) {
            this.ftp = Server.createFtpServer(stringArray);
            try {
                this.ftp.start();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                n = 1;
            }
            printStream.println(this.ftp.getStatus());
        }
        return n;
    }

    public static void shutdownTcpServer(String string, String string2, boolean bl) throws SQLException {
        TcpServer.shutdown(string, string2, bl);
    }

    String getStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isRunning(false)) {
            stringBuffer.append(this.service.getType());
            stringBuffer.append(" server running on ");
            stringBuffer.append(this.service.getURL());
            stringBuffer.append(" (");
            if (this.service.getAllowOthers()) {
                stringBuffer.append("others can connect");
            } else {
                stringBuffer.append("only local connections");
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append("Port is in use, maybe another " + this.service.getType() + " server already running on ");
            stringBuffer.append(this.service.getURL());
        }
        return stringBuffer.toString();
    }

    public static Server createWebServer(String[] stringArray) throws SQLException {
        WebServer webServer = new WebServer();
        Server server = new Server(webServer, stringArray);
        webServer.setShutdownHandler(server);
        return server;
    }

    public static Server createFtpServer(String[] stringArray) throws SQLException {
        return new Server(new FtpServer(), stringArray);
    }

    public static Server createTcpServer(String[] stringArray) throws SQLException {
        return new Server(new TcpServer(), stringArray);
    }

    public static Server createPgServer(String[] stringArray) throws SQLException {
        return new Server(new PgServer(), stringArray);
    }

    public Server start() throws SQLException {
        this.service.start();
        Thread thread = new Thread(this);
        thread.setName(this.service.getName() + " (" + this.service.getURL() + ")");
        thread.start();
        for (int i = 1; i < 64; i += i) {
            Server.wait(i);
            if (!this.isRunning(false)) continue;
            return this;
        }
        if (this.isRunning(true)) {
            return this;
        }
        throw Message.getSQLException(90067);
    }

    private static void wait(int n) {
        try {
            long l = (long)n * (long)n;
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void stopAll() {
        if (this.web != null && this.web.isRunning(false)) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning(false)) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning(false)) {
            this.pg.stop();
            this.pg = null;
        }
        if (this.ftp != null && this.ftp.isRunning(false)) {
            this.ftp.stop();
            this.ftp = null;
        }
    }

    public boolean isRunning(boolean bl) {
        return this.service.isRunning(bl);
    }

    public void stop() {
        this.service.stop();
    }

    public String getURL() {
        return this.service.getURL();
    }

    public void run() {
        try {
            this.service.listen();
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    public void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        } else {
            this.stopAll();
        }
    }

    public Service getService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startWebServer(Connection connection) throws SQLException {
        final Object object = new Object();
        WebServer webServer = new WebServer();
        Server server = new Server(webServer, new String[]{"-webPort", "0"});
        webServer.setShutdownHandler(new ShutdownHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void shutdown() {
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
        });
        server.start();
        String string = webServer.addSession(connection);
        StartBrowser.openURL(string);
        Object object2 = object;
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        webServer.stop();
    }
}

