/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.Cache;
import org.h2.util.CacheHead;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;

public class CacheLRU
implements Cache {
    public static final String TYPE_NAME = "LRU";
    private final CacheWriter writer;
    private int len;
    private int maxSize;
    private CacheObject[] values;
    private int mask;
    private int recordCount;
    private int sizeMemory;
    private CacheObject head = new CacheHead();

    public CacheLRU(CacheWriter cacheWriter, int n) {
        this.maxSize = n * 1024 / 4;
        this.writer = cacheWriter;
        this.len = MathUtils.nextPowerOf2(this.maxSize / 64);
        this.mask = this.len - 1;
        MathUtils.checkPowerOf2(this.len);
        this.clear();
    }

    public void clear() {
        this.head.next = this.head.previous = this.head;
        this.values = new CacheObject[this.len];
        this.recordCount = 0;
        this.sizeMemory = 0;
    }

    public void put(CacheObject cacheObject) throws SQLException {
        int n;
        if (SysProperties.CHECK) {
            n = cacheObject.getPos();
            for (int i = 0; i < cacheObject.getBlockCount(); ++i) {
                CacheObject cacheObject2 = this.find(n + i);
                if (cacheObject2 == null) continue;
                throw Message.getInternalError("try to add a record twice pos:" + n + " i:" + i);
            }
        }
        n = cacheObject.getPos() & this.mask;
        cacheObject.chained = this.values[n];
        this.values[n] = cacheObject;
        ++this.recordCount;
        this.sizeMemory += cacheObject.getMemorySize();
        this.addToFront(cacheObject);
        this.removeOldIfRequired();
    }

    public CacheObject update(int n, CacheObject cacheObject) throws SQLException {
        CacheObject cacheObject2 = this.find(n);
        if (cacheObject2 == null) {
            this.put(cacheObject);
        } else {
            if (SysProperties.CHECK && cacheObject2 != cacheObject) {
                throw Message.getInternalError("old != record old=" + cacheObject2 + " new=" + cacheObject);
            }
            this.removeFromLinkedList(cacheObject);
            this.addToFront(cacheObject);
        }
        return cacheObject2;
    }

    private void removeOldIfRequired() throws SQLException {
        if (this.sizeMemory >= this.maxSize) {
            this.removeOld();
        }
    }

    private void removeOld() throws SQLException {
        CacheObject cacheObject;
        int n = 0;
        ObjectArray objectArray = new ObjectArray();
        while (this.sizeMemory * 4 > this.maxSize * 3 && this.recordCount > 16) {
            if (++n == this.recordCount) {
                this.writer.flushLog();
            }
            if (n >= this.recordCount * 2) break;
            cacheObject = this.head.next;
            if (SysProperties.CHECK && cacheObject == this.head) {
                throw Message.getInternalError("try to remove head");
            }
            if (!cacheObject.canRemove()) {
                this.removeFromLinkedList(cacheObject);
                this.addToFront(cacheObject);
                continue;
            }
            this.remove(cacheObject.getPos());
            if (!cacheObject.isChanged()) continue;
            objectArray.add(cacheObject);
        }
        if (objectArray.size() > 0) {
            CacheObject.sort(objectArray);
            for (n = 0; n < objectArray.size(); ++n) {
                cacheObject = (CacheObject)objectArray.get(n);
                this.writer.writeBack(cacheObject);
            }
        }
    }

    private void addToFront(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject == this.head) {
            throw Message.getInternalError("try to move head");
        }
        cacheObject.next = this.head;
        cacheObject.previous = this.head.previous;
        cacheObject.previous.next = cacheObject;
        this.head.previous = cacheObject;
    }

    private void removeFromLinkedList(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject == this.head) {
            throw Message.getInternalError("try to remove head");
        }
        cacheObject.previous.next = cacheObject.next;
        cacheObject.next.previous = cacheObject.previous;
        cacheObject.next = null;
        cacheObject.previous = null;
    }

    public void remove(int n) {
        int n2 = n & this.mask;
        CacheObject cacheObject = this.values[n2];
        if (cacheObject == null) {
            return;
        }
        if (cacheObject.getPos() == n) {
            this.values[n2] = cacheObject.chained;
        } else {
            do {
                CacheObject cacheObject2 = cacheObject;
                cacheObject = cacheObject.chained;
                if (cacheObject != null) continue;
                return;
            } while (cacheObject.getPos() != n);
            cacheObject2.chained = cacheObject.chained;
        }
        --this.recordCount;
        this.sizeMemory -= cacheObject.getMemorySize();
        this.removeFromLinkedList(cacheObject);
        if (SysProperties.CHECK) {
            cacheObject.chained = null;
            if (this.find(n) != null) {
                throw Message.getInternalError("not removed!");
            }
        }
    }

    public CacheObject find(int n) {
        CacheObject cacheObject = this.values[n & this.mask];
        while (cacheObject != null && cacheObject.getPos() != n) {
            cacheObject = cacheObject.chained;
        }
        return cacheObject;
    }

    public CacheObject get(int n) {
        CacheObject cacheObject = this.find(n);
        if (cacheObject != null) {
            this.removeFromLinkedList(cacheObject);
            this.addToFront(cacheObject);
        }
        return cacheObject;
    }

    public ObjectArray getAllChanged() {
        ObjectArray objectArray = new ObjectArray();
        block0: for (int i = 0; i < this.len; ++i) {
            CacheObject cacheObject = this.values[i];
            while (cacheObject != null) {
                if (cacheObject.isChanged()) {
                    objectArray.add(cacheObject);
                    if (objectArray.size() >= this.recordCount) {
                        if (!SysProperties.CHECK) continue block0;
                        if (objectArray.size() > this.recordCount) {
                            throw Message.getInternalError("cache chain error");
                        }
                    }
                }
                cacheObject = cacheObject.chained;
            }
        }
        return objectArray;
    }

    public void setMaxSize(int n) throws SQLException {
        int n2 = n * 1024 / 4;
        this.maxSize = n2 < 0 ? 0 : n2;
        this.removeOldIfRequired();
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getSize() {
        return this.sizeMemory;
    }
}

