/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageScanIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.DataPageBinary;

class PageDataNode
extends PageData {
    int[] childPageIds;

    PageDataNode(PageScanIndex pageScanIndex, int n, int n2, DataPageBinary dataPageBinary) {
        super(pageScanIndex, n, n2, dataPageBinary);
    }

    void read() {
        this.data.setPos(5);
        this.entryCount = this.data.readShortInt();
        this.childPageIds = new int[this.entryCount + 1];
        this.childPageIds[this.entryCount] = this.data.readInt();
        this.keys = new int[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.childPageIds[i] = this.data.readInt();
            this.keys[i] = this.data.readInt();
        }
    }

    void write() throws SQLException {
        this.data.reset();
        this.data.writeInt(this.parentPageId);
        this.data.writeByte((byte)4);
        this.data.writeShortInt(this.entryCount);
        this.data.writeInt(this.childPageIds[this.entryCount]);
        for (int i = 0; i < this.entryCount; ++i) {
            this.data.writeInt(this.childPageIds[i]);
            this.data.writeInt(this.keys[i]);
        }
        this.index.getPageStore().writePage(this.pageId, this.data);
    }

    private void addChild(int n, int n2, int n3) {
        int[] nArray = new int[this.entryCount + 1];
        int[] nArray2 = new int[this.entryCount + 2];
        if (this.entryCount > 0) {
            System.arraycopy(this.keys, 0, nArray, 0, n);
            System.arraycopy(this.childPageIds, 0, nArray2, 0, n + 1);
            if (n < this.entryCount) {
                System.arraycopy(this.keys, n, nArray, n + 1, this.entryCount - n);
                System.arraycopy(this.childPageIds, n, nArray2, n + 1, this.entryCount - n + 1);
            }
        }
        nArray[n] = n3;
        nArray2[n + 1] = n2;
        this.keys = nArray;
        this.childPageIds = nArray2;
        ++this.entryCount;
    }

    int addRow(Row row) throws SQLException {
        int n = this.find(row.getPos());
        PageData pageData = this.index.getPage(this.childPageIds[n]);
        int n2 = pageData.addRow(row);
        if (n2 == 0) {
            return 0;
        }
        int n3 = pageData.getKey(n2);
        PageData pageData2 = pageData.split(n2);
        pageData.write();
        pageData2.write();
        this.addChild(n, pageData2.getPageId(), n3);
        int n4 = (this.index.getPageStore().getPageSize() - 11) / 8;
        if (this.entryCount >= n4) {
            return this.entryCount / 2;
        }
        this.write();
        return 0;
    }

    Cursor find() throws SQLException {
        int n = this.childPageIds[0];
        return this.index.getPage(n).find();
    }

    PageData split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageDataNode pageDataNode = new PageDataNode(this.index, n2, this.parentPageId, this.index.getPageStore().createDataPage());
        int n3 = this.childPageIds[++n];
        int n4 = n;
        while (n4 < this.entryCount) {
            pageDataNode.addChild(pageDataNode.entryCount, this.childPageIds[n + 1], this.keys[n]);
            this.removeChild(n);
        }
        n4 = this.childPageIds[n - 1];
        this.removeChild(n - 1);
        this.childPageIds[n - 1] = n4;
        pageDataNode.childPageIds[0] = n3;
        pageDataNode.remapChildren();
        return pageDataNode;
    }

    protected void remapChildren() throws SQLException {
        for (int i = 0; i < this.childPageIds.length; ++i) {
            int n = this.childPageIds[i];
            PageData pageData = this.index.getPage(n);
            pageData.setParentPageId(this.pageId);
            pageData.write();
        }
    }

    private void removeChild(int n) {
        int[] nArray = new int[this.entryCount - 1];
        int[] nArray2 = new int[this.entryCount];
        System.arraycopy(this.keys, 0, nArray, 0, n);
        System.arraycopy(this.childPageIds, 0, nArray2, 0, n + 1);
        if (n < this.entryCount) {
            System.arraycopy(this.keys, n + 1, nArray, n, this.entryCount - n - 1);
            System.arraycopy(this.childPageIds, n + 1, nArray2, n, this.entryCount - n);
        }
        this.keys = nArray;
        this.childPageIds = nArray2;
        --this.entryCount;
    }

    void init(PageData pageData, int n, PageData pageData2) {
        this.entryCount = 1;
        this.childPageIds = new int[]{pageData.getPageId(), pageData2.getPageId()};
        this.keys = new int[]{n};
    }

    int getLastKey() throws SQLException {
        return this.index.getPage(this.childPageIds[this.entryCount]).getLastKey();
    }

    public PageDataLeaf getNextPage(int n) throws SQLException {
        int n2 = this.find(n) + 1;
        if (n2 > this.entryCount) {
            if (this.parentPageId == 0) {
                return null;
            }
            PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId);
            return pageDataNode.getNextPage(this.keys[this.entryCount - 1]);
        }
        PageData pageData = this.index.getPage(this.childPageIds[n2]);
        return pageData.getFirstLeaf();
    }

    PageDataLeaf getFirstLeaf() throws SQLException {
        int n = this.childPageIds[0];
        return this.index.getPage(n).getFirstLeaf();
    }

    private void removeRow(int n) throws SQLException {
        --this.entryCount;
        if (this.entryCount <= 0) {
            Message.getInternalError();
        }
        int[] nArray = new int[this.entryCount];
        int[] nArray2 = new int[this.entryCount + 1];
        System.arraycopy(this.keys, 0, nArray, 0, n);
        System.arraycopy(this.childPageIds, 0, nArray2, 0, n);
        System.arraycopy(this.keys, n + 1, nArray, n, this.entryCount - n);
        System.arraycopy(this.childPageIds, n + 1, nArray2, n, this.entryCount - n + 1);
        this.keys = nArray;
        this.childPageIds = nArray2;
    }

    boolean remove(int n) throws SQLException {
        int n2 = this.find(n);
        PageData pageData = this.index.getPage(this.childPageIds[n2]);
        boolean bl = pageData.remove(n);
        if (!bl) {
            return false;
        }
        this.index.getPageStore().freePage(pageData.getPageId());
        if (this.entryCount == 0) {
            return true;
        }
        if (n2 == 0) {
            this.removeRow(n2);
        } else {
            this.removeRow(n2 - 1);
        }
        this.write();
        return false;
    }

    Row getRow(Session session, int n) throws SQLException {
        int n2 = this.find(n);
        PageData pageData = this.index.getPage(this.childPageIds[n2]);
        return pageData.getRow(session, n);
    }
}

