/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Locale;
import org.h2.command.Command;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.log.InDoubtTransaction;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.DiskFile;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.ObjectArray;
import org.h2.util.Resources;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int META_TABLE_TYPE_COUNT = 28;
    private final int type;
    private final int indexColumn;
    private MetaIndex index;

    public MetaTable(Schema schema, int n, int n2) throws SQLException {
        super(schema, n, null, true);
        Column[] columnArray;
        this.type = n2;
        String string = null;
        switch (n2) {
            case 0: {
                this.setObjectName("TABLES");
                columnArray = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT"});
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                columnArray = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS"});
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                columnArray = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT"});
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                columnArray = this.createColumns(new String[]{"TYPE"});
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                columnArray = this.createColumns(new String[]{"TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT"});
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                columnArray = this.createColumns(new String[]{"CATALOG_NAME"});
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                columnArray = this.createColumns(new String[]{"NAME", "VALUE"});
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                columnArray = this.createColumns(new String[]{"ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT", "EXAMPLE"});
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                columnArray = this.createColumns(new String[]{"SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "ID INT"});
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                columnArray = this.createColumns(new String[]{"NAME", "ADMIN", "REMARKS", "ID INT"});
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                columnArray = this.createColumns(new String[]{"NAME", "REMARKS", "ID INT"});
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                columnArray = this.createColumns(new String[]{"GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT"});
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                columnArray = this.createColumns(new String[]{"ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT"});
                break;
            }
            case 21: {
                this.setObjectName("FUNCTION_COLUMNS");
                columnArray = this.createColumns(new String[]{"ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS"});
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                columnArray = this.createColumns(new String[]{"CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT"});
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                columnArray = this.createColumns(new String[]{"GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE"});
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                columnArray = this.createColumns(new String[]{"GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE"});
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                columnArray = this.createColumns(new String[]{"NAME", "KEY"});
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                columnArray = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT"});
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                columnArray = this.createColumns(new String[]{"TRANSACTION", "STATE"});
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                columnArray = this.createColumns(new String[]{"PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT"});
                string = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                columnArray = this.createColumns(new String[]{"CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT"});
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setObjectName("CONSTANTS");
                columnArray = this.createColumns(new String[]{"CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT"});
                break;
            }
            case 23: {
                this.setObjectName("DOMAINS");
                columnArray = this.createColumns(new String[]{"DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT"});
                break;
            }
            case 24: {
                this.setObjectName("TRIGGERS");
                columnArray = this.createColumns(new String[]{"TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT"});
                break;
            }
            case 25: {
                this.setObjectName("SESSIONS");
                columnArray = this.createColumns(new String[]{"ID INT", "USER_NAME", "SESSION_START", "STATEMENT", "STATEMENT_START"});
                break;
            }
            case 26: {
                this.setObjectName("LOCKS");
                columnArray = this.createColumns(new String[]{"TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE"});
                break;
            }
            case 27: {
                this.setObjectName("SESSION_STATE");
                columnArray = this.createColumns(new String[]{"KEY", "SQL"});
                break;
            }
            default: {
                throw Message.throwInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
        } else {
            this.indexColumn = this.getColumn(string).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.index = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private Column[] createColumns(String[] stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            String string2 = stringArray[i];
            int n2 = string2.indexOf(32);
            if (n2 < 0) {
                n = 13;
                string = string2;
            } else {
                n = DataType.getTypeByName((String)string2.substring((int)(n2 + 1))).type;
                string = string2.substring(0, n2);
            }
            columnArray[i] = new Column(string, n);
        }
        return columnArray;
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQL() {
        return null;
    }

    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, String string2) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void lock(Session session, boolean bl, boolean bl2) {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String string) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string = string == null ? null : StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private ObjectArray getAllTables(Session session) {
        ObjectArray objectArray = this.database.getAllSchemaObjects(0);
        ObjectArray objectArray2 = session.getLocalTempTables();
        objectArray.addAll(objectArray2);
        return objectArray;
    }

    private boolean checkIndex(Session session, String string, Value value, Value value2) throws SQLException {
        if (string == null || value == null && value2 == null) {
            return true;
        }
        Database database = session.getDatabase();
        ValueString valueString = ValueString.get(string);
        if (value != null && database.compare(valueString, value) < 0) {
            return false;
        }
        return value2 == null || database.compare(valueString, value2) <= 0;
    }

    private String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    public ObjectArray generateRows(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        Value value = null;
        Value value2 = null;
        if (this.indexColumn >= 0) {
            if (searchRow != null) {
                value = searchRow.getValue(this.indexColumn);
            }
            if (searchRow2 != null) {
                value2 = searchRow2.getValue(this.indexColumn);
            }
        }
        ObjectArray objectArray = new ObjectArray();
        String string = this.identifier(this.database.getShortName());
        switch (this.type) {
            case 0: {
                ObjectArray objectArray2 = this.getAllTables(session);
                for (int i = 0; i < objectArray2.size(); ++i) {
                    Table table = (Table)objectArray2.get(i);
                    String string2 = this.identifier(table.getName());
                    if (!this.checkIndex(session, string2, value, value2)) continue;
                    String string3 = table.getTemporary() ? (table.getGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.getPersistent() ? "CACHED" : "MEMORY");
                    this.add(objectArray, new String[]{string, this.identifier(table.getSchema().getName()), string2, table.getTableType(), string3, table.getCreateSQL(), this.replaceNullWithEmpty(table.getComment()), "" + table.getMaxDataModificationId(), "" + table.getId()});
                }
                break;
            }
            case 1: {
                ObjectArray objectArray3 = this.getAllTables(session);
                for (int i = 0; i < objectArray3.size(); ++i) {
                    Table table = (Table)objectArray3.get(i);
                    String string4 = this.identifier(table.getName());
                    if (!this.checkIndex(session, string4, value, value2)) continue;
                    Column[] columnArray = table.getColumns();
                    String string5 = this.database.getCompareMode().getName();
                    for (int j = 0; j < columnArray.length; ++j) {
                        Column column = columnArray[j];
                        Sequence sequence = column.getSequence();
                        this.add(objectArray, new String[]{string, this.identifier(table.getSchema().getName()), string4, this.identifier(column.getName()), String.valueOf(j + 1), column.getDefaultSQL(), column.getNullable() ? "YES" : "NO", "" + DataType.convertTypeToSQLType(column.getType()), "" + column.getPrecisionAsInt(), "" + column.getPrecisionAsInt(), "" + column.getPrecisionAsInt(), "10", "" + column.getScale(), "Unicode", string5, this.identifier(DataType.getDataType((int)column.getType()).name), "" + (column.getNullable() ? 1 : 0), "" + (column.getComputed() ? "TRUE" : "FALSE"), "" + column.getSelectivity(), column.getCheckConstraintSQL(session, column.getName()), sequence == null ? null : sequence.getName(), this.replaceNullWithEmpty(column.getComment())});
                    }
                }
                break;
            }
            case 2: {
                ObjectArray objectArray4 = this.getAllTables(session);
                for (int i = 0; i < objectArray4.size(); ++i) {
                    Table table = (Table)objectArray4.get(i);
                    String string6 = this.identifier(table.getName());
                    if (!this.checkIndex(session, string6, value, value2)) continue;
                    ObjectArray objectArray5 = table.getIndexes();
                    for (int j = 0; objectArray5 != null && j < objectArray5.size(); ++j) {
                        Index index = (Index)objectArray5.get(j);
                        if (index.getCreateSQL() == null) continue;
                        IndexColumn[] indexColumnArray = index.getIndexColumns();
                        for (int k = 0; k < indexColumnArray.length; ++k) {
                            IndexColumn indexColumn = indexColumnArray[k];
                            Column column = indexColumn.column;
                            this.add(objectArray, new String[]{string, this.identifier(table.getSchema().getName()), string6, index.getIndexType().getUnique() ? "FALSE" : "TRUE", this.identifier(index.getName()), "" + (k + 1), this.identifier(column.getName()), "0", index.getIndexType().getPrimaryKey() ? "TRUE" : "FALSE", index.getIndexType().getSQL(), index.getIndexType().getBelongsToConstraint() ? "TRUE" : "FALSE", "3", (indexColumn.sortType & 1) != 0 ? "D" : "A", "0", "", this.replaceNullWithEmpty(index.getComment()), index.getSQL(), "" + index.getId(), "" + indexColumn.sortType});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(objectArray, new String[]{"TABLE"});
                this.add(objectArray, new String[]{"TABLE LINK"});
                this.add(objectArray, new String[]{"SYSTEM TABLE"});
                this.add(objectArray, new String[]{"VIEW"});
                break;
            }
            case 5: {
                this.add(objectArray, new String[]{string});
                break;
            }
            case 6: {
                String string7;
                ObjectArray objectArray6 = this.database.getAllSettings();
                for (int i = 0; i < objectArray6.size(); ++i) {
                    Setting setting = (Setting)objectArray6.get(i);
                    string7 = setting.getStringValue();
                    if (string7 == null) {
                        string7 = "" + setting.getIntValue();
                    }
                    this.add(objectArray, new String[]{this.identifier(setting.getName()), string7});
                }
                this.add(objectArray, new String[]{"info.BUILD_ID", "105"});
                this.add(objectArray, new String[]{"info.VERSION_MAJOR", "1"});
                this.add(objectArray, new String[]{"info.VERSION_MINOR", "1"});
                this.add(objectArray, new String[]{"info.VERSION", "" + Constants.getFullVersion()});
                if (session.getUser().getAdmin()) {
                    String[] stringArray = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    for (int i = 0; i < stringArray.length; ++i) {
                        string7 = stringArray[i];
                        this.add(objectArray, new String[]{"property." + string7, SysProperties.getStringSetting(string7, "")});
                    }
                }
                this.add(objectArray, new String[]{"EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE"});
                this.add(objectArray, new String[]{"MODE", this.database.getMode().getName()});
                this.add(objectArray, new String[]{"MULTI_THREADED", this.database.isMultiThreaded() ? "1" : "0"});
                this.add(objectArray, new String[]{"MVCC", this.database.isMultiVersion() ? "TRUE" : "FALSE"});
                this.add(objectArray, new String[]{"QUERY_TIMEOUT", "" + session.getQueryTimeout()});
                this.add(objectArray, new String[]{"LOB_FILES_IN_DIRECTORIES", "" + this.database.getLobFilesInDirectories()});
                this.add(objectArray, new String[]{"h2.allowBigDecimalExtensions", "" + SysProperties.ALLOW_BIG_DECIMAL_EXTENSIONS});
                this.add(objectArray, new String[]{"h2.baseDir", "" + SysProperties.getBaseDir()});
                this.add(objectArray, new String[]{"h2.check", "" + SysProperties.CHECK});
                this.add(objectArray, new String[]{"h2.check2", "" + SysProperties.CHECK2});
                this.add(objectArray, new String[]{"h2.clientTraceDirectory", SysProperties.CLIENT_TRACE_DIRECTORY});
                this.add(objectArray, new String[]{"h2.collatorCacheSize", "" + SysProperties.getCollatorCacheSize()});
                this.add(objectArray, new String[]{"h2.defaultMaxMemoryUndo", "" + SysProperties.DEFAULT_MAX_MEMORY_UNDO});
                this.add(objectArray, new String[]{"h2.lobFilesInDirectories", "" + SysProperties.LOB_FILES_IN_DIRECTORIES});
                this.add(objectArray, new String[]{"h2.lobFilesPerDirectory", "" + SysProperties.LOB_FILES_PER_DIRECTORY});
                this.add(objectArray, new String[]{"h2.logAllErrors", "" + SysProperties.LOG_ALL_ERRORS});
                this.add(objectArray, new String[]{"h2.logAllErrorsFile", "" + SysProperties.LOG_ALL_ERRORS_FILE});
                this.add(objectArray, new String[]{"h2.maxFileRetry", "" + SysProperties.MAX_FILE_RETRY});
                this.add(objectArray, new String[]{"h2.maxQueryTimeout", "" + SysProperties.getMaxQueryTimeout()});
                this.add(objectArray, new String[]{"h2.lobCloseBetweenReads", "" + SysProperties.lobCloseBetweenReads});
                this.add(objectArray, new String[]{"h2.objectCache", "" + SysProperties.OBJECT_CACHE});
                this.add(objectArray, new String[]{"h2.objectCacheSize", "" + SysProperties.OBJECT_CACHE_SIZE});
                this.add(objectArray, new String[]{"h2.objectCacheMaxPerElementSize", "" + SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE});
                this.add(objectArray, new String[]{"h2.optimizeIn", "" + SysProperties.OPTIMIZE_IN});
                this.add(objectArray, new String[]{"h2.optimizeInJoin", "" + SysProperties.optimizeInJoin});
                this.add(objectArray, new String[]{"h2.optimizeMinMax", "" + SysProperties.OPTIMIZE_MIN_MAX});
                this.add(objectArray, new String[]{"h2.optimizeSubqueryCache", "" + SysProperties.OPTIMIZE_SUBQUERY_CACHE});
                this.add(objectArray, new String[]{"h2.overflowExceptions", "" + SysProperties.OVERFLOW_EXCEPTIONS});
                this.add(objectArray, new String[]{"h2.recompileAlways", "" + SysProperties.RECOMPILE_ALWAYS});
                this.add(objectArray, new String[]{"h2.redoBufferSize", "" + SysProperties.REDO_BUFFER_SIZE});
                this.add(objectArray, new String[]{"h2.runFinalize", "" + SysProperties.runFinalize});
                this.add(objectArray, new String[]{"h2.scriptDirectory", SysProperties.scriptDirectory});
                this.add(objectArray, new String[]{"h2.serverCachedObjects", "" + SysProperties.SERVER_CACHED_OBJECTS});
                this.add(objectArray, new String[]{"h2.serverResultSetFetchSize", "" + SysProperties.SERVER_RESULT_SET_FETCH_SIZE});
                this.add(objectArray, new String[]{"h2.sortNullsHigh", "" + SysProperties.SORT_NULLS_HIGH});
                DiskFile diskFile = this.database.getDataFile();
                if (diskFile == null) break;
                this.add(objectArray, new String[]{"CACHE_TYPE", diskFile.getCache().getTypeName()});
                if (!session.getUser().getAdmin()) break;
                DiskFile diskFile2 = this.database.getIndexFile();
                this.add(objectArray, new String[]{"info.FILE_DISK_WRITE", "" + diskFile.getWriteCount()});
                this.add(objectArray, new String[]{"info.FILE_DISK_READ", "" + diskFile.getReadCount()});
                this.add(objectArray, new String[]{"info.FILE_INDEX_WRITE", "" + this.database.getIndexFile().getWriteCount()});
                this.add(objectArray, new String[]{"info.FILE_INDEX_READ", "" + this.database.getIndexFile().getReadCount()});
                this.add(objectArray, new String[]{"info.CACHE_DATA_MAX_SIZE", "" + diskFile.getCache().getMaxSize()});
                this.add(objectArray, new String[]{"info.CACHE_DATA_SIZE", "" + diskFile.getCache().getSize()});
                this.add(objectArray, new String[]{"info.CACHE_INDEX_MAX_SIZE", "" + diskFile2.getCache().getMaxSize()});
                this.add(objectArray, new String[]{"info.CACHE_INDEX_SIZE", "" + diskFile2.getCache().getSize()});
                break;
            }
            case 4: {
                ObjectArray objectArray7 = DataType.getTypes();
                for (int i = 0; i < objectArray7.size(); ++i) {
                    DataType dataType = (DataType)objectArray7.get(i);
                    if (dataType.hidden || dataType.sqlType == 0) continue;
                    this.add(objectArray, new String[]{dataType.name, String.valueOf(dataType.sqlType), String.valueOf(dataType.maxPrecision), dataType.prefix, dataType.suffix, dataType.params, String.valueOf(dataType.autoIncrement), String.valueOf(dataType.minScale), String.valueOf(dataType.maxScale), dataType.decimal ? "10" : null, String.valueOf(dataType.sqlTypePos), String.valueOf(dataType.caseSensitive), "1", "3"});
                }
                break;
            }
            case 7: {
                String string8 = "/org/h2/res/help.csv";
                try {
                    byte[] byArray = Resources.get(string8);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
                    ResultSet resultSet = Csv.getInstance().read(bufferedReader, null);
                    int n = 0;
                    while (resultSet.next()) {
                        this.add(objectArray, new String[]{String.valueOf(n), resultSet.getString(1).trim(), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim(), resultSet.getString(5).trim()});
                        ++n;
                    }
                    break;
                }
                catch (IOException iOException) {
                    throw Message.convertIOException(iOException, string8);
                }
            }
            case 8: {
                ObjectArray objectArray8 = this.database.getAllSchemaObjects(3);
                for (int i = 0; i < objectArray8.size(); ++i) {
                    Sequence sequence = (Sequence)objectArray8.get(i);
                    this.add(objectArray, new String[]{string, this.identifier(sequence.getSchema().getName()), this.identifier(sequence.getName()), String.valueOf(sequence.getCurrentValue()), String.valueOf(sequence.getIncrement()), sequence.getBelongsToTable() ? "TRUE" : "FALSE", this.replaceNullWithEmpty(sequence.getComment()), String.valueOf(sequence.getCacheSize()), "" + sequence.getId()});
                }
                break;
            }
            case 9: {
                ObjectArray objectArray9 = this.database.getAllUsers();
                for (int i = 0; i < objectArray9.size(); ++i) {
                    User user = (User)objectArray9.get(i);
                    this.add(objectArray, new String[]{this.identifier(user.getName()), String.valueOf(user.getAdmin()), this.replaceNullWithEmpty(user.getComment()), "" + user.getId()});
                }
                break;
            }
            case 10: {
                ObjectArray objectArray10 = this.database.getAllRoles();
                for (int i = 0; i < objectArray10.size(); ++i) {
                    Role role = (Role)objectArray10.get(i);
                    this.add(objectArray, new String[]{this.identifier(role.getName()), this.replaceNullWithEmpty(role.getComment()), "" + role.getId()});
                }
                break;
            }
            case 11: {
                ObjectArray objectArray11 = this.database.getAllRights();
                for (int i = 0; i < objectArray11.size(); ++i) {
                    String string9;
                    Right right = (Right)objectArray11.get(i);
                    Role role = right.getGrantedRole();
                    DbObject dbObject = right.getGrantee();
                    String string10 = string9 = dbObject.getType() == 2 ? "USER" : "ROLE";
                    if (role == null) {
                        Table table = right.getGrantedTable();
                        String string11 = this.identifier(table.getName());
                        if (!this.checkIndex(session, string11, value, value2)) continue;
                        this.add(objectArray, new String[]{this.identifier(dbObject.getName()), string9, "", right.getRights(), this.identifier(table.getSchema().getName()), this.identifier(table.getName()), "" + right.getId()});
                        continue;
                    }
                    this.add(objectArray, new String[]{this.identifier(dbObject.getName()), string9, this.identifier(role.getName()), "", "", "", "" + right.getId()});
                }
                break;
            }
            case 12: {
                int n;
                Object object;
                ObjectArray objectArray12 = this.database.getAllFunctionAliases();
                for (int i = 0; i < objectArray12.size(); ++i) {
                    FunctionAlias functionAlias = (FunctionAlias)objectArray12.get(i);
                    object = functionAlias.getJavaMethods();
                    for (n = 0; n < ((FunctionAlias.JavaMethod[])object).length; ++n) {
                        FunctionAlias.JavaMethod javaMethod = object[n];
                        int n2 = javaMethod.getDataType() == 0 ? 1 : 2;
                        this.add(objectArray, new String[]{string, "PUBLIC", this.identifier(functionAlias.getName()), functionAlias.getJavaClassName(), functionAlias.getJavaMethodName(), "" + DataType.convertTypeToSQLType(javaMethod.getDataType()), "" + javaMethod.getColumnClasses().length, "" + n2, this.replaceNullWithEmpty(functionAlias.getComment()), "" + functionAlias.getId()});
                    }
                }
                ObjectArray objectArray13 = this.database.getAllAggregates();
                for (int i = 0; i < objectArray13.size(); ++i) {
                    object = (UserAggregate)objectArray13.get(i);
                    n = 2;
                    this.add(objectArray, new String[]{string, "PUBLIC", this.identifier(((DbObjectBase)object).getName()), ((UserAggregate)object).getJavaClassName(), "", "" + DataType.convertTypeToSQLType(0), "1", "" + n, this.replaceNullWithEmpty(((DbObjectBase)object).getComment()), "" + ((DbObjectBase)object).getId()});
                }
                break;
            }
            case 21: {
                ObjectArray objectArray14 = this.database.getAllFunctionAliases();
                for (int i = 0; i < objectArray14.size(); ++i) {
                    FunctionAlias functionAlias = (FunctionAlias)objectArray14.get(i);
                    FunctionAlias.JavaMethod[] javaMethodArray = functionAlias.getJavaMethods();
                    for (int j = 0; j < javaMethodArray.length; ++j) {
                        FunctionAlias.JavaMethod javaMethod = javaMethodArray[j];
                        Class[] classArray = javaMethod.getColumnClasses();
                        for (int k = 0; k < classArray.length; ++k) {
                            Class clazz = classArray[k];
                            int n = DataType.getTypeFromClass(clazz);
                            DataType dataType = DataType.getDataType(n);
                            int n3 = clazz.isPrimitive() ? 0 : 1;
                            this.add(objectArray, new String[]{string, "PUBLIC", this.identifier(functionAlias.getName()), functionAlias.getJavaClassName(), functionAlias.getJavaMethodName(), "" + javaMethod.getParameterCount(), "" + k, "P" + (k + 1), "" + DataType.convertTypeToSQLType(dataType.type), dataType.name, "" + dataType.defaultPrecision, "" + dataType.defaultScale, "10", "" + n3, "1", ""});
                        }
                    }
                }
                break;
            }
            case 13: {
                ObjectArray objectArray15 = this.database.getAllSchemas();
                String string12 = this.database.getCompareMode().getName();
                for (int i = 0; i < objectArray15.size(); ++i) {
                    Schema schema = (Schema)objectArray15.get(i);
                    this.add(objectArray, new String[]{string, this.identifier(schema.getName()), this.identifier(schema.getOwner().getName()), "Unicode", string12, "PUBLIC".equals(schema.getName()) ? "TRUE" : "FALSE", this.replaceNullWithEmpty(schema.getComment()), "" + schema.getId()});
                }
                break;
            }
            case 14: {
                ObjectArray objectArray16 = this.database.getAllRights();
                for (int i = 0; i < objectArray16.size(); ++i) {
                    String string13;
                    Right right = (Right)objectArray16.get(i);
                    Table table = right.getGrantedTable();
                    if (table == null || !this.checkIndex(session, string13 = this.identifier(table.getName()), value, value2)) continue;
                    this.addPrivileges(objectArray, right.getGrantee(), string, table, null, right.getRightMask());
                }
                break;
            }
            case 15: {
                ObjectArray objectArray17 = this.database.getAllRights();
                for (int i = 0; i < objectArray17.size(); ++i) {
                    String string14;
                    Right right = (Right)objectArray17.get(i);
                    Table table = right.getGrantedTable();
                    if (table == null || !this.checkIndex(session, string14 = this.identifier(table.getName()), value, value2)) continue;
                    DbObject dbObject = right.getGrantee();
                    int n = right.getRightMask();
                    Column[] columnArray = table.getColumns();
                    for (int j = 0; j < columnArray.length; ++j) {
                        String string15 = columnArray[j].getName();
                        this.addPrivileges(objectArray, dbObject, string, table, string15, n);
                    }
                }
                break;
            }
            case 16: {
                Locale[] localeArray = Collator.getAvailableLocales();
                for (int i = 0; i < localeArray.length; ++i) {
                    Locale locale = localeArray[i];
                    this.add(objectArray, new String[]{CompareMode.getName(locale), locale.toString()});
                }
                break;
            }
            case 17: {
                ObjectArray objectArray18 = this.getAllTables(session);
                for (int i = 0; i < objectArray18.size(); ++i) {
                    String string16;
                    Table table = (Table)objectArray18.get(i);
                    if (!table.getTableType().equals("VIEW") || !this.checkIndex(session, string16 = this.identifier(table.getName()), value, value2)) continue;
                    TableView tableView = (TableView)table;
                    this.add(objectArray, new String[]{string, this.identifier(table.getSchema().getName()), string16, table.getCreateSQL(), "NONE", "NO", tableView.getInvalid() ? "INVALID" : "VALID", this.replaceNullWithEmpty(tableView.getComment()), "" + tableView.getId()});
                }
                break;
            }
            case 18: {
                ObjectArray objectArray19 = this.database.getLog().getInDoubtTransactions();
                for (int i = 0; objectArray19 != null && i < objectArray19.size(); ++i) {
                    InDoubtTransaction inDoubtTransaction = (InDoubtTransaction)objectArray19.get(i);
                    this.add(objectArray, new String[]{inDoubtTransaction.getTransaction(), inDoubtTransaction.getState()});
                }
                break;
            }
            case 19: {
                ObjectArray objectArray20 = this.database.getAllSchemaObjects(5);
                for (int i = 0; i < objectArray20.size(); ++i) {
                    Constraint constraint = (Constraint)objectArray20.get(i);
                    if (!constraint.getConstraintType().equals("REFERENTIAL")) continue;
                    ConstraintReferential constraintReferential = (ConstraintReferential)constraint;
                    IndexColumn[] indexColumnArray = constraintReferential.getColumns();
                    IndexColumn[] indexColumnArray2 = constraintReferential.getRefColumns();
                    Table table = constraintReferential.getTable();
                    Table table2 = constraintReferential.getRefTable();
                    String string17 = this.identifier(table2.getName());
                    if (!this.checkIndex(session, string17, value, value2)) continue;
                    int n = this.getRefAction(constraintReferential.getUpdateAction());
                    int n4 = this.getRefAction(constraintReferential.getDeleteAction());
                    for (int j = 0; j < indexColumnArray.length; ++j) {
                        this.add(objectArray, new String[]{string, this.identifier(table2.getSchema().getName()), this.identifier(table2.getName()), this.identifier(indexColumnArray2[j].column.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(indexColumnArray[j].column.getName()), String.valueOf(j + 1), String.valueOf(n), String.valueOf(n4), this.identifier(constraintReferential.getName()), null, "7"});
                    }
                }
                break;
            }
            case 20: {
                ObjectArray objectArray21 = this.database.getAllSchemaObjects(5);
                for (int i = 0; i < objectArray21.size(); ++i) {
                    String string18;
                    Constraint constraint = (Constraint)objectArray21.get(i);
                    String string19 = constraint.getConstraintType();
                    String string20 = null;
                    IndexColumn[] indexColumnArray = null;
                    Table table = constraint.getTable();
                    Index index = constraint.getUniqueIndex();
                    String string21 = null;
                    if (index != null) {
                        string21 = index.getName();
                    }
                    if (!this.checkIndex(session, string18 = this.identifier(table.getName()), value, value2)) continue;
                    if (string19.equals("CHECK")) {
                        string20 = ((ConstraintCheck)constraint).getExpression().getSQL();
                    } else if (string19.equals("UNIQUE") || string19.equals("PRIMARY KEY")) {
                        indexColumnArray = ((ConstraintUnique)constraint).getColumns();
                    } else if (string19.equals("REFERENTIAL")) {
                        indexColumnArray = ((ConstraintReferential)constraint).getColumns();
                    }
                    String string22 = null;
                    if (indexColumnArray != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int j = 0; j < indexColumnArray.length; ++j) {
                            if (j > 0) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append(indexColumnArray[j].column.getName());
                        }
                        string22 = stringBuffer.toString();
                    }
                    this.add(objectArray, new String[]{string, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), string19, string, this.identifier(table.getSchema().getName()), string18, string21, string20, string22, this.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), "" + constraint.getId()});
                }
                break;
            }
            case 22: {
                ObjectArray objectArray22 = this.database.getAllSchemaObjects(11);
                for (int i = 0; i < objectArray22.size(); ++i) {
                    Constant constant = (Constant)objectArray22.get(i);
                    ValueExpression valueExpression = constant.getValue();
                    this.add(objectArray, new String[]{string, this.identifier(constant.getSchema().getName()), this.identifier(constant.getName()), "" + DataType.convertTypeToSQLType(valueExpression.getType()), this.replaceNullWithEmpty(constant.getComment()), valueExpression.getSQL(), "" + constant.getId()});
                }
                break;
            }
            case 23: {
                ObjectArray objectArray23 = this.database.getAllUserDataTypes();
                for (int i = 0; i < objectArray23.size(); ++i) {
                    UserDataType userDataType = (UserDataType)objectArray23.get(i);
                    Column column = userDataType.getColumn();
                    this.add(objectArray, new String[]{string, "PUBLIC", this.identifier(userDataType.getName()), column.getDefaultSQL(), column.getNullable() ? "YES" : "NO", "" + column.getDataType().sqlType, "" + column.getPrecisionAsInt(), "" + column.getScale(), column.getDataType().name, "" + column.getSelectivity(), "" + column.getCheckConstraintSQL(session, "VALUE"), this.replaceNullWithEmpty(userDataType.getComment()), "" + userDataType.getCreateSQL(), "" + userDataType.getId()});
                }
                break;
            }
            case 24: {
                ObjectArray objectArray24 = this.database.getAllSchemaObjects(4);
                for (int i = 0; i < objectArray24.size(); ++i) {
                    TriggerObject triggerObject = (TriggerObject)objectArray24.get(i);
                    Table table = triggerObject.getTable();
                    this.add(objectArray, new String[]{string, this.identifier(triggerObject.getSchema().getName()), this.identifier(triggerObject.getName()), triggerObject.getTypeNameList(), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), "" + triggerObject.getBefore(), triggerObject.getTriggerClassName(), "" + triggerObject.getQueueSize(), "" + triggerObject.getNoWait(), this.replaceNullWithEmpty(triggerObject.getComment()), triggerObject.getCreateSQL(), "" + triggerObject.getId()});
                }
                break;
            }
            case 25: {
                Session[] sessionArray = this.database.getSessions(false);
                boolean bl = session.getUser().getAdmin();
                for (int i = 0; i < sessionArray.length; ++i) {
                    Session session2 = sessionArray[i];
                    if (!bl && session2 != session) continue;
                    Command command = session2.getCurrentCommand();
                    this.add(objectArray, new String[]{"" + session2.getId(), session2.getUser().getName(), new Timestamp(session2.getSessionStart()).toString(), command == null ? null : command.toString(), new Timestamp(session2.getCurrentCommandStart()).toString()});
                }
                break;
            }
            case 26: {
                Session[] sessionArray = this.database.getSessions(false);
                boolean bl = session.getUser().getAdmin();
                for (int i = 0; i < sessionArray.length; ++i) {
                    Session session3 = sessionArray[i];
                    if (!bl && session3 != session) continue;
                    Table[] tableArray = session3.getLocks();
                    for (int j = 0; j < tableArray.length; ++j) {
                        Table table = tableArray[j];
                        this.add(objectArray, new String[]{table.getSchema().getName(), table.getName(), "" + session3.getId(), table.isLockedExclusivelyBy(session3) ? "WRITE" : "READ"});
                    }
                }
                break;
            }
            case 27: {
                Object object;
                String[] stringArray = session.getVariableNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string23 = stringArray[i];
                    object = session.getVariable(string23);
                    this.add(objectArray, new String[]{"@" + string23, "SET @" + string23 + " " + ((Value)object).getSQL()});
                }
                ObjectArray objectArray25 = session.getLocalTempTables();
                for (int i = 0; i < objectArray25.size(); ++i) {
                    object = (Table)objectArray25.get(i);
                    this.add(objectArray, new String[]{"TABLE " + ((DbObjectBase)object).getName(), ((DbObjectBase)object).getCreateSQL()});
                }
                String[] stringArray2 = session.getSchemaSearchPath();
                if (stringArray2 != null && stringArray2.length > 0) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("SET SCHEMA_SEARCH_PATH ");
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (i > 0) {
                            ((StringBuffer)object).append(", ");
                        }
                        ((StringBuffer)object).append(StringUtils.quoteIdentifier(stringArray2[i]));
                    }
                    this.add(objectArray, new String[]{"SCHEMA_SEARCH_PATH", ((StringBuffer)object).toString()});
                }
                if ((object = session.getCurrentSchemaName()) == null) break;
                this.add(objectArray, new String[]{"SCHEMA", "SET SCHEMA " + StringUtils.quoteIdentifier((String)object)});
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.type);
            }
        }
        return objectArray;
    }

    private int getRefAction(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw Message.throwInternalError("action=" + n);
    }

    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void close(Session session) {
    }

    public void unlock(Session session) {
    }

    private void addPrivileges(ObjectArray objectArray, DbObject dbObject, String string, Table table, String string2, int n) throws SQLException {
        if ((n & 1) != 0) {
            this.addPrivilege(objectArray, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(objectArray, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(objectArray, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(objectArray, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(ObjectArray objectArray, DbObject dbObject, String string, Table table, String string2, String string3) throws SQLException {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).getAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(objectArray, new String[]{null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), string3, string4});
        } else {
            this.add(objectArray, new String[]{null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(string2), string3, string4});
        }
    }

    private void add(ObjectArray objectArray, String[] stringArray) throws SQLException {
        Value[] valueArray = new Value[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            Column column = this.columns[i];
            valueArray[i] = value = value.convertTo(column.getType());
        }
        Row row = new Row(valueArray, 0);
        row.setPos(objectArray.size());
        objectArray.add(row);
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public long getRowCount(Session session) {
        throw Message.throwInternalError();
    }

    public boolean canGetRowCount() {
        return false;
    }

    public boolean canDrop() {
        return false;
    }

    public String getTableType() {
        return "SYSTEM TABLE";
    }

    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    public ObjectArray getIndexes() {
        if (this.index == null) {
            return null;
        }
        ObjectArray objectArray = new ObjectArray();
        objectArray.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        objectArray.add(this.index);
        return objectArray;
    }

    public long getMaxDataModificationId() {
        return this.database.getModificationDataId();
    }

    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 28;
    }

    public long getRowCountApproximation() {
        return 1000L;
    }
}

