/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;
import org.h2.server.web.WebThread;
import org.h2.util.StringUtils;

public class WebServlet
extends HttpServlet {
    private static final long serialVersionUID = 9171446624885086692L;
    private transient WebServer server;

    public void init() throws ServletException {
        Object object;
        ServletConfig servletConfig = this.getServletConfig();
        Enumeration enumeration = servletConfig.getInitParameterNames();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement().toString();
            String string = servletConfig.getInitParameter((String)object);
            if (!object.startsWith("-")) {
                object = "-" + (String)object;
            }
            arrayList.add(object);
            if (string.length() <= 0) continue;
            arrayList.add(string);
        }
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        this.server = new WebServer();
        this.server.init((String[])object);
    }

    public void destroy() {
        this.server.stop();
    }

    private boolean allow(HttpServletRequest httpServletRequest) {
        if (this.server.getAllowOthers()) {
            return true;
        }
        String string = httpServletRequest.getRemoteAddr();
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.isLoopbackAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    private String getAllowedFile(HttpServletRequest httpServletRequest, String string) {
        if (!this.allow(httpServletRequest)) {
            return "notAllowed.jsp";
        }
        if (string.length() == 0) {
            return "index.do";
        }
        return string;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string;
        String string2;
        Object object;
        httpServletRequest.setCharacterEncoding("utf-8");
        String string3 = httpServletRequest.getPathInfo();
        if (string3 == null) {
            httpServletResponse.sendRedirect(httpServletRequest.getRequestURI() + "/");
            return;
        }
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        string3 = this.getAllowedFile(httpServletRequest, string3);
        byte[] byArray = null;
        Properties properties = new Properties();
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement().toString();
            string2 = httpServletRequest.getAttribute((String)object).toString();
            properties.put(object, string2);
        }
        enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement().toString();
            string2 = httpServletRequest.getParameter((String)object);
            properties.put(object, string2);
        }
        object = null;
        string2 = properties.getProperty("jsessionid");
        if (string2 != null) {
            object = this.server.getSession(string2);
        }
        WebThread webThread = new WebThread(null, this.server);
        webThread.setSession((WebSession)object, properties);
        String string4 = httpServletRequest.getHeader("if-modified-since");
        String string5 = httpServletRequest.getRemoteAddr();
        string3 = webThread.processRequest(string3, string5);
        object = webThread.getSession();
        String string6 = webThread.getMimeType();
        boolean bl = webThread.getCache();
        if (bl && this.server.getStartDateTime().equals(string4)) {
            httpServletResponse.setStatus(304);
            return;
        }
        byArray = this.server.getFile(string3);
        if (byArray == null) {
            httpServletResponse.sendError(404);
            try {
                byArray = StringUtils.utf8Encode("File not found: " + string3);
            }
            catch (SQLException sQLException) {
                this.server.traceError(sQLException);
            }
        } else {
            if (object != null && string3.endsWith(".jsp")) {
                string = StringUtils.utf8Decode(byArray);
                string = PageParser.parse(string, ((WebSession)object).map);
                try {
                    byArray = StringUtils.utf8Encode(string);
                }
                catch (SQLException sQLException) {
                    this.server.traceError(sQLException);
                }
            }
            httpServletResponse.setContentType(string6);
            if (!bl) {
                httpServletResponse.setHeader("Cache-Control", "no-cache");
            } else {
                httpServletResponse.setHeader("Cache-Control", "max-age=10");
                httpServletResponse.setHeader("Last-Modified", this.server.getStartDateTime());
            }
        }
        if (byArray != null) {
            string = httpServletResponse.getOutputStream();
            string.write(byArray);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

