/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.h2.command.Parser;
import org.h2.constant.SysProperties;
import org.h2.engine.MetaRecord;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.PageLog;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.util.RandomUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.TempFileDeleter;
import org.h2.util.Tool;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class Recover
extends Tool
implements DataHandler {
    private String databaseName;
    private int block;
    private int blockCount;
    private int storageId;
    private int recordLength;
    private int valueId;
    private boolean trace;
    private boolean lobFilesInDirectories;
    private ObjectArray schema;
    private HashSet objectIdSet;
    private HashMap tableMap;
    private boolean remove;

    private void showUsage() {
        this.out.println("Helps recovering a corrupted database.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-dir <dir>]      The directory (default: .)\n" + " [-db <database>]  The database name\n" + " [-trace]          Print additional trace information");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        new Recover().run(stringArray);
    }

    public void run(String[] stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if ("-dir".equals(string3)) {
                string = stringArray[++i];
                continue;
            }
            if ("-db".equals(string3)) {
                string2 = stringArray[++i];
                continue;
            }
            if ("-removePassword".equals(string3)) {
                this.remove = true;
                continue;
            }
            if ("-trace".equals(string3)) {
                this.trace = true;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + string3);
            this.showUsage();
            return;
        }
        if (!SysProperties.PAGE_STORE && this.remove) {
            this.removePassword(string, string2);
        } else {
            this.process(string, string2);
        }
    }

    public static Reader readClob(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(Recover.readBlob(string)));
    }

    public static InputStream readBlob(String string) throws IOException {
        return new BufferedInputStream(new FileInputStream(string));
    }

    private void removePassword(String string, String string2) throws SQLException {
        ArrayList arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (!string3.endsWith(".data.db")) continue;
            this.removePassword(string3);
        }
    }

    private void trace(String string) {
        if (this.trace) {
            this.out.println(string);
        }
    }

    private void traceError(String string, Throwable throwable) {
        this.out.println(string + ": " + throwable.toString());
        if (this.trace) {
            throwable.printStackTrace(this.out);
        }
    }

    private void removePassword(String string) throws SQLException {
        if (string.endsWith(".h2.db")) {
            this.remove = true;
            this.dumpPageStore(string);
            return;
        }
        this.setDatabaseName(string.substring(string.length() - ".data.db".length()));
        FileStore fileStore = FileStore.open(null, string, "rw");
        long l = fileStore.length();
        int n = 48;
        int n2 = 128;
        int n3 = (int)(l / (long)n2);
        this.blockCount = 1;
        for (int i = 0; i < n3; i += this.blockCount) {
            Value[] valueArray;
            fileStore.seek((long)n + (long)i * (long)n2);
            byte[] byArray = new byte[n2];
            DataPage dataPage = DataPage.create((DataHandler)this, byArray);
            long l2 = fileStore.getFilePointer();
            fileStore.readFully(byArray, 0, n2);
            this.blockCount = dataPage.readInt();
            this.storageId = -1;
            this.recordLength = -1;
            this.valueId = -1;
            if (this.blockCount == 0) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount < 0) {
                this.blockCount = 1;
                continue;
            }
            try {
                dataPage.checkCapacity(this.blockCount * n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount > 1) {
                fileStore.readFully(dataPage.getBytes(), n2, this.blockCount * n2 - n2);
            }
            try {
                dataPage.check(this.blockCount * n2);
            }
            catch (SQLException sQLException) {
                this.blockCount = 1;
                continue;
            }
            this.storageId = dataPage.readInt();
            if (this.storageId != 0) continue;
            this.recordLength = dataPage.readInt();
            if (this.recordLength <= 0) continue;
            try {
                valueArray = new Value[this.recordLength];
            }
            catch (Throwable throwable) {
                continue;
            }
            this.valueId = 0;
            while (this.valueId < this.recordLength) {
                try {
                    valueArray[this.valueId] = dataPage.readValue();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++this.valueId;
            }
            if (this.storageId != 0) continue;
            try {
                int n4;
                String string2 = valueArray[3].getString();
                if (!string2.startsWith("CREATE USER ") || (n4 = string2.indexOf("SALT")) < 0) continue;
                String string3 = string2.substring("CREATE USER ".length(), n4 - 1);
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                SHA256 sHA256 = new SHA256();
                byte[] byArray2 = sHA256.getKeyPasswordHash(string3, "".toCharArray());
                byte[] byArray3 = RandomUtils.getSecureBytes(8);
                byte[] byArray4 = sHA256.getHashWithSalt(byArray2, byArray3);
                boolean bl = string2.indexOf("ADMIN") >= 0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("CREATE USER ");
                stringBuffer.append(Parser.quoteIdentifier(string3));
                stringBuffer.append(" SALT '");
                stringBuffer.append(ByteUtils.convertBytesToString(byArray3));
                stringBuffer.append("' HASH '");
                stringBuffer.append(ByteUtils.convertBytesToString(byArray4));
                stringBuffer.append("'");
                if (bl) {
                    stringBuffer.append(" ADMIN");
                }
                byte[] byArray5 = stringBuffer.toString().getBytes();
                int n5 = ByteUtils.indexOf(dataPage.getBytes(), "CREATE USER ".getBytes(), 0);
                System.arraycopy(byArray5, 0, dataPage.getBytes(), n5, byArray5.length);
                dataPage.fill(this.blockCount * n2);
                dataPage.updateChecksum();
                fileStore.seek(l2);
                fileStore.write(dataPage.getBytes(), 0, dataPage.length());
                if (!this.trace) break;
                this.out.println("User: " + string3);
                break;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.out);
            }
        }
        this.closeSilently(fileStore);
    }

    public static void execute(String string, String string2) throws SQLException {
        new Recover().process(string, string2);
    }

    private void process(String string, String string2) throws SQLException {
        ArrayList arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (string3.endsWith(".data.db")) {
                this.dumpData(string3);
                continue;
            }
            if (string3.endsWith(".h2.db")) {
                this.dumpPageStore(string3);
                continue;
            }
            if (string3.endsWith(".index.db")) {
                this.dumpIndex(string3);
                continue;
            }
            if (string3.endsWith(".log.db")) {
                this.dumpLog(string3);
                continue;
            }
            if (!string3.endsWith(".lob.db")) continue;
            this.dumpLob(string3, true);
            this.dumpLob(string3, false);
        }
    }

    private PrintWriter getWriter(String string, String string2) throws SQLException {
        string = string.substring(0, string.length() - 3);
        String string3 = string + string2;
        this.trace("Created file: " + string3);
        return new PrintWriter(IOUtils.getWriter(FileUtils.openFileOutputStream(string3, false)));
    }

    private void writeDataError(PrintWriter printWriter, String string, byte[] byArray, int n) {
        int n2;
        int n3;
        printWriter.println("-- ERROR: " + string + " block:" + this.block + " blockCount:" + this.blockCount + " storageId:" + this.storageId + " recordLength:" + this.recordLength + " valueId:" + this.valueId);
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n * 128; ++n3) {
            n2 = byArray[n3] & 0xFF;
            if (n2 >= 32 && n2 < 128) {
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append('?');
        }
        printWriter.println("-- dump: " + stringBuffer.toString());
        stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n * 128; ++n3) {
            n2 = byArray[n3] & 0xFF;
            stringBuffer.append(' ');
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n2));
        }
        printWriter.println("-- dump: " + stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLob(String string, boolean bl) {
        OutputStream outputStream = null;
        FileStore fileStore = null;
        int n = 0;
        String string2 = string + (bl ? ".comp" : "") + ".txt";
        BufferedInputStream bufferedInputStream = null;
        try {
            int n2;
            outputStream = FileUtils.openFileOutputStream(string2, false);
            fileStore = FileStore.open(null, string, "r");
            fileStore.init();
            bufferedInputStream = new BufferedInputStream(new FileStoreInputStream(fileStore, this, bl, false));
            byte[] byArray = new byte[4096];
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
                n += n2;
            }
            outputStream.close();
        }
        catch (Throwable throwable) {
            try {
                if (this.trace) {
                    this.traceError(string, throwable);
                }
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.closeSilently(outputStream);
                IOUtils.closeSilently(bufferedInputStream);
                this.closeSilently(fileStore);
            }
        }
        IOUtils.closeSilently(outputStream);
        IOUtils.closeSilently(bufferedInputStream);
        this.closeSilently(fileStore);
        if (n == 0) {
            try {
                FileUtils.delete(string2);
            }
            catch (SQLException sQLException) {
                this.traceError(string2, sQLException);
            }
        }
    }

    private void writeLogRecord(PrintWriter printWriter, DataPage dataPage) {
        this.recordLength = dataPage.readInt();
        if (this.recordLength <= 0) {
            this.writeDataError(printWriter, "recordLength<0", dataPage.getBytes(), this.blockCount);
            return;
        }
        try {
            Value[] valueArray = new Value[this.recordLength];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("//     data: ");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                Value value;
                valueArray[this.valueId] = value = dataPage.readValue();
                if (this.valueId > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getSQL(value));
            }
            catch (Exception exception) {
                if (this.trace) {
                    this.traceError("log data", exception);
                }
                this.writeDataError(printWriter, "exception " + exception, dataPage.getBytes(), this.blockCount);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            }
            ++this.valueId;
        }
        printWriter.println(stringBuffer.toString());
        printWriter.flush();
    }

    private String getSQL(Value value) {
        ValueLob valueLob;
        byte[] byArray;
        if (value instanceof ValueLob && (byArray = (valueLob = (ValueLob)value).getSmall()) == null) {
            String string = valueLob.getFileName();
            if (valueLob.getType() == 15) {
                return "READ_BLOB('" + string + ".txt')";
            }
            return "READ_CLOB('" + string + ".txt')";
        }
        return value.getSQL();
    }

    private void setDatabaseName(String string) {
        this.databaseName = string;
        this.lobFilesInDirectories = FileUtils.exists(this.databaseName + ".lobs.db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLog(String string) {
        block22: {
            int n;
            DataPage dataPage;
            byte[] byArray;
            int n2;
            int n3;
            int n4;
            long l;
            FileStore fileStore;
            PrintWriter printWriter;
            block21: {
                printWriter = null;
                fileStore = null;
                this.setDatabaseName(string.substring(string.length() - ".log.db".length()));
                printWriter = this.getWriter(string, ".txt");
                fileStore = FileStore.open(null, string, "r");
                l = fileStore.length();
                printWriter.println("// length: " + l);
                n4 = 48;
                n3 = 16;
                n2 = (int)(l / (long)n3);
                byArray = new byte[n3];
                dataPage = DataPage.create((DataHandler)this, byArray);
                dataPage.fill(3 * n3);
                n = dataPage.length();
                dataPage.reset();
                if (l >= (long)(48 + n)) break block21;
                printWriter.println("// empty file");
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
                return;
            }
            try {
                int n5;
                fileStore.seek(n4);
                fileStore.readFully(dataPage.getBytes(), 0, n);
                int n6 = dataPage.readInt();
                int n7 = dataPage.readInt();
                int n8 = dataPage.readInt();
                printWriter.println("// id:" + n6);
                printWriter.println("// firstUncommittedPos:" + n7);
                printWriter.println("// firstUnwrittenPos:" + n8);
                int n9 = (int)(l / (long)n3);
                printWriter.println("// max:" + n9);
                block14: while ((long)(n5 = (int)(fileStore.getFilePointer() / (long)n3)) * (long)n3 < l) {
                    byArray = new byte[n3];
                    fileStore.readFully(byArray, 0, n3);
                    dataPage = DataPage.create((DataHandler)this, byArray);
                    n2 = MathUtils.convertLongToInt(Math.abs(dataPage.readInt()));
                    if (n2 > 1) {
                        byte[] byArray2 = ByteUtils.newBytes(n2 * n3);
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        byArray = byArray2;
                        try {
                            fileStore.readFully(byArray, n3, n2 * n3 - n3);
                        }
                        catch (SQLException sQLException) {
                            break;
                        }
                        dataPage = DataPage.create((DataHandler)this, byArray);
                        dataPage.check(n2 * n3);
                    }
                    dataPage.reset();
                    n2 = MathUtils.convertLongToInt(Math.abs(dataPage.readInt()));
                    if (n2 == 0) {
                        printWriter.println("// [" + n5 + "] blocks: " + n2 + " (end)");
                        break;
                    }
                    char c = (char)dataPage.readByte();
                    int n10 = dataPage.readInt();
                    if (c == 'P') {
                        String string2 = dataPage.readString();
                        printWriter.println("//   prepared session:" + n10 + " tx:" + string2);
                        continue;
                    }
                    if (c == 'C') {
                        printWriter.println("//   commit session:" + n10);
                        continue;
                    }
                    int n11 = dataPage.readInt();
                    int n12 = dataPage.readInt();
                    int n13 = dataPage.readInt();
                    if (c != 'T') {
                        dataPage.readDataPageNoSize();
                    }
                    switch (c) {
                        case 'S': {
                            char c2 = (char)dataPage.readByte();
                            int n14 = dataPage.readInt();
                            byte[] byArray3 = ByteUtils.newBytes(n14);
                            if (n14 > 0) {
                                dataPage.read(byArray3, 0, n14);
                            }
                            printWriter.println("//   summary session:" + n10 + " fileType:" + c2 + " sumLength:" + n14);
                            this.dumpSummary(printWriter, byArray3);
                            continue block14;
                        }
                        case 'T': {
                            printWriter.println("//   truncate session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                            continue block14;
                        }
                        case 'I': {
                            printWriter.println("//   insert session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                            if (n11 < 0) continue block14;
                            this.writeLogRecord(printWriter, dataPage);
                            continue block14;
                        }
                        case 'D': {
                            printWriter.println("//   delete session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                            if (n11 < 0) continue block14;
                            this.writeLogRecord(printWriter, dataPage);
                            continue block14;
                        }
                    }
                    printWriter.println("//   type?:" + c + " session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                }
                printWriter.close();
            }
            catch (Throwable throwable) {
                try {
                    this.writeError(printWriter, throwable);
                    break block22;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    IOUtils.closeSilently(printWriter);
                    this.closeSilently(fileStore);
                }
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(fileStore);
        }
    }

    private void dumpSummary(PrintWriter printWriter, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            printWriter.println("//     summary is empty");
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n4 = dataInputStream.readInt();
            for (n3 = 0; n3 < n4 / 8; ++n3) {
                n2 = dataInputStream.read();
                if (n3 % 8 == 0) {
                    printWriter.print("//  ");
                }
                printWriter.print(" " + Long.toString(n3 * 8) + ":");
                for (n = 0; n < 8; ++n) {
                    printWriter.print((n2 & 1) == 1 ? "1" : "0");
                    n2 >>>= 1;
                }
                if (n3 % 8 != 7) continue;
                printWriter.println("");
            }
            printWriter.println("//");
            n3 = dataInputStream.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readInt();
                if (n == -1) continue;
                printWriter.println("//     pos:" + n2 * 64 + " storage:" + n);
            }
            while ((n2 = dataInputStream.readInt()) >= 0) {
                n = dataInputStream.readInt();
                printWriter.println("//     storage:" + n2 + " recordCount:" + n);
            }
        }
        catch (Throwable throwable) {
            this.writeError(printWriter, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpIndex(String string) {
        PrintWriter printWriter = null;
        FileStore fileStore = null;
        try {
            this.setDatabaseName(string.substring(string.length() - ".index.db".length()));
            printWriter = this.getWriter(string, ".txt");
            fileStore = FileStore.open(null, string, "r");
            long l = fileStore.length();
            int n = 48;
            int n2 = 128;
            int n3 = (int)(l / (long)n2);
            this.blockCount = 1;
            int[] nArray = new int[n3 / 64];
            this.block = 0;
            while (this.block < n3) {
                block21: {
                    fileStore.seek((long)n + (long)this.block * (long)n2);
                    byte[] byArray = new byte[n2];
                    DataPage dataPage = DataPage.create((DataHandler)this, byArray);
                    fileStore.readFully(byArray, 0, n2);
                    this.blockCount = dataPage.readInt();
                    this.storageId = -1;
                    this.recordLength = -1;
                    this.valueId = -1;
                    if (this.blockCount == 0) {
                        this.blockCount = 1;
                    } else if (this.blockCount < 0) {
                        this.writeDataError(printWriter, "blockCount<0", dataPage.getBytes(), 1);
                        this.blockCount = 1;
                    } else if ((long)this.blockCount * (long)n2 >= 0x1FFFFFFFL) {
                        this.writeDataError(printWriter, "blockCount=" + this.blockCount, dataPage.getBytes(), 1);
                        this.blockCount = 1;
                    } else {
                        try {
                            dataPage.checkCapacity(this.blockCount * n2);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), 1);
                            this.blockCount = 1;
                            break block21;
                        }
                        if (this.blockCount > 1) {
                            fileStore.readFully(dataPage.getBytes(), n2, this.blockCount * n2 - n2);
                        }
                        try {
                            dataPage.check(this.blockCount * n2);
                        }
                        catch (SQLException sQLException) {
                            this.writeDataError(printWriter, "wrong checksum", dataPage.getBytes(), 1);
                            this.blockCount = 1;
                            break block21;
                        }
                        this.storageId = dataPage.readInt();
                        if (this.storageId < 0) {
                            this.writeDataError(printWriter, "storageId<0", dataPage.getBytes(), this.blockCount);
                        } else {
                            int n4 = this.block / 64;
                            if (nArray[n4] != 0 && nArray[n4] != this.storageId) {
                                this.writeDataError(printWriter, "double allocation, previous=" + nArray[n4] + " now=" + this.storageId, dataPage.getBytes(), this.blockCount);
                            } else {
                                nArray[n4] = this.storageId;
                            }
                            printWriter.println("// [" + this.block + "] page:" + n4 + " blocks:" + this.blockCount + " storage:" + this.storageId);
                        }
                    }
                }
                this.block += this.blockCount;
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
                throwable.printStackTrace();
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
            }
        }
        IOUtils.closeSilently(printWriter);
        this.closeSilently(fileStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPageStore(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".h2.db".length()));
        FileStore fileStore = null;
        PrintWriter printWriter = null;
        try {
            printWriter = this.getWriter(string, ".sql");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            this.resetSchema();
            fileStore = FileStore.open(null, string, this.remove ? "rw" : "r");
            long l = fileStore.length();
            try {
                fileStore.init();
            }
            catch (Exception exception) {
                this.writeError(printWriter, exception);
            }
            DataPage dataPage = DataPage.create((DataHandler)this, 128);
            fileStore.seek(0L);
            fileStore.readFully(dataPage.getBytes(), 0, 128);
            dataPage.setPos(48);
            int n = dataPage.readInt();
            int n2 = dataPage.readByte();
            int n3 = dataPage.readByte();
            int n4 = dataPage.readInt();
            int n5 = dataPage.readInt();
            int n6 = dataPage.readInt();
            printWriter.println("-- pageSize " + n);
            printWriter.println("-- writeVersion: " + n2);
            printWriter.println("-- readVersion: " + n3);
            printWriter.println("-- systemTableRoot: " + n4);
            printWriter.println("-- freeListHead: " + n5);
            printWriter.println("-- logHead: " + n6);
            if (n < 128 || n > 32768) {
                n = 1024;
                n4 = 1;
                n5 = 2;
                n6 = 3;
                printWriter.println("-- ERROR: page size; using " + n);
            }
            int n7 = (int)(l / (long)n);
            this.blockCount = 1;
            block18: for (long i = 1L; i < (long)n7; ++i) {
                dataPage = DataPage.create((DataHandler)this, n);
                fileStore.seek(i * (long)n);
                fileStore.readFully(dataPage.getBytes(), 0, n);
                int n8 = dataPage.readInt();
                int n9 = dataPage.readByte();
                switch (n9) {
                    case 0: {
                        if (n8 == 0) continue block18;
                        printWriter.println("-- ERROR parent:" + n8);
                        continue block18;
                    }
                    default: {
                        boolean bl = (n9 & 0x10) != 0;
                        switch (n9 &= 0xFFFFFFEF) {
                            case 3: {
                                printWriter.println("-- page " + i + ": data overflow " + (bl ? "(last)" : ""));
                                continue block18;
                            }
                            case 2: {
                                printWriter.println("-- page " + i + ": data node " + (bl ? "(last)" : ""));
                                continue block18;
                            }
                            case 1: {
                                printWriter.println("-- page " + i + ": data leaf " + (bl ? "(last)" : ""));
                                this.dumpPageDataLeaf(fileStore, n, printWriter, dataPage, bl, i);
                                continue block18;
                            }
                            case 5: {
                                printWriter.println("-- page " + i + ": btree node" + (bl ? "(last)" : ""));
                                continue block18;
                            }
                            case 4: {
                                printWriter.println("-- page " + i + ": btree leaf " + (bl ? "(last)" : ""));
                                continue block18;
                            }
                            case 7: {
                                printWriter.println("-- page " + i + ": free list " + (bl ? "(last)" : ""));
                                continue block18;
                            }
                            case 8: {
                                printWriter.println("-- page " + i + ": log " + (bl ? "(last)" : ""));
                                this.dumpPageLog(fileStore, printWriter, dataPage, bl);
                                continue block18;
                            }
                        }
                        printWriter.println("-- page " + i + ": ERROR unknown type " + n9);
                    }
                }
            }
            this.writeSchema(printWriter);
            for (int i = 0; i < 2; ++i) {
                this.dumpPageLogStream(printWriter, fileStore, n6 + i, n);
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
                throw throwable2;
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(fileStore);
        }
        IOUtils.closeSilently(printWriter);
        this.closeSilently(fileStore);
    }

    private void dumpPageLogStream(PrintWriter printWriter, FileStore fileStore, int n, int n2) throws IOException, SQLException {
        int n3;
        DataPage dataPage = DataPage.create((DataHandler)this, n2);
        DataInputStream dataInputStream = new DataInputStream(new PageInputStream(printWriter, this, fileStore, n, n2, 0, 8));
        int n4 = dataInputStream.readInt();
        printWriter.println("-- log " + n4);
        while ((n3 = dataInputStream.read()) >= 0) {
            int n5;
            if (n3 == 0) continue;
            if (n3 == 1) {
                n5 = dataInputStream.readInt();
                dataInputStream.readFully(new byte[n2]);
                printWriter.println("-- undo page " + n5);
                continue;
            }
            if (n3 == 3 || n3 == 4) {
                n5 = dataInputStream.readInt();
                this.storageId = dataInputStream.readInt();
                Row row = PageLog.readRow(dataInputStream, dataPage);
                printWriter.println("-- session " + n5 + " table " + this.storageId + " " + (n3 == 3 ? "add" : "remove") + " " + row.toString());
                continue;
            }
            if (n3 != 2) continue;
            n5 = dataInputStream.readInt();
            printWriter.println("-- commit " + n5);
        }
    }

    private void dumpPageLog(FileStore fileStore, PrintWriter printWriter, DataPage dataPage, boolean bl) {
        if (bl) {
            int n = dataPage.readInt();
            printWriter.println("--  size:" + n);
        } else {
            int n = dataPage.readInt();
            printWriter.println("--  next:" + n);
        }
    }

    private void dumpPageDataLeaf(FileStore fileStore, int n, PrintWriter printWriter, DataPage dataPage, boolean bl, long l) throws SQLException {
        int n2;
        int n3;
        int n4;
        int[] nArray;
        int[] nArray2;
        int n5;
        block9: {
            this.storageId = dataPage.readInt();
            n5 = dataPage.readShortInt();
            nArray2 = new int[n5];
            nArray = new int[n5];
            long l2 = 0L;
            if (!bl) {
                l2 = dataPage.readInt();
            }
            for (n4 = 0; n4 < n5; ++n4) {
                nArray2[n4] = dataPage.readInt();
                nArray[n4] = dataPage.readShortInt();
            }
            if (!bl) {
                DataPage dataPage2 = DataPage.create((DataHandler)this, n);
                dataPage.setPos(n);
                while (true) {
                    fileStore.seek((long)n * l2);
                    fileStore.readFully(dataPage2.getBytes(), 0, n);
                    dataPage2.setPos(4);
                    n3 = dataPage2.readByte();
                    if (n3 == 19) {
                        n2 = dataPage2.readShortInt();
                        printWriter.println("-- chain:" + l2 + " type:" + n3 + " size:" + n2);
                        dataPage.write(dataPage2.getBytes(), 7, n2);
                        break block9;
                    }
                    if (n3 != 3) break;
                    l2 = dataPage2.readInt();
                    if (l2 == 0L) {
                        this.writeDataError(printWriter, "next:0", dataPage2.getBytes(), 1);
                        break block9;
                    }
                    n2 = n - 9;
                    printWriter.println("-- chain:" + l2 + " type:" + n3 + " size:" + n2 + " next:" + l2);
                    dataPage.write(dataPage2.getBytes(), 9, n2);
                }
                this.writeDataError(printWriter, "type:" + n3, dataPage2.getBytes(), 1);
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            int n6;
            String string;
            n3 = nArray2[n4];
            n2 = nArray[n4];
            printWriter.println("-- [" + n4 + "] storage:" + this.storageId + " key:" + n3 + " off:" + n2);
            dataPage.setPos(n2);
            Value[] valueArray = this.createRecord(printWriter, dataPage);
            if (valueArray == null) continue;
            this.createTemporaryTable(printWriter);
            this.writeRow(printWriter, dataPage, valueArray);
            if (!this.remove || this.storageId != 0 || !(string = valueArray[3].getString()).startsWith("CREATE USER ") || (n6 = ByteUtils.indexOf(dataPage.getBytes(), "SALT ".getBytes(), n2)) < 0) continue;
            String string2 = string.substring("CREATE USER ".length(), string.indexOf("SALT ") - 1);
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            SHA256 sHA256 = new SHA256();
            byte[] byArray = sHA256.getKeyPasswordHash(string2, "".toCharArray());
            byte[] byArray2 = RandomUtils.getSecureBytes(8);
            byte[] byArray3 = sHA256.getHashWithSalt(byArray, byArray2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SALT '");
            stringBuffer.append(ByteUtils.convertBytesToString(byArray2));
            stringBuffer.append("' HASH '");
            stringBuffer.append(ByteUtils.convertBytesToString(byArray3));
            stringBuffer.append("'");
            byte[] byArray4 = stringBuffer.toString().getBytes();
            System.arraycopy(byArray4, 0, dataPage.getBytes(), n6, byArray4.length);
            fileStore.seek((long)n * l);
            fileStore.write(dataPage.getBytes(), 0, n);
            if (this.trace) {
                this.out.println("User: " + string2);
            }
            this.remove = false;
        }
    }

    private Value[] createRecord(PrintWriter printWriter, DataPage dataPage) {
        Value[] valueArray;
        this.recordLength = dataPage.readInt();
        if (this.recordLength <= 0) {
            this.writeDataError(printWriter, "recordLength<0", dataPage.getBytes(), this.blockCount);
            return null;
        }
        try {
            valueArray = new Value[this.recordLength];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            return null;
        }
        return valueArray;
    }

    private void writeRow(PrintWriter printWriter, DataPage dataPage, Value[] valueArray) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO O_" + this.storageId + " VALUES(");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                object = dataPage.readValue();
                valueArray[this.valueId] = object;
                if (this.valueId > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getSQL((Value)object));
            }
            catch (Exception exception) {
                this.writeDataError(printWriter, "exception " + exception, dataPage.getBytes(), this.blockCount);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            }
            ++this.valueId;
        }
        stringBuffer.append(");");
        printWriter.println(stringBuffer.toString());
        printWriter.flush();
        if (this.storageId == 0) {
            try {
                object = new SimpleRow(valueArray);
                MetaRecord metaRecord = new MetaRecord((SearchRow)object);
                this.schema.add(metaRecord);
                if (metaRecord.getObjectType() == 0) {
                    String string = valueArray[3].getString();
                    String string2 = this.extractTableOrViewName(string);
                    this.tableMap.put(ObjectUtils.getInteger(metaRecord.getId()), string2);
                }
            }
            catch (Throwable throwable) {
                this.writeError(printWriter, throwable);
            }
        }
    }

    private void dumpData(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".data.db".length()));
        this.dumpData(string, string, 48);
    }

    private void resetSchema() {
        this.schema = new ObjectArray();
        this.objectIdSet = new HashSet();
        this.tableMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void dumpData(String var1_1, String var2_2, int var3_3) {
        var4_4 = null;
        var5_5 = null;
        try {
            var4_4 = this.getWriter(var2_2, ".sql");
            var4_4.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            var4_4.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            this.resetSchema();
            var5_5 = FileStore.open(null, var1_1, "r");
            var6_6 = var5_5.length();
            var8_8 = 128;
            var9_9 = (int)(var6_6 / (long)var8_8);
            this.blockCount = 1;
            var10_10 = new int[var9_9 / 64];
            this.block = 0;
            while (this.block < var9_9) {
                block18: {
                    block21: {
                        block20: {
                            block19: {
                                var5_5.seek((long)var3_3 + (long)this.block * (long)var8_8);
                                var11_11 = new byte[var8_8];
                                var12_12 = DataPage.create((DataHandler)this, var11_11);
                                var5_5.readFully(var11_11, 0, var8_8);
                                this.blockCount = var12_12.readInt();
                                this.storageId = -1;
                                this.recordLength = -1;
                                this.valueId = -1;
                                if (this.blockCount != 0) break block19;
                                this.blockCount = 1;
                                break block18;
                            }
                            if (this.blockCount >= 0) break block20;
                            this.writeDataError(var4_4, "blockCount<0", var12_12.getBytes(), 1);
                            this.blockCount = 1;
                            break block18;
                        }
                        if ((long)this.blockCount * (long)var8_8 < 0x1FFFFFFFL && this.blockCount * var8_8 >= 0) break block21;
                        this.writeDataError(var4_4, "blockCount=" + this.blockCount, var12_12.getBytes(), 1);
                        this.blockCount = 1;
                        break block18;
                    }
                    var4_4.println("-- block " + this.block + " - " + (this.block + this.blockCount - 1));
                    try {
                        var12_12.checkCapacity(this.blockCount * var8_8);
                    }
                    catch (OutOfMemoryError var13_13) {
                        this.writeDataError(var4_4, "out of memory", var12_12.getBytes(), 1);
                        this.blockCount = 1;
                        break block18;
                    }
                    if (this.blockCount <= 1) ** GOTO lbl59
                    if (this.blockCount * var8_8 < 0) {
                        this.writeDataError(var4_4, "wrong blockCount", var12_12.getBytes(), 1);
                        this.blockCount = 1;
                    } else {
                        try {
                            var5_5.readFully(var12_12.getBytes(), var8_8, this.blockCount * var8_8 - var8_8);
                        }
                        catch (Throwable var13_14) {
                            this.writeDataError(var4_4, "eof", var12_12.getBytes(), 1);
                            this.blockCount = 1;
                            var5_5 = FileStore.open(null, var1_1, "r");
                            break block18;
                        }
lbl59:
                        // 2 sources

                        try {
                            var12_12.check(this.blockCount * var8_8);
                        }
                        catch (SQLException var13_15) {
                            this.writeDataError(var4_4, "wrong checksum", var12_12.getBytes(), 1);
                            this.blockCount = 1;
                            break block18;
                        }
                        this.storageId = var12_12.readInt();
                        if (this.storageId < 0) {
                            this.writeDataError(var4_4, "storageId<0", var12_12.getBytes(), this.blockCount);
                        } else {
                            var13_16 = this.block / 64;
                            if (var10_10[var13_16] != 0 && var10_10[var13_16] != this.storageId) {
                                this.writeDataError(var4_4, "double allocation, previous=" + var10_10[var13_16] + " now=" + this.storageId, var12_12.getBytes(), this.blockCount);
                            } else {
                                var10_10[var13_16] = this.storageId;
                            }
                            var14_17 = this.createRecord(var4_4, var12_12);
                            if (var14_17 != null) {
                                this.createTemporaryTable(var4_4);
                                this.writeRow(var4_4, var12_12, var14_17);
                            }
                        }
                    }
                }
                this.block += this.blockCount;
            }
            this.writeSchema(var4_4);
            var4_4.close();
        }
        catch (Throwable var6_7) {
            try {
                this.writeError(var4_4, var6_7);
            }
            catch (Throwable var15_18) {
                IOUtils.closeSilently(var4_4);
                this.closeSilently(var5_5);
                throw var15_18;
            }
            IOUtils.closeSilently(var4_4);
            this.closeSilently(var5_5);
        }
        IOUtils.closeSilently(var4_4);
        this.closeSilently(var5_5);
    }

    private void writeSchema(PrintWriter printWriter) {
        Object object;
        MetaRecord.sort(this.schema);
        for (int i = 0; i < this.schema.size(); ++i) {
            object = (MetaRecord)this.schema.get(i);
            printWriter.println(((MetaRecord)object).getSQL() + ";");
        }
        Iterator iterator = this.tableMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Integer n = (Integer)object.getKey();
            String string = (String)object.getValue();
            if (!this.objectIdSet.contains(n)) continue;
            printWriter.println("INSERT INTO " + string + " SELECT * FROM O_" + n + ";");
        }
        iterator = this.objectIdSet.iterator();
        while (iterator.hasNext()) {
            object = (Integer)((Object)iterator.next());
            printWriter.println("DROP TABLE O_" + object + ";");
        }
        printWriter.println("DROP ALIAS READ_CLOB;");
        printWriter.println("DROP ALIAS READ_BLOB;");
    }

    private void createTemporaryTable(PrintWriter printWriter) {
        if (!this.objectIdSet.contains(ObjectUtils.getInteger(this.storageId))) {
            this.objectIdSet.add(ObjectUtils.getInteger(this.storageId));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CREATE TABLE O_" + this.storageId + "(");
            for (int i = 0; i < this.recordLength; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("C");
                stringBuffer.append(i);
                stringBuffer.append(" VARCHAR");
            }
            stringBuffer.append(");");
            printWriter.println(stringBuffer.toString());
            printWriter.flush();
        }
    }

    private String extractTableOrViewName(String string) {
        int n = string.indexOf(" TABLE ");
        int n2 = string.indexOf(" VIEW ");
        if (n > 0 && n2 > 0) {
            if (n < n2) {
                n2 = -1;
            } else {
                n = -1;
            }
        }
        if (n2 > 0) {
            string = string.substring(n2 + " VIEW ".length());
        } else if (n > 0) {
            string = string.substring(n + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (bl || c > ' ' && c != '(') continue;
            string = string.substring(0, i);
            return string;
        }
        return "UNKNOWN";
    }

    private void closeSilently(FileStore fileStore) {
        if (fileStore != null) {
            fileStore.closeSilently();
        }
    }

    private void writeError(PrintWriter printWriter, Throwable throwable) {
        if (printWriter != null) {
            printWriter.println("// error: " + throwable);
        }
        this.traceError("Error", throwable);
    }

    public String getDatabasePath() {
        return this.databaseName;
    }

    public FileStore openFile(String string, String string2, boolean bl) throws SQLException {
        return FileStore.open(this, string, "rw");
    }

    public int getChecksum(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 += byArray[n++];
        }
        return n3;
    }

    public void checkPowerOff() {
    }

    public void checkWritingAllowed() {
    }

    public void freeUpDiskSpace() {
    }

    public void handleInvalidChecksum() throws SQLException {
        throw new SQLException("Invalid Checksum");
    }

    public int compareTypeSave(Value value, Value value2) {
        throw Message.throwInternalError();
    }

    public int getMaxLengthInplaceLob() {
        throw Message.throwInternalError();
    }

    public int allocateObjectId(boolean bl, boolean bl2) {
        throw Message.throwInternalError();
    }

    public String createTempFile() {
        throw Message.throwInternalError();
    }

    public String getLobCompressionAlgorithm(int n) {
        return null;
    }

    public Object getLobSyncObject() {
        return this;
    }

    public boolean getLobFilesInDirectories() {
        return this.lobFilesInDirectories;
    }

    public SmallLRUCache getLobFileListCache() {
        return null;
    }

    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    public Trace getTrace() {
        return null;
    }

    static class PageInputStream
    extends InputStream {
        private final PrintWriter writer;
        private final int type;
        private final FileStore store;
        private final DataPage page;
        private final int pageSize;
        private int parentPage;
        private int nextPage;
        private boolean endOfFile;
        private int remaining;

        public PageInputStream(PrintWriter printWriter, DataHandler dataHandler, FileStore fileStore, int n, int n2, int n3, int n4) {
            this.writer = printWriter;
            this.store = fileStore;
            this.pageSize = n2;
            this.type = n4;
            this.parentPage = n3;
            this.nextPage = n;
            this.page = DataPage.create(dataHandler, n2);
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            return n < 0 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 == 0) {
                return 0;
            }
            int n4 = 0;
            while (n2 > 0 && (n3 = this.readBlock(byArray, n, n2)) >= 0) {
                n4 += n3;
                n += n3;
                n2 -= n3;
            }
            return n4 == 0 ? -1 : n4;
        }

        private int readBlock(byte[] byArray, int n, int n2) throws IOException {
            this.fillBuffer();
            if (this.endOfFile) {
                return -1;
            }
            int n3 = Math.min(this.remaining, n2);
            this.page.read(byArray, n, n3);
            this.remaining -= n3;
            return n3;
        }

        private void fillBuffer() throws IOException {
            if (this.remaining > 0 || this.endOfFile) {
                return;
            }
            if (this.nextPage == 0) {
                this.endOfFile = true;
                return;
            }
            this.page.reset();
            try {
                boolean bl;
                this.store.seek((long)this.nextPage * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                int n = this.page.readInt();
                int n2 = this.page.readByte();
                boolean bl2 = bl = (n2 & 0x10) != 0;
                if (this.type != (n2 &= 0xFFFFFFEF) || n != this.parentPage) {
                    this.writer.println("-- ERROR  page:" + this.nextPage + " type:" + n2 + " parent:" + n + " expected type:" + this.type + " expected parent:" + this.parentPage);
                }
                this.parentPage = this.nextPage;
                if (bl) {
                    this.nextPage = 0;
                    this.remaining = this.page.readInt();
                } else {
                    this.nextPage = this.page.readInt();
                    this.remaining = this.pageSize - this.page.length();
                }
            }
            catch (SQLException sQLException) {
                throw Message.convertToIOException(sQLException);
            }
        }
    }
}

