/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.tools.SimpleResultSet;
import org.h2.util.ByteUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public abstract class Value {
    public static final int UNKNOWN = -1;
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int DECIMAL = 6;
    public static final int DOUBLE = 7;
    public static final int FLOAT = 8;
    public static final int TIME = 9;
    public static final int DATE = 10;
    public static final int TIMESTAMP = 11;
    public static final int BYTES = 12;
    public static final int STRING = 13;
    public static final int STRING_IGNORECASE = 14;
    public static final int BLOB = 15;
    public static final int CLOB = 16;
    public static final int ARRAY = 17;
    public static final int RESULT_SET = 18;
    public static final int JAVA_OBJECT = 19;
    public static final int UUID = 20;
    public static final int STRING_FIXED = 21;
    public static final int TYPE_COUNT = 22;
    private static SoftReference softCache = new SoftReference<Object>(null);
    private static final BigDecimal MAX_LONG_DECIMAL = new BigDecimal("9223372036854775807");
    private static final BigDecimal MIN_LONG_DECIMAL = new BigDecimal("-9223372036854775808");

    public abstract String getSQL();

    public abstract int getType();

    public abstract long getPrecision();

    public abstract int getDisplaySize();

    public int getMemory() {
        return DataType.getDataType((int)this.getType()).memory * 4;
    }

    public abstract String getString();

    public abstract Object getObject();

    public abstract void set(PreparedStatement var1, int var2) throws SQLException;

    protected abstract int compareSecure(Value var1, CompareMode var2) throws SQLException;

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static int getOrder(int n) {
        switch (n) {
            case -1: {
                return 1;
            }
            case 0: {
                return 2;
            }
            case 13: {
                return 10;
            }
            case 16: {
                return 11;
            }
            case 21: {
                return 12;
            }
            case 14: {
                return 13;
            }
            case 1: {
                return 20;
            }
            case 2: {
                return 21;
            }
            case 3: {
                return 22;
            }
            case 4: {
                return 23;
            }
            case 5: {
                return 24;
            }
            case 6: {
                return 25;
            }
            case 8: {
                return 26;
            }
            case 7: {
                return 27;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 32;
            }
            case 12: {
                return 40;
            }
            case 15: {
                return 41;
            }
            case 20: {
                return 42;
            }
            case 19: {
                return 43;
            }
            case 17: {
                return 50;
            }
            case 18: {
                return 51;
            }
        }
        throw Message.throwInternalError("type:" + n);
    }

    public static int getHigherOrder(int n, int n2) throws SQLException {
        int n3;
        if (n == n2) {
            if (n == -1) {
                throw Message.getSQLException(50004, "?, ?");
            }
            return n;
        }
        int n4 = Value.getOrder(n);
        return n4 > (n3 = Value.getOrder(n2)) ? n : n2;
    }

    static Value cache(Value value) {
        if (SysProperties.OBJECT_CACHE) {
            int n;
            Value value2;
            Value[] valueArray;
            int n2 = value.hashCode();
            if (softCache == null) {
                softCache = new SoftReference<Object>(null);
            }
            if ((valueArray = (Value[])softCache.get()) == null) {
                valueArray = new Value[SysProperties.OBJECT_CACHE_SIZE];
                softCache = new SoftReference<Value[]>(valueArray);
            }
            if ((value2 = valueArray[n = n2 & SysProperties.OBJECT_CACHE_SIZE - 1]) != null && value2.getType() == value.getType() && value.equals(value2)) {
                return value2;
            }
            valueArray[n] = value;
        }
        return value;
    }

    public Boolean getBoolean() throws SQLException {
        return ((ValueBoolean)this.convertTo(1)).getBoolean();
    }

    public Date getDate() throws SQLException {
        return ((ValueDate)this.convertTo(10)).getDate();
    }

    public Date getDateNoCopy() throws SQLException {
        return ((ValueDate)this.convertTo(10)).getDateNoCopy();
    }

    public Time getTime() throws SQLException {
        return ((ValueTime)this.convertTo(9)).getTime();
    }

    public Time getTimeNoCopy() throws SQLException {
        return ((ValueTime)this.convertTo(9)).getTimeNoCopy();
    }

    public Timestamp getTimestamp() throws SQLException {
        return ((ValueTimestamp)this.convertTo(11)).getTimestamp();
    }

    public Timestamp getTimestampNoCopy() throws SQLException {
        return ((ValueTimestamp)this.convertTo(11)).getTimestampNoCopy();
    }

    public byte[] getBytes() throws SQLException {
        return ((ValueBytes)this.convertTo(12)).getBytes();
    }

    public byte[] getBytesNoCopy() throws SQLException {
        return ((ValueBytes)this.convertTo(12)).getBytesNoCopy();
    }

    public byte getByte() throws SQLException {
        return ((ValueByte)this.convertTo(2)).getByte();
    }

    public short getShort() throws SQLException {
        return ((ValueShort)this.convertTo(3)).getShort();
    }

    public BigDecimal getBigDecimal() throws SQLException {
        return ((ValueDecimal)this.convertTo(6)).getBigDecimal();
    }

    public double getDouble() throws SQLException {
        return ((ValueDouble)this.convertTo(7)).getDouble();
    }

    public float getFloat() throws SQLException {
        return ((ValueFloat)this.convertTo(8)).getFloat();
    }

    public int getInt() throws SQLException {
        return ((ValueInt)this.convertTo(4)).getInt();
    }

    public long getLong() throws SQLException {
        return ((ValueLong)this.convertTo(5)).getLong();
    }

    public InputStream getInputStream() throws SQLException {
        return new ByteArrayInputStream(this.getBytesNoCopy());
    }

    public Reader getReader() {
        return IOUtils.getReader(this.getString());
    }

    public Value add(Value value) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public int getSignum() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value negate() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value subtract(Value value) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value divide(Value value) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value multiply(Value value) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value convertTo(int n) throws SQLException {
        if (this.getType() == n) {
            return this;
        }
        switch (n) {
            case 1: {
                switch (this.getType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return ValueBoolean.get(this.getSignum() != 0);
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 19: 
                    case 20: {
                        throw Message.getSQLException(90021, this.getString());
                    }
                }
                break;
            }
            case 2: {
                switch (this.getType()) {
                    case 1: {
                        return ValueByte.get(this.getBoolean() != false ? (byte)1 : 0);
                    }
                    case 3: {
                        return ValueByte.get(this.convertToByte(this.getShort()));
                    }
                    case 4: {
                        return ValueByte.get(this.convertToByte(this.getInt()));
                    }
                    case 5: {
                        return ValueByte.get(this.convertToByte(this.getLong()));
                    }
                    case 6: {
                        return ValueByte.get(this.convertToByte(this.convertToLong(this.getBigDecimal())));
                    }
                    case 7: {
                        return ValueByte.get(this.convertToByte(this.convertToLong(this.getDouble())));
                    }
                    case 8: {
                        return ValueByte.get(this.convertToByte(this.convertToLong(this.getFloat())));
                    }
                }
                break;
            }
            case 3: {
                switch (this.getType()) {
                    case 1: {
                        return ValueShort.get(this.getBoolean() != false ? (short)1 : 0);
                    }
                    case 2: {
                        return ValueShort.get(this.getByte());
                    }
                    case 4: {
                        return ValueShort.get(this.convertToShort(this.getInt()));
                    }
                    case 5: {
                        return ValueShort.get(this.convertToShort(this.getLong()));
                    }
                    case 6: {
                        return ValueShort.get(this.convertToShort(this.convertToLong(this.getBigDecimal())));
                    }
                    case 7: {
                        return ValueShort.get(this.convertToShort(this.convertToLong(this.getDouble())));
                    }
                    case 8: {
                        return ValueShort.get(this.convertToShort(this.convertToLong(this.getFloat())));
                    }
                }
                break;
            }
            case 4: {
                switch (this.getType()) {
                    case 1: {
                        return ValueInt.get(this.getBoolean() != false ? 1 : 0);
                    }
                    case 2: {
                        return ValueInt.get(this.getByte());
                    }
                    case 3: {
                        return ValueInt.get(this.getShort());
                    }
                    case 5: {
                        return ValueInt.get(this.convertToInt(this.getLong()));
                    }
                    case 6: {
                        return ValueInt.get(this.convertToInt(this.convertToLong(this.getBigDecimal())));
                    }
                    case 7: {
                        return ValueInt.get(this.convertToInt(this.convertToLong(this.getDouble())));
                    }
                    case 8: {
                        return ValueInt.get(this.convertToInt(this.convertToLong(this.getFloat())));
                    }
                }
                break;
            }
            case 5: {
                switch (this.getType()) {
                    case 1: {
                        return ValueLong.get(this.getBoolean() != false ? 1L : 0L);
                    }
                    case 2: {
                        return ValueLong.get(this.getByte());
                    }
                    case 3: {
                        return ValueLong.get(this.getShort());
                    }
                    case 4: {
                        return ValueLong.get(this.getInt());
                    }
                    case 6: {
                        return ValueLong.get(this.convertToLong(this.getBigDecimal()));
                    }
                    case 7: {
                        return ValueLong.get(this.convertToLong(this.getDouble()));
                    }
                    case 8: {
                        return ValueLong.get(this.convertToLong(this.getFloat()));
                    }
                }
                break;
            }
            case 6: {
                switch (this.getType()) {
                    case 1: {
                        return ValueDecimal.get(new BigDecimal(this.getBoolean() != false ? "1" : "0"));
                    }
                    case 2: {
                        return ValueDecimal.get(new BigDecimal("" + this.getByte()));
                    }
                    case 3: {
                        return ValueDecimal.get(new BigDecimal("" + this.getShort()));
                    }
                    case 4: {
                        return ValueDecimal.get(new BigDecimal("" + this.getInt()));
                    }
                    case 5: {
                        return ValueDecimal.get(new BigDecimal("" + this.getLong()));
                    }
                    case 7: {
                        double d = this.getDouble();
                        if (Double.isInfinite(d) || Double.isNaN(d)) {
                            throw Message.getSQLException(90021, "" + d);
                        }
                        return ValueDecimal.get(new BigDecimal(d));
                    }
                    case 8: {
                        float f = this.getFloat();
                        if (Float.isInfinite(f) || Float.isNaN(f)) {
                            throw Message.getSQLException(90021, "" + f);
                        }
                        return ValueDecimal.get(new BigDecimal(f));
                    }
                }
                break;
            }
            case 7: {
                switch (this.getType()) {
                    case 1: {
                        return ValueDouble.get(this.getBoolean() != false ? 1.0 : 0.0);
                    }
                    case 2: {
                        return ValueDouble.get(this.getByte());
                    }
                    case 3: {
                        return ValueDouble.get(this.getShort());
                    }
                    case 4: {
                        return ValueDouble.get(this.getInt());
                    }
                    case 5: {
                        return ValueDouble.get(this.getLong());
                    }
                    case 6: {
                        return ValueDouble.get(this.getBigDecimal().doubleValue());
                    }
                    case 8: {
                        return ValueDouble.get(this.getFloat());
                    }
                }
                break;
            }
            case 8: {
                switch (this.getType()) {
                    case 1: {
                        return ValueFloat.get(this.getBoolean() != false ? 1.0f : 0.0f);
                    }
                    case 2: {
                        return ValueFloat.get(this.getByte());
                    }
                    case 3: {
                        return ValueFloat.get(this.getShort());
                    }
                    case 4: {
                        return ValueFloat.get(this.getInt());
                    }
                    case 5: {
                        return ValueFloat.get(this.getLong());
                    }
                    case 6: {
                        return ValueFloat.get(this.getBigDecimal().floatValue());
                    }
                    case 7: {
                        return ValueFloat.get((float)this.getDouble());
                    }
                }
                break;
            }
            case 10: {
                switch (this.getType()) {
                    case 9: {
                        return ValueDate.get(new Date(this.getTimeNoCopy().getTime()));
                    }
                    case 11: {
                        return ValueDate.get(new Date(this.getTimestampNoCopy().getTime()));
                    }
                }
                break;
            }
            case 9: {
                switch (this.getType()) {
                    case 10: {
                        return ValueTime.get(new Time(this.getDateNoCopy().getTime()));
                    }
                    case 11: {
                        return ValueTime.get(new Time(this.getTimestampNoCopy().getTime()));
                    }
                }
                break;
            }
            case 11: {
                switch (this.getType()) {
                    case 9: {
                        return ValueTimestamp.getNoCopy(new Timestamp(this.getTimeNoCopy().getTime()));
                    }
                    case 10: {
                        return ValueTimestamp.getNoCopy(new Timestamp(this.getDateNoCopy().getTime()));
                    }
                }
                break;
            }
            case 12: {
                switch (this.getType()) {
                    case 15: 
                    case 19: {
                        return ValueBytes.getNoCopy(this.getBytesNoCopy());
                    }
                    case 20: {
                        return ValueBytes.getNoCopy(this.getBytes());
                    }
                }
                break;
            }
            case 19: {
                switch (this.getType()) {
                    case 12: 
                    case 15: {
                        return ValueBytes.getNoCopy(this.getBytesNoCopy());
                    }
                }
                break;
            }
            case 15: {
                switch (this.getType()) {
                    case 12: {
                        return ValueLob.createSmallLob(15, this.getBytesNoCopy());
                    }
                }
                break;
            }
            case 20: {
                switch (this.getType()) {
                    case 12: {
                        return ValueUuid.get(this.getBytesNoCopy());
                    }
                }
            }
        }
        String string = this.getString();
        try {
            switch (n) {
                case 0: {
                    return ValueNull.INSTANCE;
                }
                case 1: {
                    if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y")) {
                        return ValueBoolean.get(true);
                    }
                    if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n")) {
                        return ValueBoolean.get(false);
                    }
                    return ValueBoolean.get(new BigDecimal(string).signum() != 0);
                }
                case 2: {
                    return ValueByte.get(MathUtils.decodeByte(string.trim()));
                }
                case 3: {
                    return ValueShort.get(MathUtils.decodeShort(string.trim()));
                }
                case 4: {
                    return ValueInt.get(MathUtils.decodeInt(string.trim()));
                }
                case 5: {
                    return ValueLong.get(MathUtils.decodeLong(string.trim()));
                }
                case 6: {
                    return ValueDecimal.get(new BigDecimal(string.trim()));
                }
                case 9: {
                    return ValueTime.getNoCopy(ValueTime.parseTime(string.trim()));
                }
                case 10: {
                    return ValueDate.getNoCopy(ValueDate.parseDate(string.trim()));
                }
                case 11: {
                    return ValueTimestamp.getNoCopy(ValueTimestamp.parseTimestamp(string.trim()));
                }
                case 12: {
                    return ValueBytes.getNoCopy(ByteUtils.convertStringToBytes(string.trim()));
                }
                case 19: {
                    return ValueJavaObject.getNoCopy(ByteUtils.convertStringToBytes(string.trim()));
                }
                case 13: {
                    return ValueString.get(string);
                }
                case 14: {
                    return ValueStringIgnoreCase.get(string);
                }
                case 21: {
                    return ValueStringFixed.get(string);
                }
                case 7: {
                    return ValueDouble.get(Double.parseDouble(string.trim()));
                }
                case 8: {
                    return ValueFloat.get(Float.parseFloat(string.trim()));
                }
                case 16: {
                    return ValueLob.createSmallLob(16, StringUtils.utf8Encode(string));
                }
                case 15: {
                    return ValueLob.createSmallLob(15, ByteUtils.convertStringToBytes(string.trim()));
                }
                case 17: {
                    return ValueArray.get(new Value[]{ValueString.get(string)});
                }
                case 18: {
                    SimpleResultSet simpleResultSet = new SimpleResultSet();
                    simpleResultSet.addColumn("X", 12, string.length(), 0);
                    simpleResultSet.addRow(new String[]{string});
                    return ValueResultSet.get(simpleResultSet);
                }
                case 20: {
                    return ValueUuid.get(string);
                }
            }
            throw Message.throwInternalError("type=" + n);
        }
        catch (NumberFormatException numberFormatException) {
            throw Message.getSQLException(90021, new String[]{string}, numberFormatException);
        }
    }

    public final int compareTypeSave(Value value, CompareMode compareMode) throws SQLException {
        if (this == ValueNull.INSTANCE) {
            return value == ValueNull.INSTANCE ? 0 : -1;
        }
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        return this.compareSecure(value, compareMode);
    }

    public final boolean compareEqual(Value value) throws SQLException {
        if (this == ValueNull.INSTANCE) {
            return value == ValueNull.INSTANCE;
        }
        if (value == ValueNull.INSTANCE) {
            return false;
        }
        if (this.getType() == value.getType()) {
            return this.equals(value);
        }
        int n = Value.getHigherOrder(this.getType(), value.getType());
        return this.convertTo(n).equals(value.convertTo(n));
    }

    public final int compareTo(Value value, CompareMode compareMode) throws SQLException {
        if (this == value) {
            return 0;
        }
        if (this == ValueNull.INSTANCE) {
            return value == ValueNull.INSTANCE ? 0 : -1;
        }
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        if (this.getType() == value.getType()) {
            return this.compareSecure(value, compareMode);
        }
        int n = Value.getHigherOrder(this.getType(), value.getType());
        return this.convertTo(n).compareSecure(value.convertTo(n), compareMode);
    }

    public int getScale() {
        return 0;
    }

    public Value convertScale(boolean bl, int n) throws SQLException {
        return this;
    }

    public Value convertPrecision(long l) throws SQLException {
        return this;
    }

    private byte convertToByte(long l) throws SQLException {
        if (l > 127L || l < -128L) {
            throw Message.getSQLException(22003);
        }
        return (byte)l;
    }

    private short convertToShort(long l) throws SQLException {
        if (l > 32767L || l < -32768L) {
            throw Message.getSQLException(22003);
        }
        return (short)l;
    }

    private int convertToInt(long l) throws SQLException {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw Message.getSQLException(22003);
        }
        return (int)l;
    }

    private long convertToLong(double d) throws SQLException {
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw Message.getSQLException(22003);
        }
        return Math.round(d);
    }

    private long convertToLong(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal.compareTo(MAX_LONG_DECIMAL) > 0 || bigDecimal.compareTo(MIN_LONG_DECIMAL) < 0) {
            throw Message.getSQLException(22003);
        }
        return bigDecimal.setScale(0, 4).longValue();
    }

    public Value link(DataHandler dataHandler, int n) throws SQLException {
        return this;
    }

    public boolean isLinked() {
        return false;
    }

    public void unlink() throws SQLException {
    }

    public boolean isFileBased() {
        return false;
    }

    public void close() throws SQLException {
    }

    public boolean checkPrecision(long l) {
        return this.getPrecision() <= l;
    }

    public String getTraceSQL() {
        return this.getSQL();
    }

    public String toString() {
        return this.getTraceSQL();
    }
}

