/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.value.Value;

public class JdbcClob
extends TraceObject
implements Clob {
    private Value value;
    private JdbcConnection conn;

    public JdbcClob(JdbcConnection jdbcConnection, Value value, int n) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 10, n);
        this.conn = jdbcConnection;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        long l;
        long l2;
        this.debugCodeCall("length");
        this.checkClosed();
        if (this.value.getType() == 16 && (l2 = this.value.getPrecision()) > 0L) {
            return l2;
        }
        Reader reader = this.value.getReader();
        try {
            int n;
            long l3 = 0L;
            char[] cArray = new char[16];
            while ((n = reader.read(cArray, 0, 16)) > 0) {
                l3 += (long)n;
            }
            l = l3;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        reader.close();
        return l;
    }

    public void truncate(long l) throws SQLException {
        this.debugCodeCall("truncate", l);
        throw Message.getUnsupportedException();
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream");
            this.checkClosed();
            String string = this.value.getString();
            return IOUtils.getInputStream(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        this.debugCodeCall("setAsciiStream", l);
        throw Message.getUnsupportedException();
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream");
            this.checkClosed();
            return this.value.getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Writer setCharacterStream(long l) throws SQLException {
        this.debugCodeCall("setCharacterStream", l);
        throw Message.getUnsupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long l, int n) throws SQLException {
        try {
            this.debugCode("getSubString(" + l + ", " + n + ");");
            this.checkClosed();
            if (l < 1L) {
                throw Message.getInvalidValueException("pos", "" + l);
            }
            if (n < 0) {
                throw Message.getInvalidValueException("length", "" + n);
            }
            StringBuffer stringBuffer = new StringBuffer(Math.min(4096, n));
            Reader reader = this.value.getReader();
            try {
                IOUtils.skipFully(reader, l - 1L);
                for (int i = 0; i < n; ++i) {
                    int n2 = reader.read();
                    if (n2 < 0) {
                        break;
                    }
                    stringBuffer.append((char)n2);
                }
            }
            finally {
                reader.close();
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int setString(long l, String string) throws SQLException {
        this.debugCode("setString(" + l + ", " + this.quote(string) + ");");
        throw Message.getUnsupportedException();
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.debugCode("setString(" + l + ", " + this.quote(string) + ", " + n + ", " + n2 + ");");
        throw Message.getUnsupportedException();
    }

    public long position(String string, long l) throws SQLException {
        this.debugCode("position(" + this.quote(string) + ", " + l + ");");
        throw Message.getUnsupportedException();
    }

    public long position(Clob clob, long l) throws SQLException {
        this.debugCode("position(clobPattern, " + l + ");");
        throw Message.getUnsupportedException();
    }

    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        this.debugCode("getCharacterStream(" + l + ", " + l2 + ");");
        throw Message.getUnsupportedException();
    }

    private void checkClosed() throws SQLException {
        this.conn.checkClosed();
        if (this.value == null) {
            throw Message.getSQLException(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.value.getTraceSQL();
    }
}

