/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataLeafOverflow;
import org.h2.index.PageDataNode;
import org.h2.index.PageScanCursor;
import org.h2.index.PageScanIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.store.Record;

class PageDataLeaf
extends PageData {
    private static final int KEY_OFFSET_PAIR_LENGTH = 6;
    private static final int KEY_OFFSET_PAIR_START = 11;
    int[] offsets;
    Row[] rows;
    int firstOverflowPageId;
    int start = 11;
    private boolean written;

    PageDataLeaf(PageScanIndex pageScanIndex, int n, int n2, DataPage dataPage) {
        super(pageScanIndex, n, n2, dataPage);
    }

    void read() throws SQLException {
        this.data.setPos(4);
        int n = this.data.readByte();
        int n2 = this.data.readInt();
        if (n2 != this.index.getId()) {
            throw Message.getSQLException(90030, "page:" + this.getPageId() + " expected table:" + this.index.getId() + " got:" + n2 + " type:" + n);
        }
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.keys = new int[this.entryCount];
        this.rows = new Row[this.entryCount];
        if (n == 1) {
            this.firstOverflowPageId = this.data.readInt();
        }
        for (int i = 0; i < this.entryCount; ++i) {
            this.keys[i] = this.data.readInt();
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
    }

    int addRow(Row row) throws SQLException {
        int n;
        int n2;
        int n3;
        int n4 = row.getByteCount(this.data);
        int n5 = this.index.getPageStore().getPageSize();
        int n6 = n3 = this.entryCount == 0 ? n5 : this.offsets[this.entryCount - 1];
        if (this.entryCount > 0 && n3 - n4 < this.start + 6) {
            return this.entryCount / 2 + 1;
        }
        int n7 = n3 - n4;
        int[] nArray = new int[this.entryCount + 1];
        int[] nArray2 = new int[this.entryCount + 1];
        Row[] rowArray = new Row[this.entryCount + 1];
        if (this.entryCount == 0) {
            n2 = 0;
        } else {
            n2 = this.find(row.getPos());
            System.arraycopy(this.offsets, 0, nArray, 0, n2);
            System.arraycopy(this.keys, 0, nArray2, 0, n2);
            System.arraycopy(this.rows, 0, rowArray, 0, n2);
            if (n2 < this.entryCount) {
                for (n = n2; n < this.entryCount; ++n) {
                    nArray[n + 1] = this.offsets[n] - n4;
                }
                System.arraycopy(this.keys, n2, nArray2, n2 + 1, this.entryCount - n2);
                System.arraycopy(this.rows, n2, rowArray, n2 + 1, this.entryCount - n2);
            }
        }
        n3 = n2 == 0 ? n5 : this.offsets[n2 - 1];
        n7 = n3 - n4;
        ++this.entryCount;
        this.start += 6;
        nArray[n2] = n7;
        nArray2[n2] = row.getPos();
        rowArray[n2] = row;
        this.offsets = nArray;
        this.keys = nArray2;
        this.rows = rowArray;
        this.index.getPageStore().updateRecord(this, true, this.data);
        if (n7 < this.start) {
            int n8;
            if (this.entryCount > 1) {
                Message.throwInternalError();
            }
            this.start += 4;
            n = n4 - (n5 - this.start);
            this.offsets[n2] = n7 = this.start;
            int n9 = this.getPos();
            int n10 = n5;
            int n11 = this.index.getPageStore().allocatePage();
            do {
                int n12;
                int n13;
                if (this.firstOverflowPageId == 0) {
                    this.firstOverflowPageId = n11;
                }
                if (n <= n5 - 7) {
                    n13 = 19;
                    n8 = n;
                    n12 = 0;
                } else {
                    n13 = 3;
                    n8 = n5 - 9;
                    n12 = this.index.getPageStore().allocatePage();
                }
                PageDataLeafOverflow pageDataLeafOverflow = new PageDataLeafOverflow(this, n11, n13, n9, n12, n10, n8);
                this.index.getPageStore().updateRecord(pageDataLeafOverflow, true, null);
                n10 += n8;
                n9 = n11;
                n11 = n12;
            } while ((n -= n8) > 0);
        }
        return 0;
    }

    private void removeRow(int n) throws SQLException {
        --this.entryCount;
        if (this.entryCount <= 0) {
            Message.throwInternalError();
        }
        int[] nArray = new int[this.entryCount];
        int[] nArray2 = new int[this.entryCount];
        Row[] rowArray = new Row[this.entryCount];
        System.arraycopy(this.offsets, 0, nArray, 0, n);
        System.arraycopy(this.keys, 0, nArray2, 0, n);
        System.arraycopy(this.rows, 0, rowArray, 0, n);
        int n2 = n < this.entryCount - 1 ? this.offsets[n + 1] : this.index.getPageStore().getPageSize();
        int n3 = this.offsets[n] - n2;
        for (int i = n; i < this.entryCount; ++i) {
            nArray[i] = this.offsets[i + 1] + n3;
        }
        System.arraycopy(this.keys, n + 1, nArray2, n, this.entryCount - n);
        System.arraycopy(this.rows, n + 1, rowArray, n, this.entryCount - n);
        this.start -= 6;
        this.offsets = nArray;
        this.keys = nArray2;
        this.rows = rowArray;
    }

    Cursor find() {
        return new PageScanCursor(this, 0);
    }

    Row getRowAt(int n) throws SQLException {
        Row row = this.rows[n];
        if (row == null) {
            if (this.firstOverflowPageId != 0) {
                PageDataLeafOverflow pageDataLeafOverflow;
                PageStore pageStore = this.index.getPageStore();
                int n2 = pageStore.getPageSize();
                this.data.setPos(n2);
                int n3 = this.firstOverflowPageId;
                int n4 = n2;
                this.data.setPos(n2);
                do {
                    Record record;
                    if ((record = pageStore.getRecord(n3)) == null) {
                        DataPage dataPage = pageStore.readPage(n3);
                        pageDataLeafOverflow = new PageDataLeafOverflow(this, n3, dataPage, n4);
                        continue;
                    }
                    if (!(record instanceof PageDataLeafOverflow)) {
                        throw Message.getInternalError("page:" + n3 + " " + record, null);
                    }
                    pageDataLeafOverflow = (PageDataLeafOverflow)record;
                } while ((n3 = pageDataLeafOverflow.readInto(this.data)) != 0);
            }
            this.data.setPos(this.offsets[n]);
            row = this.index.readRow(this.data);
            row.setPos(this.keys[n]);
            this.rows[n] = row;
        }
        return row;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    PageData split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageDataLeaf pageDataLeaf = new PageDataLeaf(this.index, n2, this.parentPageId, this.index.getPageStore().createDataPage());
        int n3 = n;
        while (n3 < this.entryCount) {
            pageDataLeaf.addRow(this.getRowAt(n));
            this.removeRow(n);
        }
        return pageDataLeaf;
    }

    int getLastKey() throws SQLException {
        if (this.entryCount == 0) {
            return 0;
        }
        return this.getRowAt(this.entryCount - 1).getPos();
    }

    PageDataLeaf getNextPage() throws SQLException {
        if (this.parentPageId == 0) {
            return null;
        }
        PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId);
        return pageDataNode.getNextPage(this.keys[this.entryCount - 1]);
    }

    PageDataLeaf getFirstLeaf() {
        return this;
    }

    protected void remapChildren() throws SQLException {
        if (this.firstOverflowPageId == 0) {
            return;
        }
    }

    boolean remove(int n) throws SQLException {
        int n2 = this.find(n);
        if (this.keys[n2] != n) {
            throw Message.getSQLException(90112, this.index.getSQL() + ": " + n);
        }
        if (this.entryCount == 1) {
            return true;
        }
        this.removeRow(n2);
        this.index.getPageStore().updateRecord(this, true, this.data);
        return false;
    }

    Row getRow(Session session, int n) throws SQLException {
        int n2 = this.find(n);
        return this.getRowAt(n2);
    }

    int getRowCount() throws SQLException {
        return this.entryCount;
    }

    void setRowCountStored(int n) throws SQLException {
    }

    public int getByteCount(DataPage dataPage) throws SQLException {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.write();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    PageStore getPageStore() {
        return this.index.getPageStore();
    }

    private void write() throws SQLException {
        int n;
        int n2;
        if (this.written) {
            return;
        }
        for (n2 = 0; n2 < this.entryCount; ++n2) {
            this.getRowAt(n2);
        }
        this.data.reset();
        this.data.writeInt(this.parentPageId);
        n2 = this.firstOverflowPageId == 0 ? 17 : 1;
        this.data.writeByte((byte)n2);
        this.data.writeInt(this.index.getId());
        this.data.writeShortInt(this.entryCount);
        if (this.firstOverflowPageId != 0) {
            this.data.writeInt(this.firstOverflowPageId);
        }
        if (this.getPos() == 1) {
            System.out.println("pause");
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeInt(this.keys[n]);
            this.data.writeShortInt(this.offsets[n]);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.setPos(this.offsets[n]);
            this.rows[n].write(this.data);
        }
        this.written = true;
    }

    DataPage getDataPage() throws SQLException {
        this.write();
        return this.data;
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf table:" + this.index.getId() + " entries:" + this.entryCount;
    }
}

