/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.ObjectUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueLong
extends Value {
    public static final int PRECISION = 19;
    public static final int DISPLAY_SIZE = 20;
    private static final int STATIC_SIZE = 100;
    private static final ValueLong[] STATIC_CACHE;
    private static final BigInteger MIN;
    private static final BigInteger MAX;
    private final long value;

    private ValueLong(long l) {
        this.value = l;
    }

    public Value add(Value value) throws SQLException {
        ValueLong valueLong = (ValueLong)value;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            int n;
            int n2;
            int n3;
            long l = this.value + valueLong.value;
            int n4 = this.value == 0L ? 0 : (n3 = this.value < 0L ? -1 : 1);
            int n5 = valueLong.value == 0L ? 0 : (n2 = valueLong.value < 0L ? -1 : 1);
            int n6 = l == 0L ? 0 : (n = l < 0L ? -1 : 1);
            if (n3 != n2 || n == n2 || n3 == 0 || n2 == 0) {
                return ValueLong.get(l);
            }
            throw this.getOverflow();
        }
        return ValueLong.get(this.value + valueLong.value);
    }

    public int getSignum() {
        return this.value == 0L ? 0 : (this.value < 0L ? -1 : 1);
    }

    public Value negate() throws SQLException {
        if (SysProperties.OVERFLOW_EXCEPTIONS && this.value == Long.MIN_VALUE) {
            throw this.getOverflow();
        }
        return ValueLong.get(-this.value);
    }

    private SQLException getOverflow() {
        return Message.getSQLException(90110, DataType.getDataType((int)5).name);
    }

    public Value subtract(Value value) throws SQLException {
        ValueLong valueLong = (ValueLong)value;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            int n;
            int n2;
            int n3 = this.value == 0L ? 0 : (n2 = this.value < 0L ? -1 : 1);
            int n4 = valueLong.value == 0L ? 0 : (n = valueLong.value < 0L ? -1 : 1);
            if (n2 == n || n == 0) {
                return ValueLong.get(this.value - valueLong.value);
            }
            return this.add(valueLong.negate());
        }
        return ValueLong.get(this.value - valueLong.value);
    }

    private boolean isInteger(long l) {
        return l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
    }

    public Value multiply(Value value) throws SQLException {
        ValueLong valueLong = (ValueLong)value;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            BigInteger bigInteger;
            long l = this.value * valueLong.value;
            if (this.value == 0L || this.value == 1L || valueLong.value == 0L || valueLong.value == 1L) {
                return ValueLong.get(l);
            }
            if (this.isInteger(this.value) && this.isInteger(valueLong.value)) {
                return ValueLong.get(l);
            }
            BigInteger bigInteger2 = new BigInteger("" + this.value);
            BigInteger bigInteger3 = bigInteger2.multiply(bigInteger = new BigInteger("" + valueLong.value));
            if (bigInteger3.compareTo(MIN) < 0 || bigInteger3.compareTo(MAX) > 0) {
                throw this.getOverflow();
            }
            return ValueLong.get(bigInteger3.longValue());
        }
        return ValueLong.get(this.value * valueLong.value);
    }

    public Value divide(Value value) throws SQLException {
        ValueLong valueLong = (ValueLong)value;
        if (valueLong.value == 0L) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        return ValueLong.get(this.value / valueLong.value);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 5;
    }

    public long getLong() {
        return this.value;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueLong valueLong = (ValueLong)value;
        if (this.value == valueLong.value) {
            return 0;
        }
        return this.value > valueLong.value ? 1 : -1;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 19L;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public Object getObject() {
        return ObjectUtils.getLong(this.value);
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setLong(n, this.value);
    }

    public static ValueLong get(long l) {
        if (l >= 0L && l < 100L) {
            return STATIC_CACHE[(int)l];
        }
        return (ValueLong)Value.cache(new ValueLong(l));
    }

    public int getDisplaySize() {
        return 20;
    }

    public boolean equals(Object object) {
        return object instanceof ValueLong && this.value == ((ValueLong)object).value;
    }

    static {
        MIN = new BigInteger("-9223372036854775808");
        MAX = new BigInteger("9223372036854775807");
        STATIC_CACHE = new ValueLong[100];
        for (int i = 0; i < 100; ++i) {
            ValueLong.STATIC_CACHE[i] = new ValueLong(i);
        }
    }
}

