/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class PageBtreeCursor
implements Cursor {
    private final Session session;
    private final PageBtreeIndex index;
    private final SearchRow last;
    private PageBtreeLeaf current;
    private int i;
    private SearchRow currentSearchRow;
    private Row currentRow;

    PageBtreeCursor(Session session, PageBtreeIndex pageBtreeIndex, SearchRow searchRow) {
        this.session = session;
        this.index = pageBtreeIndex;
        this.last = searchRow;
    }

    void setCurrent(PageBtreeLeaf pageBtreeLeaf, int n) {
        this.current = pageBtreeLeaf;
        this.i = n;
    }

    public Row get() throws SQLException {
        if (this.currentRow == null && this.currentSearchRow != null) {
            this.currentRow = this.index.getRow(this.session, this.currentSearchRow.getPos());
        }
        return this.currentRow;
    }

    public int getPos() {
        return this.currentSearchRow.getPos();
    }

    public SearchRow getSearchRow() {
        return this.currentSearchRow;
    }

    public boolean next() throws SQLException {
        if (this.current == null) {
            return false;
        }
        if (this.i >= this.current.getEntryCount()) {
            this.current.nextPage(this);
            this.i = 0;
            if (this.current == null) {
                return false;
            }
        }
        this.currentSearchRow = this.current.getRow(this.i);
        if (this.last != null && this.index.compareRows(this.currentSearchRow, this.last) > 0) {
            this.currentSearchRow = null;
            this.currentRow = null;
            return false;
        }
        ++this.i;
        return true;
    }

    public boolean previous() throws SQLException {
        --this.i;
        return true;
    }

    Session getSession() {
        return this.session;
    }
}

