/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.store.Record;
import org.h2.util.BitField;

public class PageFreeList
extends Record {
    private static final int DATA_START = 5;
    private final PageStore store;
    private final BitField used = new BitField();
    private final int pageCount;
    private boolean full;
    private DataPage data;

    PageFreeList(PageStore pageStore, int n) {
        this.setPos(n);
        this.store = pageStore;
        this.pageCount = (pageStore.getPageSize() - 5) * 8;
        this.used.set(0);
    }

    int allocate() throws SQLException {
        if (this.full) {
            return -1;
        }
        int n = this.used.nextClearBit(0);
        if (n >= this.pageCount) {
            this.full = true;
            return -1;
        }
        this.used.set(n);
        this.store.updateRecord(this, true, this.data);
        return n + this.getPos();
    }

    int getLastUsed() {
        return this.used.getLastSetBit() + this.getPos();
    }

    int allocate(int n) throws SQLException {
        int n2 = n - this.getPos();
        if (n2 >= 0 && !this.used.get(n2)) {
            this.used.set(n2);
            this.store.updateRecord(this, true, this.data);
        }
        return n;
    }

    void free(int n) throws SQLException {
        this.full = false;
        this.used.clear(n - this.getPos());
        this.store.updateRecord(this, true, this.data);
    }

    void read() throws SQLException {
        this.data = this.store.createDataPage();
        this.store.readPage(this.getPos(), this.data);
        int n = this.data.readInt();
        int n2 = this.data.readByte();
        if (n2 == 0) {
            return;
        }
        if (n2 != 7 || n != 0) {
            throw Message.getSQLException(90030, "pos:" + this.getPos() + " type:" + n2 + " parent:" + n + " expected type:" + 7);
        }
        for (int i = 0; i < this.pageCount; i += 8) {
            this.used.setByte(i, this.data.readByte());
        }
        this.full = this.used.nextClearBit(0) >= this.pageCount * 8;
    }

    public int getByteCount(DataPage dataPage) {
        return this.store.getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.data = this.store.createDataPage();
        this.data.writeInt(0);
        int n = 7;
        this.data.writeByte((byte)n);
        for (int i = 0; i < this.pageCount; i += 8) {
            this.data.writeByte((byte)this.used.getByte(i));
        }
        this.store.writePage(this.getPos(), this.data);
    }

    static int getPagesAddressed(int n) {
        return (n - 5) * 8;
    }

    public int getMemorySize() {
        return this.store.getPageSize() >> 2;
    }
}

