/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.message.Message;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.util.MemoryUtils;

class PageBtreeNode
extends PageBtree {
    private static final int CHILD_OFFSET_PAIR_LENGTH = 8;
    private static final int CHILD_OFFSET_PAIR_START = 15;
    private int[] childPageIds;
    private int rowCount = -1;

    PageBtreeNode(PageBtreeIndex pageBtreeIndex, int n, int n2, Data data) {
        super(pageBtreeIndex, n, n2, data);
        this.start = 15;
    }

    void read() {
        this.data.setPos(4);
        int n = this.data.readByte();
        this.onlyPosition = (n & 0x10) == 0;
        this.entryCount = this.data.readShortInt();
        this.rowCount = this.data.readInt();
        this.rowCount = -1;
        this.childPageIds = new int[this.entryCount + 1];
        this.childPageIds[this.entryCount] = this.data.readInt();
        this.rows = PageStore.newSearchRows(this.entryCount);
        this.offsets = MemoryUtils.newInts(this.entryCount);
        for (int i = 0; i < this.entryCount; ++i) {
            this.childPageIds[i] = this.data.readInt();
            this.offsets[i] = this.data.readInt();
        }
        this.check();
        this.start = this.data.length();
    }

    private int addChildTry(SearchRow searchRow) throws SQLException {
        int n;
        if (this.entryCount < 2) {
            return 0;
        }
        int n2 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
        int n3 = this.index.getPageStore().getPageSize();
        int n4 = n = this.entryCount == 0 ? n3 : this.offsets[this.entryCount - 1];
        if (n - n2 < this.start + 8) {
            return this.entryCount / 2 + 1;
        }
        return 0;
    }

    private void addChild(int n, int n2, SearchRow searchRow) throws SQLException {
        int n3;
        int n4;
        int n5 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
        int n6 = this.index.getPageStore().getPageSize();
        int n7 = n4 = this.entryCount == 0 ? n6 : this.offsets[this.entryCount - 1];
        if (n4 - n5 < this.start + 8) {
            this.onlyPosition = true;
            n3 = n6;
            for (int i = 0; i < this.entryCount; ++i) {
                this.offsets[i] = n3 -= this.index.getRowSize(this.data, this.getRow(i), this.onlyPosition);
            }
            n4 = this.entryCount == 0 ? n6 : this.offsets[this.entryCount - 1];
            n5 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
            if (SysProperties.CHECK && n4 - n5 < this.start + 8) {
                throw Message.throwInternalError();
            }
        }
        n3 = n4 - n5;
        int[] nArray = new int[this.entryCount + 1];
        SearchRow[] searchRowArray = new SearchRow[this.entryCount + 1];
        int[] nArray2 = new int[this.entryCount + 2];
        if (this.childPageIds != null) {
            System.arraycopy(this.childPageIds, 0, nArray2, 0, n + 1);
        }
        if (this.entryCount > 0) {
            System.arraycopy(this.offsets, 0, nArray, 0, n);
            System.arraycopy(this.rows, 0, searchRowArray, 0, n);
            if (n < this.entryCount) {
                for (int i = n; i < this.entryCount; ++i) {
                    nArray[i + 1] = this.offsets[i] - n5;
                }
                n3 = (n == 0 ? n6 : this.offsets[n - 1]) - n5;
                System.arraycopy(this.rows, n, searchRowArray, n + 1, this.entryCount - n);
                System.arraycopy(this.childPageIds, n + 1, nArray2, n + 2, this.entryCount - n);
            }
        }
        nArray[n] = n3;
        searchRowArray[n] = searchRow;
        nArray2[n + 1] = n2;
        this.start += 8;
        this.offsets = nArray;
        this.rows = searchRowArray;
        this.childPageIds = nArray2;
        ++this.entryCount;
    }

    int addRowTry(SearchRow searchRow) throws SQLException {
        int n;
        PageBtree pageBtree;
        int n2;
        while ((n2 = (pageBtree = this.index.getPage(this.childPageIds[n = this.find(searchRow, false, false)])).addRowTry(searchRow)) != 0) {
            SearchRow searchRow2 = pageBtree.getRow(n2 - 1);
            int n3 = this.addChildTry(searchRow2);
            if (n3 != 0) {
                return n3;
            }
            PageBtree pageBtree2 = pageBtree.split(n2);
            this.addChild(n, pageBtree2.getPos(), searchRow2);
            this.index.getPageStore().updateRecord(pageBtree, true, pageBtree.data);
            this.index.getPageStore().updateRecord(pageBtree2, true, pageBtree2.data);
            this.index.getPageStore().updateRecord(this, true, this.data);
        }
        this.updateRowCount(1);
        this.written = false;
        return 0;
    }

    private void updateRowCount(int n) {
    }

    PageBtree split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageBtreeNode pageBtreeNode = new PageBtreeNode(this.index, n2, this.parentPageId, this.index.getPageStore().createData());
        if (this.onlyPosition) {
            pageBtreeNode.onlyPosition = true;
        }
        int n3 = this.childPageIds[n];
        int n4 = n;
        while (n4 < this.entryCount) {
            pageBtreeNode.addChild(pageBtreeNode.entryCount, this.childPageIds[n + 1], this.rows[n]);
            this.removeChild(n);
        }
        n4 = this.childPageIds[n - 1];
        this.removeChild(n - 1);
        this.childPageIds[n - 1] = n4;
        if (pageBtreeNode.childPageIds == null) {
            pageBtreeNode.childPageIds = new int[1];
        }
        pageBtreeNode.childPageIds[0] = n3;
        pageBtreeNode.remapChildren();
        return pageBtreeNode;
    }

    protected void remapChildren() throws SQLException {
        for (int n : this.childPageIds) {
            PageBtree pageBtree = this.index.getPage(n);
            pageBtree.setParentPageId(this.getPos());
            this.index.getPageStore().updateRecord(pageBtree, true, pageBtree.data);
        }
    }

    void init(PageBtree pageBtree, SearchRow searchRow, PageBtree pageBtree2) throws SQLException {
        this.entryCount = 0;
        this.childPageIds = new int[]{pageBtree.getPos()};
        this.rows = new SearchRow[0];
        this.offsets = MemoryUtils.EMPTY_INTS;
        this.addChild(0, pageBtree2.getPos(), searchRow);
        this.rowCount = pageBtree.getRowCount() + pageBtree2.getRowCount();
        this.check();
    }

    void find(PageBtreeCursor pageBtreeCursor, SearchRow searchRow, boolean bl) throws SQLException {
        int n = this.find(searchRow, bl, false);
        if (n > this.entryCount) {
            if (this.parentPageId == 0) {
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.find(pageBtreeCursor, searchRow, bl);
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n]);
        pageBtree.find(pageBtreeCursor, searchRow, bl);
    }

    void last(PageBtreeCursor pageBtreeCursor) throws SQLException {
        int n = this.childPageIds[this.entryCount];
        this.index.getPage(n).last(pageBtreeCursor);
    }

    PageBtreeLeaf getFirstLeaf() throws SQLException {
        int n = this.childPageIds[0];
        return this.index.getPage(n).getFirstLeaf();
    }

    PageBtreeLeaf getLastLeaf() throws SQLException {
        int n = this.childPageIds[this.entryCount - 1];
        return this.index.getPage(n).getLastLeaf();
    }

    boolean remove(SearchRow searchRow) throws SQLException {
        int n = this.find(searchRow, false, false);
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n]);
        boolean bl = pageBtree.remove(searchRow);
        this.updateRowCount(-1);
        if (!bl) {
            return false;
        }
        this.index.getPageStore().freePage(pageBtree.getPos(), true, pageBtree.data);
        if (this.entryCount < 1) {
            return true;
        }
        this.written = false;
        this.removeChild(n);
        this.index.getPageStore().updateRecord(this, true, this.data);
        return false;
    }

    int getRowCount() throws SQLException {
        if (this.rowCount == -1) {
            int n = 0;
            for (int n2 : this.childPageIds) {
                PageBtree pageBtree = this.index.getPage(n2);
                n += pageBtree.getRowCount();
            }
            this.rowCount = n;
        }
        return this.rowCount;
    }

    void setRowCountStored(int n) {
        this.rowCount = n;
    }

    private void check() {
        for (int n : this.childPageIds) {
            if (n != 0) continue;
            Message.throwInternalError();
        }
    }

    public int getByteCount(DataPage dataPage) {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.check();
        this.write();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void write() throws SQLException {
        int n;
        if (this.written) {
            return;
        }
        this.readAllRows();
        this.data.reset();
        this.data.writeInt(this.parentPageId);
        this.data.writeByte((byte)(5 | (this.onlyPosition ? 0 : 16)));
        this.data.writeShortInt(this.entryCount);
        this.data.writeInt(this.rowCount);
        this.data.writeInt(this.childPageIds[this.entryCount]);
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeInt(this.childPageIds[n]);
            this.data.writeInt(this.offsets[n]);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.index.writeRow(this.data, this.offsets[n], this.rows[n], this.onlyPosition);
        }
        this.written = true;
    }

    void freeChildren() throws SQLException {
        for (int i = 0; i <= this.entryCount; ++i) {
            int n = this.childPageIds[i];
            PageBtree pageBtree = this.index.getPage(n);
            this.index.getPageStore().freePage(n, false, null);
            pageBtree.freeChildren();
        }
    }

    private void removeChild(int n) throws SQLException {
        this.readAllRows();
        --this.entryCount;
        this.written = false;
        if (this.entryCount < 0) {
            Message.throwInternalError();
        }
        SearchRow[] searchRowArray = PageStore.newSearchRows(this.entryCount);
        int[] nArray = MemoryUtils.newInts(this.entryCount);
        int[] nArray2 = new int[this.entryCount + 1];
        System.arraycopy(this.offsets, 0, nArray, 0, Math.min(this.entryCount, n));
        System.arraycopy(this.rows, 0, searchRowArray, 0, Math.min(this.entryCount, n));
        System.arraycopy(this.childPageIds, 0, nArray2, 0, n);
        if (this.entryCount > n) {
            System.arraycopy(this.rows, n + 1, searchRowArray, n, this.entryCount - n);
            int n2 = n > 0 ? this.offsets[n - 1] : this.index.getPageStore().getPageSize();
            int n3 = n2 - this.offsets[n];
            for (int i = n; i < this.entryCount; ++i) {
                nArray[i] = this.offsets[i + 1] + n3;
            }
        }
        System.arraycopy(this.childPageIds, n + 1, nArray2, n, this.entryCount - n + 1);
        this.offsets = nArray;
        this.rows = searchRowArray;
        this.childPageIds = nArray2;
        this.start -= 8;
    }

    void nextPage(PageBtreeCursor pageBtreeCursor, int n) throws SQLException {
        int n2;
        for (n2 = 0; n2 < this.childPageIds.length; ++n2) {
            if (this.childPageIds[n2] != n) continue;
            ++n2;
            break;
        }
        if (n2 > this.entryCount) {
            if (this.parentPageId == 0) {
                pageBtreeCursor.setCurrent(null, 0);
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.nextPage(pageBtreeCursor, this.getPos());
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n2]);
        PageBtreeLeaf pageBtreeLeaf = pageBtree.getFirstLeaf();
        pageBtreeCursor.setCurrent(pageBtreeLeaf, 0);
    }

    void previousPage(PageBtreeCursor pageBtreeCursor, int n) throws SQLException {
        int n2;
        for (n2 = this.childPageIds.length - 1; n2 >= 0; --n2) {
            if (this.childPageIds[n2] != n) continue;
            --n2;
            break;
        }
        if (n2 < 0) {
            if (this.parentPageId == 0) {
                pageBtreeCursor.setCurrent(null, 0);
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.previousPage(pageBtreeCursor, this.getPos());
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n2]);
        PageBtreeLeaf pageBtreeLeaf = pageBtree.getLastLeaf();
        pageBtreeCursor.setCurrent(pageBtreeLeaf, pageBtreeLeaf.entryCount - 1);
    }

    public String toString() {
        return "page[" + this.getPos() + "] btree node table:" + this.index.getId() + " entries:" + this.entryCount;
    }
}

