/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.PageIndex;
import org.h2.message.Message;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

public class Insert
extends Prepared {
    private Table table;
    private Column[] columns;
    private ObjectArray<Expression[]> list = ObjectArray.newInstance();
    private Query query;
    private boolean sortedInsertMode;

    public Insert(Session session) {
        super(session);
    }

    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expressionArray) {
        this.list.add(expressionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() throws SQLException {
        Database database = this.session.getDatabase();
        PageIndex pageIndex = null;
        if (this.sortedInsertMode && database.isPageStoreEnabled() && database.isPersistent()) {
            pageIndex = (PageIndex)this.table.getScanIndex(this.session);
            pageIndex.setSortedInsertMode(true);
        }
        try {
            int n = this.insertRows();
            return n;
        }
        finally {
            if (pageIndex != null) {
                pageIndex.setSortedInsertMode(false);
            }
        }
    }

    private int insertRows() throws SQLException {
        int n;
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0);
        this.table.fire(this.session, 1, true);
        if (this.list.size() > 0) {
            n = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                Expression[] expressionArray = this.list.get(i);
                Row row = this.table.getTemplateRow();
                this.setCurrentRowNumber(i + 1);
                for (int j = 0; j < this.columns.length; ++j) {
                    Column column = this.columns[j];
                    int n2 = column.getColumnId();
                    Expression expression = expressionArray[j];
                    if (expression == null) continue;
                    expression = expression.optimize(this.session);
                    try {
                        Value value = column.convert(expression.getValue(this.session));
                        row.setValue(n2, value);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        throw this.setRow(sQLException, i, this.getSQL(expressionArray));
                    }
                }
                this.table.validateConvertUpdateSequence(this.session, row);
                this.table.fireBeforeRow(this.session, null, row);
                this.table.lock(this.session, true, false);
                this.table.addRow(this.session, row);
                this.session.log(this.table, (short)0, row);
                this.table.fireAfterRow(this.session, null, row, false);
                ++n;
            }
        } else {
            ResultInterface resultInterface = this.query.query(0);
            n = 0;
            this.table.lock(this.session, true, false);
            while (resultInterface.next()) {
                Value[] valueArray = resultInterface.currentRow();
                Row row = this.table.getTemplateRow();
                this.setCurrentRowNumber(++n);
                for (int i = 0; i < this.columns.length; ++i) {
                    Column column = this.columns[i];
                    int n3 = column.getColumnId();
                    try {
                        Value value = column.convert(valueArray[i]);
                        row.setValue(n3, value);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        throw this.setRow(sQLException, n, this.getSQL(valueArray));
                    }
                }
                this.table.validateConvertUpdateSequence(this.session, row);
                this.table.fireBeforeRow(this.session, null, row);
                this.table.addRow(this.session, row);
                this.session.log(this.table, (short)0, row);
                this.table.fireAfterRow(this.session, null, row, false);
            }
            resultInterface.close();
        }
        this.table.fire(this.session, 1, false);
        return n;
    }

    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
        statementBuilder.append(this.table.getSQL()).append('(');
        for (Column expressionArray : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expressionArray.getSQL());
        }
        statementBuilder.append(")\n");
        if (this.list.size() > 0) {
            statementBuilder.append("VALUES ");
            int n = 0;
            for (Expression[] expressionArray : this.list) {
                if (n++ > 0) {
                    statementBuilder.append(", ");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (Expression expression : expressionArray) {
                    statementBuilder.appendExceptFirst(", ");
                    if (expression == null) {
                        statementBuilder.append("DEFAULT");
                        continue;
                    }
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
            }
        } else {
            statementBuilder.append(this.query.getPlanSQL());
        }
        return statementBuilder.toString();
    }

    public void prepare() throws SQLException {
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && this.list.get(0).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (Expression[] expressionArray : this.list) {
                if (expressionArray.length != this.columns.length) {
                    throw Message.getSQLException(21002);
                }
                for (int i = 0; i < expressionArray.length; ++i) {
                    Expression expression = expressionArray[i];
                    if (expression == null) continue;
                    if ((expression = expression.optimize(this.session)) instanceof Parameter) {
                        Parameter parameter = (Parameter)expression;
                        parameter.setColumn(this.columns[i]);
                    }
                    expressionArray[i] = expression;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw Message.getSQLException(21002);
            }
        }
    }

    public boolean isTransactional() {
        return true;
    }

    public ResultInterface queryMeta() {
        return null;
    }

    public void setSortedInsertMode(boolean bl) {
        this.sortedInsertMode = bl;
    }
}

